/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.page;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.print.ViewType;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.controlsfx.control.PropertySheet;

public abstract class PageBase
extends DateControl {
    private final BooleanProperty hidden = new SimpleBooleanProperty((Object)this, "hidden", false);
    private final ObjectProperty<DateTimeFormatter> dateTimeFormatter = new SimpleObjectProperty((Object)this, "datePattern", (Object)DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM));
    private final BooleanProperty showDate = new SimpleBooleanProperty((Object)this, "showDate", true);
    private final BooleanProperty showNavigation = new SimpleBooleanProperty((Object)this, "showNavigation", true);
    private final String PAGE_BASE_CATEGORY = "Page Base";

    protected PageBase() {
        this.setMinSize(0.0, 0.0);
        this.getStyleClass().add((Object)"calendar-page");
    }

    public final BooleanProperty hiddenProperty() {
        return this.hidden;
    }

    public final void setHidden(boolean hidden) {
        this.hiddenProperty().set(hidden);
    }

    public final boolean isHidden() {
        return this.hiddenProperty().get();
    }

    public Node getToolBarControls() {
        return null;
    }

    public final ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty() {
        return this.dateTimeFormatter;
    }

    public final DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.dateTimeFormatterProperty().get();
    }

    public final void setDateTimeFormatter(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter);
        this.dateTimeFormatterProperty().set((Object)formatter);
    }

    public final BooleanProperty showDateProperty() {
        return this.showDate;
    }

    public final void setShowDate(boolean show) {
        this.showDateProperty().set(show);
    }

    public final boolean isShowDateHeader() {
        return this.showDateProperty().get();
    }

    public final BooleanProperty showNavigationProperty() {
        return this.showNavigation;
    }

    public final void setShowNavigation(boolean show) {
        this.showNavigationProperty().set(show);
    }

    public final boolean isShowNavigation() {
        return this.showNavigationProperty().get();
    }

    public abstract ViewType getPrintViewType();

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(PageBase.this.showNavigationProperty());
            }

            public void setValue(Object value) {
                PageBase.this.setShowNavigation((Boolean)value);
            }

            public Object getValue() {
                return PageBase.this.isShowNavigation();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Navigation";
            }

            public String getDescription() {
                return "Navigation controls (back, forward, today)";
            }

            public String getCategory() {
                return "Page Base";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(PageBase.this.showDateProperty());
            }

            public void setValue(Object value) {
                PageBase.this.setShowDate((Boolean)value);
            }

            public Object getValue() {
                return PageBase.this.isShowDateHeader();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Date";
            }

            public String getDescription() {
                return "Header with current month, day, or year.";
            }

            public String getCategory() {
                return "Page Base";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(PageBase.this.dateTimeFormatterProperty());
            }

            public void setValue(Object value) {
                PageBase.this.setDateTimeFormatter((DateTimeFormatter)value);
            }

            public Object getValue() {
                return PageBase.this.getDateTimeFormatter();
            }

            public Class<?> getType() {
                return DateTimeFormatter.class;
            }

            public String getName() {
                return "Date Time Formatter";
            }

            public String getDescription() {
                return "Date time formatter";
            }

            public String getCategory() {
                return "Page Base";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(PageBase.this.hiddenProperty());
            }

            public void setValue(Object value) {
                PageBase.this.setHidden((Boolean)value);
            }

            public Object getValue() {
                return PageBase.this.isHidden();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Hidden";
            }

            public String getDescription() {
                return "Hides the page from the user.";
            }

            public String getCategory() {
                return "Page Base";
            }
        });
        return items;
    }
}

