/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.page;

import com.calendarfx.view.AgendaView;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DetailedDayView;
import com.calendarfx.view.Messages;
import com.calendarfx.view.YearMonthView;
import com.calendarfx.view.page.PageBase;
import com.calendarfx.view.print.ViewType;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.utils.FontAwesomeIconFactory;
import impl.com.calendarfx.view.page.DayPageSkin;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.SegmentedButton;

public class DayPage
extends PageBase {
    private AgendaView agendaView;
    private YearMonthView yearMonthView;
    private DetailedDayView detailedDayView;
    private Node toolBarControls;
    private HBox toolbarControls;
    private final BooleanProperty showLayoutButton = new SimpleBooleanProperty((Object)this, "showLayoutButton", true);
    private final ObjectProperty<DayPageLayout> dayPageLayout = new SimpleObjectProperty((Object)this, "dayPageLayout", (Object)DayPageLayout.STANDARD);
    private final BooleanProperty showDayPageLayoutControls = new SimpleBooleanProperty((Object)this, "showDayPageLayoutControls", true);
    private static final String DAY_PAGE_CATEGORY = "Day Page";

    public DayPage() {
        this.getStyleClass().add((Object)"day-page");
        this.setDateTimeFormatter(DateTimeFormatter.ofPattern(Messages.getString("DayPage.DATE_FORMATTER")));
        this.agendaView = new AgendaView();
        this.yearMonthView = new YearMonthView();
        this.detailedDayView = new DetailedDayView();
        this.toolBarControls = this.createToolBarControls();
    }

    protected Skin<?> createDefaultSkin() {
        return new DayPageSkin(this);
    }

    @Override
    public Node getToolBarControls() {
        return this.toolBarControls;
    }

    private Node createToolBarControls() {
        ToggleButton agendaOnlyButton = new ToggleButton();
        ToggleButton dayOnlyButton = new ToggleButton();
        ToggleButton standardButton = new ToggleButton();
        Text listIcon = FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.LIST);
        listIcon.getStyleClass().addAll((Object[])new String[]{"button-icon"});
        agendaOnlyButton.setGraphic((Node)listIcon);
        agendaOnlyButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Text calendarIcon = FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.CALENDAR);
        calendarIcon.getStyleClass().addAll((Object[])new String[]{"button-icon"});
        dayOnlyButton.setGraphic((Node)calendarIcon);
        dayOnlyButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Text standardIcon = FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.COLUMNS);
        standardIcon.getStyleClass().addAll((Object[])new String[]{"button-icon"});
        standardButton.setGraphic((Node)standardIcon);
        standardButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        agendaOnlyButton.setOnAction(evt -> this.setDayPageLayout(DayPageLayout.AGENDA_ONLY));
        dayOnlyButton.setOnAction(evt -> this.setDayPageLayout(DayPageLayout.DAY_ONLY));
        standardButton.setOnAction(evt -> this.setDayPageLayout(DayPageLayout.STANDARD));
        SegmentedButton segmentedButton = new SegmentedButton(new ToggleButton[]{agendaOnlyButton, standardButton, dayOnlyButton});
        segmentedButton.getStyleClass().add((Object)"layout-button");
        segmentedButton.visibleProperty().bind((ObservableValue)this.showDayPageLayoutControlsProperty());
        switch (this.getDayPageLayout()) {
            case AGENDA_ONLY: {
                agendaOnlyButton.setSelected(true);
                break;
            }
            case DAY_ONLY: {
                dayOnlyButton.setSelected(true);
                break;
            }
            case STANDARD: {
                standardButton.setSelected(true);
                break;
            }
        }
        agendaOnlyButton.setTooltip(new Tooltip(Messages.getString("DayPage.TOOLTIP_MAXIMIZE_AGENDA_LIST")));
        dayOnlyButton.setTooltip(new Tooltip(Messages.getString("DayPage.TOOLTIP_MAXIMIZE_DAY_VIEW")));
        standardButton.setTooltip(new Tooltip(Messages.getString("DayPage.TOOLTIP_STANDARD_LAYOUT")));
        ToggleButton layoutButton = new ToggleButton();
        layoutButton.setTooltip(new Tooltip(Messages.getString("DayPage.TOOLTIP_LAYOUT")));
        layoutButton.setId("layout-button");
        Text layoutIcon = FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.TABLE);
        layoutIcon.getStyleClass().addAll((Object[])new String[]{"button-icon", "layout-button-icon"});
        layoutButton.setGraphic((Node)layoutIcon);
        layoutButton.setSelected(this.getLayout().equals((Object)DateControl.Layout.SWIMLANE));
        layoutButton.setOnAction(evt -> {
            if (layoutButton.isSelected()) {
                this.setLayout(DateControl.Layout.SWIMLANE);
            } else {
                this.setLayout(DateControl.Layout.STANDARD);
            }
        });
        this.toolbarControls = new HBox();
        this.toolbarControls.setSpacing(10.0);
        this.updateToolBarControls(segmentedButton, layoutButton);
        this.showLayoutButtonProperty().addListener(it -> this.updateToolBarControls(segmentedButton, layoutButton));
        return this.toolbarControls;
    }

    private void updateToolBarControls(SegmentedButton segmentedButton, ToggleButton layoutButton) {
        if (this.isShowLayoutButton()) {
            this.toolbarControls.getChildren().setAll((Object[])new Node[]{layoutButton, segmentedButton});
        } else {
            this.toolbarControls.getChildren().setAll((Object[])new Node[]{segmentedButton});
        }
    }

    public final BooleanProperty showLayoutButtonProperty() {
        return this.showLayoutButton;
    }

    public final boolean isShowLayoutButton() {
        return this.showLayoutButton.get();
    }

    public final void setShowLayoutButton(boolean show) {
        this.showLayoutButton.set(show);
    }

    public final ObjectProperty<DayPageLayout> dayPageLayoutProperty() {
        return this.dayPageLayout;
    }

    public final void setDayPageLayout(DayPageLayout layout) {
        Objects.requireNonNull(layout);
        this.dayPageLayoutProperty().set((Object)layout);
    }

    public final DayPageLayout getDayPageLayout() {
        return (DayPageLayout)((Object)this.dayPageLayoutProperty().get());
    }

    public final BooleanProperty showDayPageLayoutControlsProperty() {
        return this.showDayPageLayoutControls;
    }

    public final boolean isShowDayPageLayoutControls() {
        return this.showDayPageLayoutControlsProperty().get();
    }

    public final void setShowDayPageLayoutControls(boolean show) {
        this.showDayPageLayoutControlsProperty().set(show);
    }

    public final AgendaView getAgendaView() {
        return this.agendaView;
    }

    public final YearMonthView getYearMonthView() {
        return this.yearMonthView;
    }

    public final DetailedDayView getDetailedDayView() {
        return this.detailedDayView;
    }

    @Override
    public final void goForward() {
        this.setDate(this.getDate().plusDays(1L));
    }

    @Override
    public final void goBack() {
        this.setDate(this.getDate().minusDays(1L));
    }

    @Override
    public final ViewType getPrintViewType() {
        return ViewType.DAY_VIEW;
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayPage.this.dayPageLayoutProperty());
            }

            public void setValue(Object value) {
                DayPage.this.setDayPageLayout((DayPageLayout)((Object)value));
            }

            public Object getValue() {
                return DayPage.this.getDayPageLayout();
            }

            public Class<?> getType() {
                return DayPageLayout.class;
            }

            public String getName() {
                return "Day Page Layout";
            }

            public String getDescription() {
                return "Layout of the day page";
            }

            public String getCategory() {
                return DayPage.DAY_PAGE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayPage.this.showDayPageLayoutControlsProperty());
            }

            public void setValue(Object value) {
                DayPage.this.setShowDayPageLayoutControls((Boolean)value);
            }

            public Object getValue() {
                return DayPage.this.isShowDayPageLayoutControls();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Day Page Layout Controls";
            }

            public String getDescription() {
                return "Show Day Page Layout Controls";
            }

            public String getCategory() {
                return DayPage.DAY_PAGE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayPage.this.showLayoutButtonProperty());
            }

            public void setValue(Object value) {
                DayPage.this.setShowLayoutButton((Boolean)value);
            }

            public Object getValue() {
                return DayPage.this.isShowLayoutButton();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Layout Button";
            }

            public String getDescription() {
                return "Can the user access the button to toggle the layout or not.";
            }

            public String getCategory() {
                return DayPage.DAY_PAGE_CATEGORY;
            }
        });
        return items;
    }

    public static enum DayPageLayout {
        STANDARD,
        AGENDA_ONLY,
        DAY_ONLY;

    }
}

