/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.YearMonthView;
import impl.com.calendarfx.view.YearViewSkin;
import java.time.Month;
import java.time.Year;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.control.Skin;

public class YearView
extends DateControl {
    private static final String DEFAULT_STYLE_CLASS = "year-view";
    private Map<Month, YearMonthView> viewMap = new HashMap<Month, YearMonthView>();
    private final ReadOnlyObjectWrapper<Year> year = new ReadOnlyObjectWrapper((Object)this, "year", (Object)Year.from(this.getToday()));

    public YearView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.dateProperty().addListener(evt -> this.year.set((Object)Year.from(this.getDate())));
        for (Month month : Month.values()) {
            YearMonthView view = new YearMonthView();
            this.viewMap.put(month, view);
            view.setShowYear(false);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new YearViewSkin(this);
    }

    public final ReadOnlyObjectProperty<Year> yearProperty() {
        return this.year.getReadOnlyProperty();
    }

    public final Year getYear() {
        return (Year)this.yearProperty().get();
    }

    public final YearMonthView getMonthView(Month month) {
        return this.viewMap.get(month);
    }
}

