/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.WeekDayView;
import impl.com.calendarfx.view.ViewHelper;
import impl.com.calendarfx.view.WeekViewSkin;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class WeekView
extends DayViewBase {
    private static final String DEFAULT_STYLE_CLASS = "week-view";
    private final ObservableList<WeekDayView> weekDayViews = FXCollections.observableArrayList();
    private final IntegerProperty numberOfDays = new SimpleIntegerProperty((Object)this, "numberOfDays", 7);
    private final BooleanProperty adjustToFirstDayOfWeek = new SimpleBooleanProperty((Object)this, "adjustToFirstDayOfWeek", true);
    private final ObjectProperty<Callback<WeekDayParameter, WeekDayView>> weekDayViewFactory = new SimpleObjectProperty((Object)this, "weekDayViewFactory");
    private final ReadOnlyObjectWrapper<LocalDate> startDate = new ReadOnlyObjectWrapper((Object)this, "startDate");
    private final ReadOnlyObjectWrapper<LocalDate> endDate = new ReadOnlyObjectWrapper((Object)this, "endDate");
    private static final String WEEK_VIEW_CATEGORY = "Week View";

    public WeekView() {
        this(7);
    }

    public WeekView(int numberOfDays) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setWeekDayViewFactory((Callback<WeekDayParameter, WeekDayView>)((Callback)param -> new WeekDayView()));
        this.setNumberOfDays(numberOfDays);
        this.dateProperty().addListener(it -> this.updateStartAndEndDates());
        this.updateStartAndEndDates();
    }

    protected Skin<?> createDefaultSkin() {
        return new WeekViewSkin(this);
    }

    @Override
    public ZonedDateTime getZonedDateTimeAt(double x, double y) {
        WeekDayView view = this.getWeekDayViewAt(x);
        if (view != null) {
            return ZonedDateTime.of(ViewHelper.getLocationTime(view, y, false, true), this.getZoneId());
        }
        return super.getZonedDateTimeAt(x, y);
    }

    private WeekDayView getWeekDayViewAt(double x) {
        for (WeekDayView view : this.getWeekDayViews()) {
            Bounds bounds = view.getBoundsInParent();
            if (!(bounds.getMinX() <= x) || !(bounds.getMaxX() >= x)) continue;
            return view;
        }
        return null;
    }

    public final ObservableList<WeekDayView> getWeekDayViews() {
        return this.weekDayViews;
    }

    public final IntegerProperty numberOfDaysProperty() {
        return this.numberOfDays;
    }

    public final int getNumberOfDays() {
        return this.numberOfDaysProperty().get();
    }

    public final void setNumberOfDays(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("invalid number of days, must be larger than 0 but was " + number);
        }
        this.numberOfDaysProperty().set(number);
    }

    public final BooleanProperty adjustToFirstDayOfWeekProperty() {
        return this.adjustToFirstDayOfWeek;
    }

    public final boolean isAdjustToFirstDayOfWeek() {
        return this.adjustToFirstDayOfWeekProperty().get();
    }

    public final void setAdjustToFirstDayOfWeek(boolean adjust) {
        this.adjustToFirstDayOfWeekProperty().set(adjust);
    }

    public final ObjectProperty<Callback<WeekDayParameter, WeekDayView>> weekDayViewFactoryProperty() {
        return this.weekDayViewFactory;
    }

    public final Callback<WeekDayParameter, WeekDayView> getWeekDayViewFactory() {
        return (Callback)this.weekDayViewFactoryProperty().get();
    }

    public final void setWeekDayViewFactory(Callback<WeekDayParameter, WeekDayView> factory) {
        Objects.requireNonNull(factory);
        this.weekDayViewFactoryProperty().set(factory);
    }

    private void updateStartAndEndDates() {
        LocalDate date = this.calculateStartDate();
        this.startDate.set((Object)date);
        this.endDate.set((Object)date.plusDays(this.getNumberOfDays() - 1));
    }

    private LocalDate calculateStartDate() {
        LocalDate startDate = this.getDate();
        if (this.isAdjustToFirstDayOfWeek()) {
            LocalDate newStartDate = startDate.with(ChronoField.DAY_OF_WEEK, this.getFirstDayOfWeek().getValue());
            startDate = newStartDate.isAfter(startDate) ? newStartDate.minusWeeks(1L) : newStartDate;
        }
        return startDate;
    }

    public final ReadOnlyObjectProperty<LocalDate> startDateProperty() {
        return this.startDate;
    }

    public final LocalDate getStartDate() {
        return (LocalDate)this.startDate.get();
    }

    public final ReadOnlyObjectProperty<LocalDate> endDateProperty() {
        return this.endDate;
    }

    public final LocalDate getEndDate() {
        return (LocalDate)this.endDate.get();
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(WeekView.this.numberOfDaysProperty());
            }

            public void setValue(Object value) {
                WeekView.this.setNumberOfDays((Integer)value);
            }

            public Object getValue() {
                return WeekView.this.getNumberOfDays();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public String getName() {
                return "Number of Days";
            }

            public String getDescription() {
                return "Number of Days";
            }

            public String getCategory() {
                return WeekView.WEEK_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(WeekView.this.adjustToFirstDayOfWeekProperty());
            }

            public void setValue(Object value) {
                WeekView.this.setAdjustToFirstDayOfWeek((Boolean)value);
            }

            public Object getValue() {
                return WeekView.this.isAdjustToFirstDayOfWeek();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Adjust to first day of week";
            }

            public String getDescription() {
                return "Adjust to first day of week";
            }

            public String getCategory() {
                return WeekView.WEEK_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(WeekView.this.startDateProperty());
            }

            public void setValue(Object value) {
            }

            public Object getValue() {
                return WeekView.this.getStartDate();
            }

            public Class<?> getType() {
                return LocalDate.class;
            }

            public String getName() {
                return "Start date (read-only)";
            }

            public String getDescription() {
                return "Start date (read-only)";
            }

            public String getCategory() {
                return WeekView.WEEK_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(WeekView.this.endDateProperty());
            }

            public void setValue(Object value) {
            }

            public Object getValue() {
                return WeekView.this.getEndDate();
            }

            public Class<?> getType() {
                return LocalDate.class;
            }

            public String getName() {
                return "End date (read-only)";
            }

            public String getDescription() {
                return "End date (read-only)";
            }

            public String getCategory() {
                return WeekView.WEEK_VIEW_CATEGORY;
            }
        });
        return items;
    }

    public static final class WeekDayParameter {
        private WeekView weekView;

        public WeekDayParameter(WeekView weekView) {
            this.weekView = Objects.requireNonNull(weekView);
        }

        public WeekView getWeekView() {
            return this.weekView;
        }
    }
}

