/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.CalendarFXControl;
import impl.com.calendarfx.view.WeekFieldsViewSkin;
import java.time.DayOfWeek;
import java.time.temporal.WeekFields;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import org.controlsfx.control.PropertySheet;

public class WeekFieldsView
extends CalendarFXControl {
    private static final String DEFAULT_STYLE_CLASS = "week-fields";
    private final ObjectProperty<WeekFields> weekFieldsProperty = new SimpleObjectProperty<WeekFields>((Object)this, "weekFields", WeekFields.ISO){

        public void setValue(WeekFields v) {
            if (v == null) {
                throw new IllegalArgumentException("week fields value can not be null");
            }
            super.setValue((Object)v);
        }
    };
    private final ReadOnlyObjectWrapper<DayOfWeek> firstDayOfWeek = new ReadOnlyObjectWrapper((Object)this, "firstDayOfWeek");
    private final ReadOnlyIntegerWrapper minimalDaysInFirstWeek = new ReadOnlyIntegerWrapper((Object)this, "minimalDaysInFirstWeek");

    public WeekFieldsView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.weekFieldsProperty.addListener(it -> this.updateReadOnyProperties());
        this.updateReadOnyProperties();
    }

    protected Skin<?> createDefaultSkin() {
        return new WeekFieldsViewSkin(this);
    }

    public final ObjectProperty<WeekFields> weekFieldsProperty() {
        return this.weekFieldsProperty;
    }

    public final WeekFields getWeekFields() {
        return (WeekFields)this.weekFieldsProperty.get();
    }

    public final void setWeekFields(WeekFields fields) {
        this.weekFieldsProperty.set((Object)fields);
    }

    private void updateReadOnyProperties() {
        WeekFields fields = this.getWeekFields();
        this.firstDayOfWeek.set((Object)fields.getFirstDayOfWeek());
        this.minimalDaysInFirstWeek.set(fields.getMinimalDaysInFirstWeek());
    }

    public final ReadOnlyObjectProperty<DayOfWeek> firstDayOfWeekProperty() {
        return this.firstDayOfWeek.getReadOnlyProperty();
    }

    public final DayOfWeek getFirstDayOfWeek() {
        return (DayOfWeek)this.firstDayOfWeek.get();
    }

    public final ReadOnlyIntegerProperty minimalDaysInFirstWeekProperty() {
        return this.minimalDaysInFirstWeek.getReadOnlyProperty();
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek.get();
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return WeekFields.class;
            }

            public String getCategory() {
                return "Week Fields View";
            }

            public String getName() {
                return "Week Fields";
            }

            public String getDescription() {
                return "Week Fields";
            }

            public Object getValue() {
                return WeekFieldsView.this.getWeekFields();
            }

            public void setValue(Object o) {
                WeekFieldsView.this.setWeekFields((WeekFields)o);
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(WeekFieldsView.this.weekFieldsProperty);
            }
        });
        return items;
    }
}

