/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.Messages;
import impl.com.calendarfx.view.util.Util;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class VirtualGrid {
    public static final VirtualGrid OFF = new VirtualGrid(Messages.getString("VirtualGrid.OFF"), Messages.getString("VirtualGrid.OFF_SHORT"), ChronoUnit.SECONDS, 1){

        @Override
        public Instant adjustTime(Instant instant, ZoneId zoneId, boolean roundUp, DayOfWeek firstDayOfWeek) {
            return instant;
        }

        @Override
        public LocalDateTime adjustTime(LocalDateTime time, boolean roundUp, DayOfWeek firstDayOfWeek) {
            return time;
        }

        @Override
        public ZonedDateTime adjustTime(ZonedDateTime time, boolean roundUp, DayOfWeek firstDayOfWeek) {
            return time;
        }
    };
    private String name;
    private String shortName;
    private ChronoUnit unit;
    private int amount;

    public VirtualGrid(String name, String shortName, ChronoUnit unit, int amount) {
        this.name = Objects.requireNonNull(name);
        this.shortName = Objects.requireNonNull(shortName);
        this.unit = Objects.requireNonNull(unit);
        if (amount <= 0) {
            throw new IllegalArgumentException("grid amount must be larger than 0 but was " + amount);
        }
        this.amount = amount;
    }

    public final String getName() {
        return this.name;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final ChronoUnit getUnit() {
        return this.unit;
    }

    public final int getAmount() {
        return this.amount;
    }

    public ZonedDateTime adjustTime(ZonedDateTime time, boolean roundUp, DayOfWeek firstDayOfWeek) {
        Instant instant = time.toInstant();
        ZoneId zoneId = time.getZone();
        instant = this.adjustTime(instant, zoneId, roundUp, firstDayOfWeek);
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    public Instant adjustTime(Instant instant, ZoneId zoneId, boolean roundUp, DayOfWeek firstDayOfWeek) {
        Objects.requireNonNull(instant);
        Objects.requireNonNull(zoneId);
        Objects.requireNonNull(firstDayOfWeek);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
        if (roundUp) {
            zonedDateTime = zonedDateTime.plus(this.getAmount(), this.getUnit());
        }
        zonedDateTime = Util.truncate(zonedDateTime, this.getUnit(), this.getAmount(), firstDayOfWeek);
        return Instant.from(zonedDateTime);
    }

    public LocalDateTime adjustTime(LocalDateTime time, boolean roundUp, DayOfWeek firstDayOfWeek) {
        Objects.requireNonNull(time);
        if (roundUp) {
            time = time.plus(this.getAmount(), this.getUnit());
        }
        return Util.truncate(time, this.getUnit(), this.getAmount(), firstDayOfWeek);
    }

    public String toString() {
        return "VirtualGrid [name=" + this.name + ", shortName=" + this.shortName + ", unit=" + this.unit + ", amount=" + this.amount + "]";
    }
}

