/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.view.CalendarFXControl;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import impl.com.calendarfx.view.SourceViewSkin;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Skin;

public class SourceView
extends CalendarFXControl {
    private static final String DEFAULT_STYLE_CLASS = "source-view";
    private final ObservableList<CalendarSource> calendarSources = FXCollections.observableArrayList();
    private final ObservableMap<Calendar, BooleanProperty> calendarVisibilityMap = FXCollections.observableHashMap();

    public SourceView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.createContextMenu();
    }

    protected Skin<?> createDefaultSkin() {
        return new SourceViewSkin(this);
    }

    public final void bind(DateControl dateControl) {
        Bindings.bindContentBidirectional(this.calendarSources, dateControl.getCalendarSources());
        Bindings.bindContentBidirectional(this.calendarVisibilityMap, dateControl.getCalendarVisibilityMap());
    }

    public final void unbind(DateControl dateControl) {
        Bindings.unbindContentBidirectional(this.calendarSources, dateControl.getCalendarSources());
        Bindings.unbindContentBidirectional(this.calendarVisibilityMap, dateControl.getCalendarVisibilityMap());
    }

    public final ObservableList<CalendarSource> getCalendarSources() {
        return this.calendarSources;
    }

    public final ObservableMap<Calendar, BooleanProperty> getCalendarVisibilityMap() {
        return this.calendarVisibilityMap;
    }

    public final BooleanProperty getCalendarVisibilityProperty(Calendar calendar) {
        return (BooleanProperty)this.calendarVisibilityMap.computeIfAbsent((Object)calendar, cal -> new SimpleBooleanProperty((Object)this, "visible", true));
    }

    public final boolean isCalendarVisible(Calendar calendar) {
        BooleanProperty prop = this.getCalendarVisibilityProperty(calendar);
        return prop.get();
    }

    public final void setCalendarVisibility(Calendar calendar, boolean visible) {
        BooleanProperty prop = this.getCalendarVisibilityProperty(calendar);
        prop.set(visible);
    }

    private void createContextMenu() {
        MenuItem disableAll = new MenuItem();
        disableAll.setText(Messages.getString("SourceView.DISABLE_ALL"));
        disableAll.setOnAction(evt -> {
            for (CalendarSource source : this.getCalendarSources()) {
                for (Calendar calendar : source.getCalendars()) {
                    this.setCalendarVisibility(calendar, false);
                }
            }
        });
        MenuItem enableAll = new MenuItem();
        enableAll.setText(Messages.getString("SourceView.ENABLE_ALL"));
        enableAll.setOnAction(evt -> {
            for (CalendarSource source : this.getCalendarSources()) {
                for (Calendar calendar : source.getCalendars()) {
                    this.setCalendarVisibility(calendar, true);
                }
            }
        });
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Object[])new MenuItem[]{disableAll, enableAll});
        this.setContextMenu(contextMenu);
    }
}

