/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.CalendarFXControl;
import impl.com.calendarfx.view.SearchResultViewSkin;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.control.Skin;

public class SearchResultView
extends CalendarFXControl {
    private static final String DEFAULT_STYLE_CLASS = "search-result-view";
    private static final String SELECTED_ENTRY = "selected.search.result";
    private final SearchService searchService;
    private final ObservableList<Entry<?>> searchResults = FXCollections.observableArrayList();
    private final ObservableList<CalendarSource> calendarSources = FXCollections.observableArrayList();
    private final ReadOnlyObjectWrapper<Entry<?>> selectedEntry = new ReadOnlyObjectWrapper((Object)this, "selectedEntry");
    private final ObjectProperty<ZoneId> zoneId = new SimpleObjectProperty((Object)this, "zoneId", (Object)ZoneId.systemDefault());
    private final StringProperty searchText = new SimpleStringProperty((Object)this, "searchText");

    public SearchResultView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.searchService = new SearchService();
        this.searchService.setOnSucceeded(evt -> this.updateSearchResults());
        this.searchTextProperty().addListener(it -> {
            if (LoggingDomain.SEARCH.isLoggable(Level.FINE)) {
                LoggingDomain.SEARCH.fine("restarting search service");
            }
            this.searchService.restart();
        });
        MapChangeListener listener = change -> {
            if (change.wasAdded() && change.getKey().equals(SELECTED_ENTRY)) {
                Entry entry = (Entry)change.getValueAdded();
                this.selectedEntry.set((Object)entry);
                this.getProperties().remove((Object)SELECTED_ENTRY);
            }
        };
        this.getProperties().addListener(listener);
    }

    protected Skin<?> createDefaultSkin() {
        return new SearchResultViewSkin(this);
    }

    public final ObservableList<Entry<?>> getSearchResults() {
        return this.searchResults;
    }

    private void updateSearchResults() {
        List searchResult = (List)this.searchService.getValue();
        this.getSearchResults().setAll((Collection)searchResult);
    }

    public final ObservableList<CalendarSource> getCalendarSources() {
        return this.calendarSources;
    }

    public final ReadOnlyObjectProperty<Entry<?>> selectedEntryProperty() {
        return this.selectedEntry.getReadOnlyProperty();
    }

    public final Entry<?> getSelectedEntry() {
        return (Entry)this.selectedEntryProperty().get();
    }

    public final ObjectProperty<ZoneId> zoneIdProperty() {
        return this.zoneId;
    }

    public final void setZoneId(ZoneId zoneId) {
        Objects.requireNonNull(zoneId);
        this.zoneIdProperty().set((Object)zoneId);
    }

    public final ZoneId getZoneId() {
        return (ZoneId)this.zoneIdProperty().get();
    }

    public final StringProperty searchTextProperty() {
        return this.searchText;
    }

    public final String getSearchText() {
        return (String)this.searchTextProperty().get();
    }

    public final void setSearchText(String text) {
        this.searchTextProperty().set((Object)text);
    }

    private class SearchService
    extends Service<List<Entry<?>>> {
        protected Task<List<Entry<?>>> createTask() {
            return new SearchTask();
        }

        class SearchTask
        extends Task<List<Entry<?>>> {
            SearchTask() {
            }

            protected List<Entry<?>> call() throws Exception {
                if (!this.isCancelled()) {
                    String searchText = SearchResultView.this.getSearchText();
                    if (LoggingDomain.SEARCH.isLoggable(Level.FINE)) {
                        LoggingDomain.SEARCH.fine("search text: " + searchText);
                    }
                    if (searchText == null || searchText.trim().isEmpty()) {
                        return Collections.emptyList();
                    }
                    Thread.sleep(200L);
                    if (LoggingDomain.SEARCH.isLoggable(Level.FINE)) {
                        LoggingDomain.SEARCH.fine("performing search after delay");
                    }
                    if (!this.isCancelled()) {
                        ArrayList totalResult = new ArrayList();
                        for (CalendarSource source : SearchResultView.this.getCalendarSources()) {
                            if (LoggingDomain.SEARCH.isLoggable(Level.FINE)) {
                                LoggingDomain.SEARCH.fine("searching in source " + source.getName());
                            }
                            for (Calendar calendar : source.getCalendars()) {
                                if (LoggingDomain.SEARCH.isLoggable(Level.FINE)) {
                                    LoggingDomain.SEARCH.fine("searching in calendar " + calendar.getName());
                                }
                                if (this.isCancelled()) continue;
                                try {
                                    List<Entry<?>> result = calendar.findEntries(searchText);
                                    if (result == null) continue;
                                    for (Entry<?> entry : result) {
                                        totalResult.add(entry);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (LoggingDomain.SEARCH.isLoggable(Level.FINE) && this.isCancelled()) {
                            LoggingDomain.SEARCH.fine("search was canceled");
                        }
                        if (LoggingDomain.SEARCH.isLoggable(Level.FINE)) {
                            LoggingDomain.SEARCH.fine("found " + totalResult.size() + " entries");
                        }
                        return totalResult;
                    }
                }
                if (LoggingDomain.SEARCH.isLoggable(Level.FINE)) {
                    LoggingDomain.SEARCH.fine("returning empty search result");
                }
                return Collections.emptyList();
            }
        }
    }
}

