/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.CalendarFXControl;
import com.google.ical.values.RRule;
import impl.com.calendarfx.view.RecurrenceViewSkin;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Skin;

public class RecurrenceView
extends CalendarFXControl {
    private final ObjectProperty<LocalDate> startDate = new SimpleObjectProperty<LocalDate>((Object)this, "startDate", LocalDate.now()){

        public void set(LocalDate newValue) {
            Objects.requireNonNull(newValue);
            super.set((Object)newValue);
        }
    };
    private final StringProperty recurrenceRule = new SimpleStringProperty((Object)this, "recurrenceRule", "RRULE:FREQ=DAILY"){

        public void set(String newValue) {
            try {
                if (newValue != null) {
                    new RRule(newValue);
                }
                super.set(newValue);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    };
    private final BooleanProperty showSummary = new SimpleBooleanProperty((Object)this, "showSummary", true);

    public RecurrenceView() {
        this.getStyleClass().add((Object)"recurrence-view");
    }

    protected Skin<?> createDefaultSkin() {
        return new RecurrenceViewSkin(this);
    }

    public final ObjectProperty<LocalDate> startDateProperty() {
        return this.startDate;
    }

    public final void setStartDate(LocalDate date) {
        Objects.requireNonNull(date);
        this.startDateProperty().set((Object)date);
    }

    public final LocalDate getStartDate() {
        return (LocalDate)this.startDateProperty().get();
    }

    public final StringProperty recurrenceRuleProperty() {
        return this.recurrenceRule;
    }

    public final void setRecurrenceRule(String rule) {
        this.recurrenceRuleProperty().set((Object)rule);
    }

    public final String getRecurrenceRule() {
        return (String)this.recurrenceRuleProperty().get();
    }

    public final BooleanProperty showSummaryProperty() {
        return this.showSummary;
    }

    public final boolean isShowSummary() {
        return this.showSummaryProperty().get();
    }

    public final void setShowSummary(boolean show) {
        this.showSummaryProperty().set(show);
    }
}

