/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Entry;
import com.calendarfx.view.CreateDeleteHandler;
import com.calendarfx.view.MonthEntryView;
import com.calendarfx.view.MonthViewBase;
import com.calendarfx.view.ZonedDateTimeProvider;
import impl.com.calendarfx.view.MonthViewSkin;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class MonthView
extends MonthViewBase
implements ZonedDateTimeProvider {
    private static final String DEFAULT_STYLE_CLASS = "month-view";
    private final BooleanProperty showCurrentWeek = new SimpleBooleanProperty((Object)this, "showCurrentWeek", true);
    private final BooleanProperty showWeekends = new SimpleBooleanProperty((Object)this, "showWeekends", true);
    private final BooleanProperty showWeekdays = new SimpleBooleanProperty((Object)this, "showWeekdays", true);
    private final BooleanProperty showTimedEntries = new SimpleBooleanProperty((Object)this, "showTimedEntries", true);
    private final BooleanProperty showFullDayEntries = new SimpleBooleanProperty((Object)this, "showFullDayEntries", true);
    private final ObjectProperty<Callback<Entry<?>, MonthEntryView>> entryViewFactory = new SimpleObjectProperty((Object)this, "entryViewFactory");
    private static final String MONTH_PAGE_CATEGORY = "Month View";

    public MonthView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setEntryViewFactory(MonthEntryView::new);
        new CreateDeleteHandler(this);
        this.getSelectedDates().addListener(it -> {
            if (this.getSelectedDates().size() == 1) {
                LocalDate date = (LocalDate)this.getSelectedDates().iterator().next();
                this.setDate(date);
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new MonthViewSkin(this);
    }

    @Override
    public final ZonedDateTime getZonedDateTimeAt(double x, double y) {
        MonthViewSkin skin = (MonthViewSkin)this.getSkin();
        return skin.getZonedDateTimeAt(x, y);
    }

    public final BooleanProperty showCurrentWeekProperty() {
        return this.showCurrentWeek;
    }

    public final void setShowCurrentWeek(boolean show) {
        this.showCurrentWeekProperty().set(show);
    }

    public final boolean isShowCurrentWeek() {
        return this.showCurrentWeekProperty().get();
    }

    public final BooleanProperty showWeekendsProperty() {
        return this.showWeekends;
    }

    public final void setShowWeekends(boolean show) {
        this.showWeekendsProperty().set(show);
    }

    public final boolean isShowWeekends() {
        return this.showWeekendsProperty().get();
    }

    public final BooleanProperty showWeekdaysProperty() {
        return this.showWeekdays;
    }

    public final void setShowWeekdays(boolean show) {
        this.showWeekdaysProperty().set(show);
    }

    public final boolean isShowWeekdays() {
        return this.showWeekdaysProperty().get();
    }

    public final BooleanProperty showTimedEntriesProperty() {
        return this.showTimedEntries;
    }

    public final void setShowTimedEntries(boolean show) {
        this.showTimedEntriesProperty().set(show);
    }

    public final boolean isShowTimedEntries() {
        return this.showTimedEntriesProperty().get();
    }

    public final BooleanProperty showFullDayEntriesProperty() {
        return this.showFullDayEntries;
    }

    public final void setShowFullDayEntries(boolean show) {
        this.showFullDayEntriesProperty().set(show);
    }

    public final boolean isShowFullDayEntries() {
        return this.showFullDayEntriesProperty().get();
    }

    public final ObjectProperty<Callback<Entry<?>, MonthEntryView>> entryViewFactoryProperty() {
        return this.entryViewFactory;
    }

    public final Callback<Entry<?>, MonthEntryView> getEntryViewFactory() {
        return (Callback)this.entryViewFactoryProperty().get();
    }

    public final void setEntryViewFactory(Callback<Entry<?>, MonthEntryView> factory) {
        Objects.requireNonNull(factory);
        this.entryViewFactoryProperty().set(factory);
    }

    @Override
    public void goBack() {
        this.setDate(this.getDate().minusMonths(1L));
    }

    @Override
    public void goForward() {
        this.setDate(this.getDate().plusMonths(1L));
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthView.this.showWeekdaysProperty());
            }

            public void setValue(Object value) {
                MonthView.this.setShowWeekdays((Boolean)value);
            }

            public Object getValue() {
                return MonthView.this.isShowWeekdays();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Weekdays";
            }

            public String getDescription() {
                return "Show or hide the weekdays";
            }

            public String getCategory() {
                return MonthView.MONTH_PAGE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthView.this.showWeekendsProperty());
            }

            public void setValue(Object value) {
                MonthView.this.setShowWeekends((Boolean)value);
            }

            public Object getValue() {
                return MonthView.this.isShowWeekends();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Weekends";
            }

            public String getDescription() {
                return "Mark the weekends";
            }

            public String getCategory() {
                return MonthView.MONTH_PAGE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthView.this.showWeekNumbersProperty());
            }

            public void setValue(Object value) {
                MonthView.this.setShowWeekNumbers((Boolean)value);
            }

            public Object getValue() {
                return MonthView.this.isShowWeekNumbers();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Week Numbers";
            }

            public String getDescription() {
                return "Show or hide the week numbers";
            }

            public String getCategory() {
                return MonthView.MONTH_PAGE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthView.this.showCurrentWeekProperty());
            }

            public void setValue(Object value) {
                MonthView.this.setShowCurrentWeek((Boolean)value);
            }

            public Object getValue() {
                return MonthView.this.isShowCurrentWeek();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Current Week";
            }

            public String getDescription() {
                return "Highlight the current week";
            }

            public String getCategory() {
                return MonthView.MONTH_PAGE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthView.this.showFullDayEntriesProperty());
            }

            public void setValue(Object value) {
                MonthView.this.setShowFullDayEntries((Boolean)value);
            }

            public Object getValue() {
                return MonthView.this.isShowFullDayEntries();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Full Day Entries";
            }

            public String getDescription() {
                return "Show full day entries";
            }

            public String getCategory() {
                return MonthView.MONTH_PAGE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthView.this.showTimedEntriesProperty());
            }

            public void setValue(Object value) {
                MonthView.this.setShowTimedEntries((Boolean)value);
            }

            public Object getValue() {
                return MonthView.this.isShowTimedEntries();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Timed Entries";
            }

            public String getDescription() {
                return "Show timed entries";
            }

            public String getCategory() {
                return MonthView.MONTH_PAGE_CATEGORY;
            }
        });
        return items;
    }
}

