/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DateSelectionModel;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RequestEvent;
import impl.com.calendarfx.view.MonthSheetViewSkin;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.time.temporal.WeekFields;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.PickResult;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class MonthSheetView
extends DateControl {
    private static final String DEFAULT_STYLE_CLASS = "month-sheet-view";
    private static final String USAGE_VERY_LOW = "usage-very-low";
    private static final String USAGE_LOW = "usage-low";
    private static final String USAGE_MEDIUM = "usage-medium";
    private static final String USAGE_HIGH = "usage-high";
    private static final String USAGE_VERY_HIGH = "usage-very-high";
    private double ctxMenuScreenX;
    private double ctxMenuScreenY;
    private DateCell dateCell;
    private final ObjectProperty<Callback<DateParameter, DateCell>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
    private final ObjectProperty<Callback<HeaderParameter, Node>> headerCellFactory = new SimpleObjectProperty((Object)this, "headerCellFactory");
    private final ObjectProperty<WeekDayLayoutStrategy> weekDayLayout = new SimpleObjectProperty((Object)this, "weekDayLayout", (Object)WeekDayLayoutStrategy.STANDARD);
    private final ObjectProperty<ViewUnit> viewUnit = new SimpleObjectProperty((Object)this, "viewUnit", (Object)ViewUnit.YEAR);
    private final ObjectProperty<ViewUnit> extendedViewUnit = new SimpleObjectProperty((Object)this, "extendedViewUnit", (Object)ViewUnit.MONTH);
    private final IntegerProperty extendedUnitsForward = new SimpleIntegerProperty((Object)this, "extendedUnitsForward");
    private final IntegerProperty extendedUnitsBackward = new SimpleIntegerProperty((Object)this, "extendedUnitsBackward");
    private final BooleanProperty showWeekNumber = new SimpleBooleanProperty((Object)this, "showWeekNumber", true);
    private final ObjectProperty<DateSelectionModel> dateSelectionModel = new SimpleObjectProperty((Object)this, "dateSelectionModel", (Object)new DateSelectionModel());
    private final ObjectProperty<ClickBehaviour> clickBehaviour = new SimpleObjectProperty((Object)this, "clickBehaviour", (Object)ClickBehaviour.PERFORM_SELECTION);
    private static final String MONTH_SHEET_VIEW_CATEGORY = "Month Sheet View";

    public MonthSheetView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setHeaderCellFactory((Callback<HeaderParameter, Node>)((Callback)param -> new MonthHeaderCell(param.getView(), param.getYearMonth())));
        this.setContextMenu(this.createContextMenu());
        this.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, evt -> {
            PickResult pickResult = evt.getPickResult();
            Node intersectedNode = pickResult.getIntersectedNode();
            this.dateCell = intersectedNode != null && intersectedNode instanceof DateCell ? (DateCell)intersectedNode : null;
            this.ctxMenuScreenX = evt.getScreenX();
            this.ctxMenuScreenY = evt.getScreenY();
        });
        this.setCellFactory((Callback<DateParameter, DateCell>)((Callback)param -> new SimpleDateCell(param.getView(), param.getDate())));
    }

    protected Skin<?> createDefaultSkin() {
        return new MonthSheetViewSkin(this);
    }

    private ContextMenu createContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem newEntry = new MenuItem(Messages.getString("MonthSheetView.ADD_NEW_EVENT"));
        newEntry.setOnAction(evt -> {
            LocalDate date = this.getDateSelectionModel().getLastSelected();
            Entry<?> entry = this.createEntryAt(ZonedDateTime.of(date, LocalTime.of(12, 0), this.getZoneId()));
            Callback<DateControl.EntryDetailsParameter, Boolean> callback = this.getEntryDetailsCallback();
            DateControl.EntryDetailsParameter param = new DateControl.EntryDetailsParameter(null, this, entry, (Node)this.dateCell, this.ctxMenuScreenX, this.ctxMenuScreenY);
            callback.call((Object)param);
        });
        contextMenu.getItems().add((Object)newEntry);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        RadioMenuItem standardCellItem = new RadioMenuItem(Messages.getString("MonthSheetView.STANDARD_CELLS"));
        RadioMenuItem detailCellItem = new RadioMenuItem(Messages.getString("MonthSheetView.DETAIL_CELLS"));
        RadioMenuItem usageCellItem = new RadioMenuItem(Messages.getString("MonthSheetView.USAGE_CELLS"));
        RadioMenuItem badgeCellItem = new RadioMenuItem(Messages.getString("MonthSheetView.BADGE_CELLS"));
        standardCellItem.setOnAction(evt -> this.setCellFactory((Callback<DateParameter, DateCell>)((Callback)param -> new SimpleDateCell(param.getView(), param.getDate()))));
        detailCellItem.setOnAction(evt -> this.setCellFactory((Callback<DateParameter, DateCell>)((Callback)param -> new DetailedDateCell(param.getView(), param.getDate()))));
        usageCellItem.setOnAction(evt -> this.setCellFactory((Callback<DateParameter, DateCell>)((Callback)param -> new UsageDateCell(param.getView(), param.getDate()))));
        badgeCellItem.setOnAction(evt -> this.setCellFactory((Callback<DateParameter, DateCell>)((Callback)param -> new BadgeDateCell(param.getView(), param.getDate()))));
        ToggleGroup group = new ToggleGroup();
        group.getToggles().addAll((Object[])new Toggle[]{standardCellItem, detailCellItem, usageCellItem, badgeCellItem});
        contextMenu.getItems().addAll((Object[])new MenuItem[]{standardCellItem, detailCellItem, usageCellItem, badgeCellItem});
        standardCellItem.setSelected(true);
        return contextMenu;
    }

    public final ObjectProperty<Callback<DateParameter, DateCell>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final Callback<DateParameter, DateCell> getCellFactory() {
        return (Callback)this.cellFactoryProperty().get();
    }

    public final void setCellFactory(Callback<DateParameter, DateCell> factory) {
        Objects.requireNonNull(factory);
        this.cellFactoryProperty().set(factory);
    }

    public final ObjectProperty<Callback<HeaderParameter, Node>> headerCellFactoryProperty() {
        return this.headerCellFactory;
    }

    public final Callback<HeaderParameter, Node> getHeaderCellFactory() {
        return (Callback)this.headerCellFactoryProperty().get();
    }

    public final void setHeaderCellFactory(Callback<HeaderParameter, Node> factory) {
        Objects.requireNonNull(factory);
        this.headerCellFactoryProperty().set(factory);
    }

    public final ObjectProperty<WeekDayLayoutStrategy> weekDayLayoutProperty() {
        return this.weekDayLayout;
    }

    public final WeekDayLayoutStrategy getWeekDayLayout() {
        return (WeekDayLayoutStrategy)((Object)this.weekDayLayoutProperty().get());
    }

    public final void setWeekDayLayout(WeekDayLayoutStrategy weekDayLayout) {
        this.weekDayLayoutProperty().set((Object)weekDayLayout);
    }

    public final ObjectProperty<ViewUnit> viewUnitProperty() {
        return this.viewUnit;
    }

    public final ViewUnit getViewUnit() {
        return (ViewUnit)((Object)this.viewUnitProperty().get());
    }

    public final void setViewUnit(ViewUnit unit) {
        Objects.requireNonNull(unit);
        this.viewUnitProperty().set((Object)unit);
    }

    public final ObjectProperty<ViewUnit> extendedViewUnitProperty() {
        return this.extendedViewUnit;
    }

    public final ViewUnit getExtendedViewUnit() {
        return (ViewUnit)((Object)this.extendedViewUnitProperty().get());
    }

    public final void setExtendedViewUnit(ViewUnit unit) {
        Objects.requireNonNull(unit);
        this.extendedViewUnitProperty().set((Object)unit);
    }

    public final IntegerProperty extendedUnitsForwardProperty() {
        return this.extendedUnitsForward;
    }

    public final int getExtendedUnitsForward() {
        return this.extendedUnitsForwardProperty().get();
    }

    public final void setExtendedUnitsForward(int units) {
        if (units < 0) {
            throw new IllegalArgumentException("number of units can not be negative but was " + units);
        }
        this.extendedUnitsForwardProperty().set(units);
    }

    public final IntegerProperty extendedUnitsBackwardProperty() {
        return this.extendedUnitsBackward;
    }

    public final int getExtendedUnitsBackward() {
        return this.extendedUnitsBackwardProperty().get();
    }

    public final void setExtendedUnitsBackward(int units) {
        if (units < 0) {
            throw new IllegalArgumentException("number of units can not be negative but was " + units);
        }
        this.extendedUnitsBackwardProperty().set(units);
    }

    public final YearMonth getStartMonth() {
        return this.getViewUnit().getStartMonth(this.getDate());
    }

    public final YearMonth getEndMonth() {
        return this.getViewUnit().getEndMonth(this.getDate());
    }

    public final YearMonth getExtendedStartMonth() {
        return this.getStartMonth().minusMonths(this.getExtendedViewUnit().toMonths(this.getExtendedUnitsBackward()));
    }

    public final YearMonth getExtendedEndMonth() {
        return this.getEndMonth().plusMonths(this.getExtendedViewUnit().toMonths(this.getExtendedUnitsForward()));
    }

    public final boolean isExtendedMonth(YearMonth month) {
        if (month != null) {
            YearMonth extendedStart = this.getExtendedStartMonth();
            if ((month.equals(extendedStart) || month.isAfter(extendedStart)) && month.isBefore(this.getStartMonth())) {
                return true;
            }
            YearMonth extendedEnd = this.getExtendedEndMonth();
            if ((month.equals(extendedEnd) || month.isBefore(extendedEnd)) && month.isAfter(this.getEndMonth())) {
                return true;
            }
        }
        return false;
    }

    public final boolean isVisibleDate(LocalDate date) {
        if (date != null) {
            YearMonth extendedStart = this.getExtendedStartMonth();
            YearMonth extendedEnd = this.getExtendedEndMonth();
            LocalDate startDate = extendedStart.atDay(1);
            LocalDate endDate = extendedEnd.atEndOfMonth();
            if ((date.equals(startDate) || date.isAfter(startDate)) && (date.equals(endDate) || date.isBefore(endDate))) {
                return true;
            }
        }
        return false;
    }

    public final BooleanProperty showWeekNumberProperty() {
        return this.showWeekNumber;
    }

    public final boolean isShowWeekNumber() {
        return this.showWeekNumberProperty().get();
    }

    public final void setShowWeekNumber(boolean show) {
        this.showWeekNumberProperty().set(show);
    }

    public final ObjectProperty<DateSelectionModel> dateSelectionModelProperty() {
        return this.dateSelectionModel;
    }

    public final DateSelectionModel getDateSelectionModel() {
        return (DateSelectionModel)this.dateSelectionModelProperty().get();
    }

    public final void setDateSelectionModel(DateSelectionModel model) {
        Objects.requireNonNull(model);
        this.dateSelectionModelProperty().set((Object)model);
    }

    public final ObjectProperty<ClickBehaviour> clickBehaviourProperty() {
        return this.clickBehaviour;
    }

    public final void setClickBehaviour(ClickBehaviour behaviour) {
        Objects.requireNonNull(behaviour);
        this.clickBehaviourProperty().set((Object)behaviour);
    }

    public final ClickBehaviour getClickBehaviour() {
        return (ClickBehaviour)((Object)this.clickBehaviourProperty().get());
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthSheetView.this.clickBehaviourProperty());
            }

            public void setValue(Object value) {
                MonthSheetView.this.setClickBehaviour((ClickBehaviour)((Object)value));
            }

            public Object getValue() {
                return MonthSheetView.this.getClickBehaviour();
            }

            public Class<?> getType() {
                return ClickBehaviour.class;
            }

            public String getName() {
                return "Click Behaviour";
            }

            public String getDescription() {
                return "Click behaviour";
            }

            public String getCategory() {
                return MonthSheetView.MONTH_SHEET_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return WeekDayLayoutStrategy.class;
            }

            public String getCategory() {
                return MonthSheetView.MONTH_SHEET_VIEW_CATEGORY;
            }

            public String getName() {
                return "Week Day Layout";
            }

            public String getDescription() {
                return "The layout strategy for the week day on the months";
            }

            public Object getValue() {
                return MonthSheetView.this.getWeekDayLayout();
            }

            public void setValue(Object value) {
                MonthSheetView.this.setWeekDayLayout((WeekDayLayoutStrategy)((Object)value));
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthSheetView.this.weekDayLayoutProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return ViewUnit.class;
            }

            public String getCategory() {
                return MonthSheetView.MONTH_SHEET_VIEW_CATEGORY;
            }

            public String getName() {
                return "View Unit";
            }

            public String getDescription() {
                return "View Unit";
            }

            public Object getValue() {
                return MonthSheetView.this.getViewUnit();
            }

            public void setValue(Object value) {
                MonthSheetView.this.setViewUnit((ViewUnit)((Object)value));
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthSheetView.this.viewUnitProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return ViewUnit.class;
            }

            public String getCategory() {
                return MonthSheetView.MONTH_SHEET_VIEW_CATEGORY;
            }

            public String getName() {
                return "Extended View Unit";
            }

            public String getDescription() {
                return "Extended View Unit";
            }

            public Object getValue() {
                return MonthSheetView.this.getExtendedViewUnit();
            }

            public void setValue(Object value) {
                MonthSheetView.this.setExtendedViewUnit((ViewUnit)((Object)value));
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthSheetView.this.extendedViewUnitProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return Integer.class;
            }

            public String getCategory() {
                return MonthSheetView.MONTH_SHEET_VIEW_CATEGORY;
            }

            public String getName() {
                return "Extended Units Forward";
            }

            public String getDescription() {
                return "Extended Units Forward";
            }

            public Object getValue() {
                return MonthSheetView.this.getExtendedUnitsForward();
            }

            public void setValue(Object value) {
                MonthSheetView.this.setExtendedUnitsForward((Integer)value);
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthSheetView.this.extendedUnitsForwardProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return Integer.class;
            }

            public String getCategory() {
                return MonthSheetView.MONTH_SHEET_VIEW_CATEGORY;
            }

            public String getName() {
                return "Extended Units Backward";
            }

            public String getDescription() {
                return "Extended Units Backward";
            }

            public Object getValue() {
                return MonthSheetView.this.getExtendedUnitsBackward();
            }

            public void setValue(Object value) {
                MonthSheetView.this.setExtendedUnitsBackward((Integer)value);
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthSheetView.this.extendedUnitsBackwardProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getCategory() {
                return MonthSheetView.MONTH_SHEET_VIEW_CATEGORY;
            }

            public String getName() {
                return "Show Week Number";
            }

            public String getDescription() {
                return "Show Week Number";
            }

            public Object getValue() {
                return MonthSheetView.this.isShowWeekNumber();
            }

            public void setValue(Object value) {
                MonthSheetView.this.setShowWeekNumber((Boolean)value);
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthSheetView.this.showWeekNumberProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return DateSelectionModel.SelectionMode.class;
            }

            public String getCategory() {
                return MonthSheetView.MONTH_SHEET_VIEW_CATEGORY;
            }

            public String getName() {
                return "Date Selection Mode";
            }

            public String getDescription() {
                return "Date Selection Mode";
            }

            public Object getValue() {
                return MonthSheetView.this.getDateSelectionModel().getSelectionMode();
            }

            public void setValue(Object value) {
                MonthSheetView.this.getDateSelectionModel().setSelectionMode((DateSelectionModel.SelectionMode)((Object)value));
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthSheetView.this.getDateSelectionModel().selectionModeProperty());
            }
        });
        return items;
    }

    public static class UsageDateCell
    extends SimpleDateCell {
        public UsageDateCell(MonthSheetView view, LocalDate date) {
            super(view, date);
        }

        @Override
        public void updateEntries(List<Entry<?>> entries) {
            this.getStyleClass().removeAll((Object[])new String[]{MonthSheetView.USAGE_VERY_LOW, MonthSheetView.USAGE_LOW, MonthSheetView.USAGE_MEDIUM, MonthSheetView.USAGE_HIGH, MonthSheetView.USAGE_VERY_HIGH});
            int entryCount = 0;
            if (entries != null) {
                entryCount = entries.size();
            }
            Callback<Integer, DateControl.Usage> usagePolicy = this.getView().getUsagePolicy();
            switch ((DateControl.Usage)((Object)usagePolicy.call((Object)entryCount))) {
                case NONE: {
                    break;
                }
                case VERY_LOW: {
                    this.getStyleClass().add((Object)MonthSheetView.USAGE_VERY_LOW);
                    break;
                }
                case LOW: {
                    this.getStyleClass().add((Object)MonthSheetView.USAGE_LOW);
                    break;
                }
                case MEDIUM: {
                    this.getStyleClass().add((Object)MonthSheetView.USAGE_MEDIUM);
                    break;
                }
                case HIGH: {
                    this.getStyleClass().add((Object)MonthSheetView.USAGE_HIGH);
                    break;
                }
                default: {
                    this.getStyleClass().add((Object)MonthSheetView.USAGE_VERY_HIGH);
                }
            }
        }
    }

    public static class SimpleDateCell
    extends DateCell {
        private static final String DAY_OF_MONTH_STYLE = "day-of-month-label";
        private static final String DAY_OF_WEEK_STYLE = "day-of-week-label";
        private static final String WEEK_NUMBER_STYLE = "week-number-label";
        protected final Label dayOfMonthLabel = new Label();
        protected final Label dayOfWeekLabel = new Label();
        protected final Label weekNumberLabel = new Label();

        public SimpleDateCell(MonthSheetView view, LocalDate date) {
            super(view, date);
            this.dayOfMonthLabel.getStyleClass().add((Object)DAY_OF_MONTH_STYLE);
            this.dayOfWeekLabel.getStyleClass().add((Object)DAY_OF_WEEK_STYLE);
            this.weekNumberLabel.getStyleClass().add((Object)WEEK_NUMBER_STYLE);
            this.dayOfMonthLabel.setManaged(false);
            this.dayOfWeekLabel.setManaged(false);
            this.weekNumberLabel.setManaged(false);
            this.dayOfMonthLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.dayOfWeekLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.weekNumberLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.dayOfMonthLabel.setMouseTransparent(!view.isEnableHyperlinks());
            this.dayOfWeekLabel.setMouseTransparent(true);
            this.weekNumberLabel.setMouseTransparent(true);
            if (date != null) {
                String dayOfWeekName = date.getDayOfWeek().name().toLowerCase();
                this.dayOfMonthLabel.getStyleClass().add((Object)(dayOfWeekName + "-label"));
                this.dayOfWeekLabel.getStyleClass().add((Object)(dayOfWeekName + "-label"));
                this.weekNumberLabel.getStyleClass().add((Object)(dayOfWeekName + "-label"));
            }
            this.getChildren().addAll((Object[])new Node[]{this.dayOfMonthLabel, this.dayOfWeekLabel, this.weekNumberLabel});
            this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.updateLabels();
            if (view.isEnableHyperlinks()) {
                this.dayOfMonthLabel.getStyleClass().add((Object)"date-hyperlink");
                this.dayOfMonthLabel.setOnMouseClicked(evt -> {
                    if (evt.getButton() == MouseButton.PRIMARY && evt.getClickCount() == 1) {
                        this.fireEvent(new RequestEvent((Object)this, (EventTarget)this, date));
                    }
                });
            }
        }

        protected void layoutChildren() {
            Insets insets = this.getInsets();
            double top = insets.getTop();
            double bottom = insets.getBottom();
            double left = insets.getLeft();
            double right = insets.getRight();
            double w = this.getWidth();
            double h = this.getHeight();
            double availableHeight = h - top - bottom;
            double ps1 = this.dayOfMonthLabel.prefWidth(-1.0);
            double ps2 = this.dayOfWeekLabel.prefWidth(-1.0);
            double ps3 = this.weekNumberLabel.prefWidth(-1.0);
            this.dayOfMonthLabel.resizeRelocate(this.snapPosition(left), this.snapPosition(top), this.snapSize(ps1), this.snapSize(availableHeight));
            this.dayOfWeekLabel.resizeRelocate(this.snapPosition(left + ps1), this.snapPosition(top), this.snapSize(ps2), this.snapSize(availableHeight));
            this.weekNumberLabel.resizeRelocate(this.snapPosition(w - right - ps3), this.snapPosition(top), this.snapSize(ps3), this.snapSize(availableHeight));
        }

        protected double computePrefWidth(double height) {
            return this.dayOfMonthLabel.prefWidth(-1.0) + this.dayOfWeekLabel.prefWidth(-1.0) + this.weekNumberLabel.prefWidth(-1.0);
        }

        protected double computePrefHeight(double width) {
            double h = Math.max(this.dayOfMonthLabel.prefHeight(-1.0), Math.max(this.dayOfWeekLabel.prefHeight(-1.0), this.weekNumberLabel.prefHeight(-1.0)));
            return h + this.getInsets().getTop() + this.getInsets().getBottom();
        }

        private void updateLabels() {
            LocalDate date = this.getDate();
            if (date == null) {
                this.dayOfMonthLabel.setText("");
                this.dayOfWeekLabel.setText("");
                this.weekNumberLabel.setText("");
            } else {
                this.dayOfMonthLabel.setText(String.valueOf(date.getDayOfMonth()));
                this.dayOfWeekLabel.setText(date.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.getDefault()));
                MonthSheetView view = this.getView();
                if (view != null && view.isShowWeekNumber()) {
                    WeekFields fields = view.getWeekFields();
                    DayOfWeek firstDayOfWeek = fields.getFirstDayOfWeek();
                    if (date.getDayOfWeek().equals(firstDayOfWeek)) {
                        String weekNumber = Integer.toString(date.get(fields.weekOfYear()));
                        this.weekNumberLabel.setText(weekNumber);
                    }
                }
            }
        }
    }

    public static class BadgeDateCell
    extends SimpleDateCell {
        private Label counterLabel;

        public BadgeDateCell(MonthSheetView view, LocalDate date) {
            super(view, date);
            this.getStyleClass().add((Object)"badge-date-cell");
            this.counterLabel = new Label();
            this.counterLabel.getStyleClass().add((Object)"badge-label");
            this.counterLabel.setAlignment(Pos.CENTER_RIGHT);
            this.counterLabel.setVisible(false);
            this.getChildren().add((Object)this.counterLabel);
            this.weekNumberLabel.setVisible(false);
        }

        @Override
        protected void layoutChildren() {
            Insets insets = this.getInsets();
            double top = insets.getTop();
            double bottom = insets.getBottom();
            double left = insets.getLeft();
            double right = insets.getRight();
            double w = this.getWidth();
            double h = this.getHeight();
            double availableHeight = h - top - bottom;
            double ps1 = this.dayOfMonthLabel.prefWidth(-1.0);
            double ps2 = this.dayOfWeekLabel.prefWidth(-1.0);
            double ps4 = this.counterLabel.prefWidth(-1.0);
            double ph = this.counterLabel.prefHeight(-1.0);
            this.dayOfMonthLabel.resizeRelocate(left, top, ps1, availableHeight);
            this.dayOfWeekLabel.resizeRelocate(left + ps1, top, ps2, availableHeight);
            this.counterLabel.resizeRelocate(w - right - ps4, top + availableHeight / 2.0 - ph / 2.0, ps4, Math.min(availableHeight, ph));
        }

        @Override
        protected double computePrefWidth(double height) {
            return this.dayOfMonthLabel.prefWidth(-1.0) + this.dayOfWeekLabel.prefWidth(-1.0) + this.weekNumberLabel.prefWidth(-1.0);
        }

        @Override
        protected double computePrefHeight(double width) {
            double h = Math.max(this.counterLabel.prefHeight(-1.0), Math.max(this.dayOfMonthLabel.prefHeight(-1.0), Math.max(this.dayOfWeekLabel.prefHeight(-1.0), this.weekNumberLabel.prefHeight(-1.0))));
            return h + this.getInsets().getTop() + this.getInsets().getBottom();
        }

        @Override
        public void updateEntries(List<Entry<?>> entries) {
            super.updateEntries(entries);
            int entryCount = 0;
            if (entries != null) {
                entryCount = entries.size();
            }
            if (entryCount > 0) {
                this.counterLabel.setText(Integer.toString(entries.size()));
                this.counterLabel.setVisible(true);
            } else {
                this.counterLabel.setVisible(false);
            }
            this.counterLabel.getStyleClass().removeAll((Object[])new String[]{MonthSheetView.USAGE_VERY_LOW, MonthSheetView.USAGE_LOW, MonthSheetView.USAGE_MEDIUM, MonthSheetView.USAGE_HIGH, MonthSheetView.USAGE_VERY_HIGH});
            Callback<Integer, DateControl.Usage> usagePolicy = this.getView().getUsagePolicy();
            switch ((DateControl.Usage)((Object)usagePolicy.call((Object)entryCount))) {
                case NONE: {
                    break;
                }
                case VERY_LOW: {
                    this.counterLabel.getStyleClass().add((Object)MonthSheetView.USAGE_VERY_LOW);
                    break;
                }
                case LOW: {
                    this.counterLabel.getStyleClass().add((Object)MonthSheetView.USAGE_LOW);
                    break;
                }
                case MEDIUM: {
                    this.counterLabel.getStyleClass().add((Object)MonthSheetView.USAGE_MEDIUM);
                    break;
                }
                case HIGH: {
                    this.counterLabel.getStyleClass().add((Object)MonthSheetView.USAGE_HIGH);
                    break;
                }
                default: {
                    this.counterLabel.getStyleClass().add((Object)MonthSheetView.USAGE_VERY_HIGH);
                }
            }
        }
    }

    public static class DetailedDateCell
    extends SimpleDateCell {
        private DetailCanvas canvas = new DetailCanvas();
        private static final Map<String, Color> calendarColors = new HashMap<String, Color>();

        public DetailedDateCell(MonthSheetView view, LocalDate date) {
            super(view, date);
            this.canvas.setMouseTransparent(true);
            this.getChildren().add((Object)this.canvas);
        }

        public static final Color getCalendarColor(String style) {
            return calendarColors.get(style);
        }

        public static final void setCalendarColor(String style, Color color) {
            calendarColors.put(style, color);
        }

        @Override
        protected void layoutChildren() {
            Insets insets = this.getInsets();
            double top = insets.getTop();
            double bottom = insets.getBottom();
            double left = insets.getLeft();
            double right = insets.getRight();
            double w = this.getWidth();
            double h = this.getHeight();
            double availableHeight = h - top - bottom;
            double ps1 = this.dayOfMonthLabel.prefWidth(-1.0);
            double ps2 = this.dayOfWeekLabel.prefWidth(-1.0);
            double ps3 = this.weekNumberLabel.prefWidth(-1.0);
            double ps4 = 12.0;
            this.dayOfMonthLabel.resizeRelocate(left, top, ps1, availableHeight);
            this.dayOfWeekLabel.resizeRelocate(left + ps1, top, ps2, availableHeight);
            this.weekNumberLabel.resizeRelocate(w - right - ps3 - ps4, top, ps3, availableHeight);
            this.canvas.resizeRelocate(w - right - ps4, top, ps4, availableHeight);
            this.canvas.setWidth(ps4);
            this.canvas.setHeight(availableHeight);
            this.canvas.draw();
        }

        @Override
        protected double computePrefWidth(double height) {
            return this.dayOfMonthLabel.prefWidth(-1.0) + this.dayOfWeekLabel.prefWidth(-1.0) + this.weekNumberLabel.prefWidth(-1.0) + 12.0;
        }

        @Override
        protected double computePrefHeight(double width) {
            double h = Math.max(this.dayOfMonthLabel.prefHeight(-1.0), Math.max(this.dayOfWeekLabel.prefHeight(-1.0), this.weekNumberLabel.prefHeight(-1.0)));
            return h + this.getInsets().getTop() + this.getInsets().getBottom();
        }

        @Override
        public void updateEntries(List<Entry<?>> entries) {
            this.canvas.setEntries(entries);
        }

        static {
            calendarColors.put(Calendar.Style.STYLE1.name().toLowerCase(), Color.rgb((int)119, (int)192, (int)75, (double)0.8));
            calendarColors.put(Calendar.Style.STYLE2.name().toLowerCase(), Color.rgb((int)65, (int)143, (int)203, (double)0.8));
            calendarColors.put(Calendar.Style.STYLE3.name().toLowerCase(), Color.rgb((int)247, (int)209, (int)91, (double)0.8));
            calendarColors.put(Calendar.Style.STYLE4.name().toLowerCase(), Color.rgb((int)157, (int)91, (int)159, (double)0.8));
            calendarColors.put(Calendar.Style.STYLE5.name().toLowerCase(), Color.rgb((int)208, (int)82, (int)95, (double)0.8));
            calendarColors.put(Calendar.Style.STYLE6.name().toLowerCase(), Color.rgb((int)249, (int)132, (int)75, (double)0.8));
            calendarColors.put(Calendar.Style.STYLE7.name().toLowerCase(), Color.rgb((int)174, (int)102, (int)62, (double)0.8));
        }

        private final class DetailCanvas
        extends Canvas {
            private List<Entry<?>> entries;

            private DetailCanvas() {
                this.getStyleClass().add((Object)"detail-canvas");
                this.draw();
            }

            public boolean isResizable() {
                return true;
            }

            public void setEntries(List<Entry<?>> entries) {
                this.entries = entries;
                this.draw();
            }

            public void draw() {
                double width = this.getWidth();
                double height = this.getHeight();
                GraphicsContext gc = this.getGraphicsContext2D();
                gc.clearRect(0.0, 0.0, width, height);
                if (this.entries != null && !this.entries.isEmpty()) {
                    for (Entry<?> entry : this.entries) {
                        Calendar calendar = entry.getCalendar();
                        if (calendar == null) continue;
                        Color color = DetailedDateCell.getCalendarColor(calendar.getStyle());
                        gc.setFill((Paint)color);
                        if (entry.isFullDay()) {
                            gc.fillRect(0.0, 0.0, width, height);
                            continue;
                        }
                        LocalTime startTime = entry.getStartTime();
                        LocalTime endTime = entry.getEndTime();
                        if (entry.getStartDate().isBefore(DetailedDateCell.this.getDate())) {
                            startTime = LocalTime.MIN;
                        }
                        if (entry.getEndDate().isAfter(DetailedDateCell.this.getDate())) {
                            endTime = LocalTime.MAX;
                        }
                        double y = height * ((double)startTime.toSecondOfDay() / (double)LocalTime.MAX.toSecondOfDay());
                        double h = height * ((double)endTime.toSecondOfDay() / (double)LocalTime.MAX.toSecondOfDay());
                        gc.fillRect(0.0, y, width, h - y);
                    }
                }
            }
        }
    }

    public static abstract class DateCell
    extends Region {
        private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
        private static final PseudoClass PSEUDO_CLASS_TODAY = PseudoClass.getPseudoClass((String)"today");
        private static final String CELL_STYLE_CLASS = "date-cell";
        private static final String EXTENDED_CELL_STYLE_CLASS = "extended-date-cell";
        private static final String WEEKEND_DAY = "weekend-day";
        private static final String FIRST_DAY_OF_WEEK = "first-day-of-week";
        private final LocalDate date;
        private final MonthSheetView view;
        private boolean selected;
        private boolean today;

        public DateCell(MonthSheetView view, LocalDate date) {
            this.view = Objects.requireNonNull(view);
            this.date = date;
            this.setMaxWidth(Double.MAX_VALUE);
            this.getStyleClass().add((Object)CELL_STYLE_CLASS);
            this.setFocusTraversable(true);
            this.applyStyles();
        }

        public final MonthSheetView getView() {
            return this.view;
        }

        public final LocalDate getDate() {
            return this.date;
        }

        private void applyStyles() {
            if (this.date == null) {
                return;
            }
            YearMonth yearMonth = YearMonth.from(this.date);
            if (this.view.isExtendedMonth(yearMonth)) {
                this.getStyleClass().add((Object)EXTENDED_CELL_STYLE_CLASS);
            }
            WeekFields fields = this.view.getWeekFields();
            DayOfWeek firstDayOfWeek = fields.getFirstDayOfWeek();
            if (this.date.getDayOfWeek().equals(firstDayOfWeek)) {
                this.getStyleClass().add((Object)FIRST_DAY_OF_WEEK);
            }
            if (this.view.getWeekendDays().contains((Object)this.date.getDayOfWeek())) {
                if (!this.getStyleClass().contains((Object)WEEKEND_DAY)) {
                    this.getStyleClass().add(0, (Object)WEEKEND_DAY);
                }
            } else {
                this.getStyleClass().remove((Object)WEEKEND_DAY);
            }
            this.getStyleClass().add((Object)this.date.getDayOfWeek().name().toLowerCase());
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, selected);
        }

        public boolean isToday() {
            return this.today;
        }

        public void setToday(boolean today) {
            this.today = today;
            this.pseudoClassStateChanged(PSEUDO_CLASS_TODAY, today);
        }

        public void updateEntries(List<Entry<?>> entries) {
        }
    }

    public static class MonthHeaderCell
    extends Label {
        private final YearMonth yearMonth;
        private final MonthSheetView view;

        public MonthHeaderCell(MonthSheetView view, YearMonth yearMonth) {
            this(view, yearMonth, TextStyle.FULL);
        }

        public MonthHeaderCell(MonthSheetView view, YearMonth yearMonth, TextStyle textStyle) {
            this.view = Objects.requireNonNull(view);
            this.yearMonth = Objects.requireNonNull(yearMonth);
            this.setText(yearMonth.getMonth().getDisplayName(textStyle, Locale.getDefault()));
            this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.setMinWidth(0.0);
        }

        public final MonthSheetView getView() {
            return this.view;
        }

        public final YearMonth getYearMonth() {
            return this.yearMonth;
        }
    }

    public static final class HeaderParameter {
        private MonthSheetView view;
        private YearMonth yearMonth;

        public HeaderParameter(MonthSheetView view, YearMonth yearMonth) {
            this.view = Objects.requireNonNull(view);
            this.yearMonth = yearMonth;
        }

        public final MonthSheetView getView() {
            return this.view;
        }

        public final YearMonth getYearMonth() {
            return this.yearMonth;
        }
    }

    public static final class DateParameter {
        private MonthSheetView view;
        private LocalDate date;

        public DateParameter(MonthSheetView view, LocalDate date) {
            this.view = Objects.requireNonNull(view);
            this.date = date;
        }

        public MonthSheetView getView() {
            return this.view;
        }

        public LocalDate getDate() {
            return this.date;
        }
    }

    public static enum ViewUnit {
        MONTH{

            @Override
            public YearMonth getStartMonth(LocalDate date) {
                return YearMonth.from(date);
            }

            @Override
            public YearMonth getEndMonth(LocalDate date) {
                return YearMonth.from(date);
            }

            @Override
            public int getMonthsCount() {
                return 1;
            }
        }
        ,
        QUARTER{

            @Override
            public YearMonth getStartMonth(LocalDate date) {
                return Year.of(date.getYear()).atMonth(QUARTER_START_MONTH[date.getMonthValue() - 1]);
            }

            @Override
            public YearMonth getEndMonth(LocalDate date) {
                return Year.of(date.getYear()).atMonth(QUARTER_END_MONTH[date.getMonthValue() - 1]);
            }

            @Override
            public int getMonthsCount() {
                return 3;
            }
        }
        ,
        SEMESTER{

            @Override
            public YearMonth getStartMonth(LocalDate date) {
                return Year.of(date.getYear()).atMonth(SEMESTER_START_MONTH[date.getMonthValue() - 1]);
            }

            @Override
            public YearMonth getEndMonth(LocalDate date) {
                return Year.of(date.getYear()).atMonth(SEMESTER_END_MONTH[date.getMonthValue() - 1]);
            }

            @Override
            public int getMonthsCount() {
                return 6;
            }
        }
        ,
        YEAR{

            @Override
            public YearMonth getStartMonth(LocalDate date) {
                return Year.from(date).atMonth(Month.JANUARY);
            }

            @Override
            public YearMonth getEndMonth(LocalDate date) {
                return Year.from(date).atMonth(Month.DECEMBER);
            }

            @Override
            public int getMonthsCount() {
                return 12;
            }
        };

        private static final int[] QUARTER_START_MONTH;
        private static final int[] QUARTER_END_MONTH;
        private static final int[] SEMESTER_START_MONTH;
        private static final int[] SEMESTER_END_MONTH;

        public abstract YearMonth getStartMonth(LocalDate var1);

        public abstract YearMonth getEndMonth(LocalDate var1);

        public abstract int getMonthsCount();

        public int toMonths(int units) {
            return this.getMonthsCount() * units;
        }

        static {
            QUARTER_START_MONTH = new int[]{1, 1, 1, 4, 4, 4, 7, 7, 7, 10, 10, 10};
            QUARTER_END_MONTH = new int[]{3, 3, 3, 6, 6, 6, 9, 9, 9, 12, 12, 12};
            SEMESTER_START_MONTH = new int[]{1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 7, 7};
            SEMESTER_END_MONTH = new int[]{6, 6, 6, 6, 6, 6, 12, 12, 12, 12, 12, 12};
        }
    }

    public static enum ClickBehaviour {
        PERFORM_SELECTION,
        SHOW_DETAILS,
        NONE;

    }

    public static enum WeekDayLayoutStrategy {
        STANDARD,
        ALIGNED;

    }
}

