/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.CalendarFXControl;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DraggedEntry;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.ScaleTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.Point2D;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import org.controlsfx.control.PropertySheet;

public abstract class EntryViewBase<T extends DateControl>
extends CalendarFXControl
implements Comparable<EntryViewBase<T>> {
    private static final PseudoClass DRAGGED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dragged");
    private static final PseudoClass DRAGGED_START_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dragged-start");
    private static final PseudoClass DRAGGED_END_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dragged-end");
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private Entry<?> entry;
    private final ListChangeListener<? super String> styleListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                this.getStyleClass().addAll((Collection)change.getAddedSubList());
                continue;
            }
            if (!change.wasRemoved()) continue;
            this.getStyleClass().removeAll((Collection)change.getRemoved());
        }
    };
    private final WeakListChangeListener<? super String> weakStyleListener = new WeakListChangeListener(this.styleListener);
    private InvalidationListener calendarListener = it -> this.bindVisibility();
    private WeakInvalidationListener weakCalendarListener = new WeakInvalidationListener(this.calendarListener);
    private boolean _hidden = false;
    private ReadOnlyBooleanWrapper hidden;
    private InvalidationListener selectionListener = it -> this.updateSelection();
    private WeakInvalidationListener weakSelectionListener = new WeakInvalidationListener(this.selectionListener);
    private InvalidationListener draggedListener = it -> this.updateDragged();
    private WeakInvalidationListener weakDraggedListener = new WeakInvalidationListener(this.draggedListener);
    private Position _position = Position.ONLY;
    private ReadOnlyObjectWrapper<Position> position;
    private T _dateControl;
    private ReadOnlyObjectWrapper<T> dateControl;
    private LocalDate _startDate;
    private ReadOnlyObjectWrapper<LocalDate> startDate;
    private LocalDate _endDate;
    private ReadOnlyObjectWrapper<LocalDate> endDate;
    private LocalTime _startTime;
    private ReadOnlyObjectWrapper<LocalTime> startTime;
    private LocalTime _endTime;
    private ReadOnlyObjectWrapper<LocalTime> endTime;
    private final ReadOnlyBooleanWrapper dragged = new ReadOnlyBooleanWrapper(false){

        protected void invalidated() {
            EntryViewBase.this.pseudoClassStateChanged(DRAGGED_PSEUDO_CLASS, this.get());
        }

        public Object getBean() {
            return EntryViewBase.this;
        }

        public String getName() {
            return "dragged";
        }
    };
    private final ReadOnlyBooleanWrapper draggedStart = new ReadOnlyBooleanWrapper(false){

        protected void invalidated() {
            EntryViewBase.this.pseudoClassStateChanged(DRAGGED_START_PSEUDO_CLASS, this.get());
        }

        public Object getBean() {
            return EntryViewBase.this;
        }

        public String getName() {
            return "draggedStart";
        }
    };
    private final ReadOnlyBooleanWrapper draggedEnd = new ReadOnlyBooleanWrapper(false){

        protected void invalidated() {
            EntryViewBase.this.pseudoClassStateChanged(DRAGGED_END_PSEUDO_CLASS, this.get());
        }

        public Object getBean() {
            return EntryViewBase.this;
        }

        public String getName() {
            return "draggedEnd";
        }
    };
    private final ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper(false){

        protected void invalidated() {
            EntryViewBase.this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.get());
        }

        public Object getBean() {
            return EntryViewBase.this;
        }

        public String getName() {
            return "selected";
        }
    };
    private static final String ENTRY_VIEW_CATEGORY = "Entry View Base";

    protected EntryViewBase(Entry<?> entry) {
        this.entry = Objects.requireNonNull(entry);
        entry.getStyleClass().addListener(this.weakStyleListener);
        this.getStyleClass().addAll(entry.getStyleClass());
        this.setFocusTraversable(true);
        this.focusedProperty().addListener(it -> this.processFocus());
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> this.showDetails((InputEvent)evt, evt.getScreenX(), evt.getScreenY()));
        this.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, evt -> {
            DateControl.EntryContextMenuParameter param;
            ContextMenu menu;
            Callback<DateControl.EntryContextMenuParameter, ContextMenu> callback;
            evt.consume();
            T dateControl = this.getDateControl();
            if (dateControl != null && (callback = ((DateControl)((Object)((Object)dateControl))).getEntryContextMenuCallback()) != null && (menu = (ContextMenu)callback.call((Object)(param = new DateControl.EntryContextMenuParameter((ContextMenuEvent)evt, (DateControl)((Object)((Object)dateControl)), this)))) != null) {
                this.setContextMenu(menu);
                menu.show((Node)this, evt.getScreenX(), evt.getScreenY());
            }
        });
        MapChangeListener propertiesListener = change -> {
            if (change.wasAdded()) {
                if (change.getKey().equals("startDate")) {
                    this.setStartDate((LocalDate)change.getValueAdded());
                } else if (change.getKey().equals("endDate")) {
                    this.setEndDate((LocalDate)change.getValueAdded());
                } else if (change.getKey().equals("startTime")) {
                    this.setStartTime((LocalTime)change.getValueAdded());
                } else if (change.getKey().equals("endTime")) {
                    this.setEndTime((LocalTime)change.getValueAdded());
                } else if (change.getKey().equals("position")) {
                    this.setPosition((Position)((Object)((Object)change.getValueAdded())));
                } else if (change.getKey().equals("dragged")) {
                    Boolean onOff = (Boolean)change.getValueAdded();
                    this.dragged.set(onOff.booleanValue());
                    this.getProperties().remove((Object)"dragged");
                } else if (change.getKey().equals("dragged-start")) {
                    Boolean onOff = (Boolean)change.getValueAdded();
                    this.draggedStart.set(onOff.booleanValue());
                    this.getProperties().remove((Object)"dragged-start");
                } else if (change.getKey().equals("dragged-end")) {
                    Boolean onOff = (Boolean)change.getValueAdded();
                    this.draggedEnd.set(onOff.booleanValue());
                    this.getProperties().remove((Object)"dragged-end");
                } else if (change.getKey().equals("selected")) {
                    Boolean onOff = (Boolean)change.getValueAdded();
                    this.selected.set(onOff.booleanValue());
                    this.getProperties().remove((Object)"selected");
                } else if (change.getKey().equals("hidden")) {
                    Boolean onOff = (Boolean)change.getValueAdded();
                    this.setHidden(onOff);
                    this.getProperties().remove((Object)"hidden");
                } else if (change.getKey().equals("control")) {
                    DateControl control = (DateControl)((Object)((Object)change.getValueAdded()));
                    this.setDateControl(control);
                    this.getProperties().remove((Object)"control");
                }
            }
        };
        this.getProperties().addListener(propertiesListener);
        this.dateControlProperty().addListener((observable, oldControl, newControl) -> {
            if (oldControl != null) {
                oldControl.getSelections().removeListener((InvalidationListener)this.weakSelectionListener);
                oldControl.draggedEntryProperty().removeListener((InvalidationListener)this.weakDraggedListener);
            }
            if (newControl != null) {
                newControl.getSelections().addListener((InvalidationListener)this.weakSelectionListener);
                newControl.draggedEntryProperty().addListener((InvalidationListener)this.weakDraggedListener);
            }
            this.bindVisibility();
        });
        this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
            switch (evt.getCode()) {
                case ENTER: {
                    Point2D localToScreen = this.localToScreen(0.0, 0.0);
                    this.showDetails((InputEvent)evt, localToScreen.getX() + this.getWidth(), localToScreen.getY() + this.getHeight() / 2.0);
                    break;
                }
            }
        });
        this.dateControlProperty().addListener(it -> {
            ObservableSet<Entry<?>> selections = ((DateControl)((Object)((Object)this.getDateControl()))).getSelections();
            boolean contains = selections.contains((Object)entry);
            this.selected.set(contains);
        });
        this.bindEntry(entry);
    }

    public final Entry<?> getEntry() {
        return this.entry;
    }

    private void bindEntry(Entry<?> entry) {
        this.setStartDate(entry.getStartDate());
        this.setEndDate(entry.getEndDate());
        this.setStartTime(entry.getStartTime());
        this.setEndTime(entry.getEndTime());
        if (entry instanceof DraggedEntry) {
            this.getProperties().put((Object)"selected", (Object)true);
        }
        entry.calendarProperty().addListener((InvalidationListener)this.weakCalendarListener);
    }

    private void bindVisibility() {
        Calendar calendar;
        Entry<?> entry = this.getEntry();
        if (entry != null && (calendar = entry.getCalendar()) != null) {
            this.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)((DateControl)((Object)this.getDateControl())).getCalendarVisibilityProperty(calendar), (ObservableBooleanValue)Bindings.not((ObservableBooleanValue)this.hiddenProperty())));
        }
    }

    public final ReadOnlyBooleanProperty hiddenProperty() {
        if (this.hidden == null) {
            this.hidden = new ReadOnlyBooleanWrapper((Object)this, "hidden", this._hidden);
        }
        return this.hidden.getReadOnlyProperty();
    }

    public final boolean isHidden() {
        return this.hidden == null ? this._hidden : this.hidden.get();
    }

    private void setHidden(boolean b) {
        if (this.hidden == null) {
            this._hidden = b;
        } else {
            this.hidden.set(b);
        }
    }

    private void processFocus() {
        if (this.isFocused() && !this.getProperties().containsKey((Object)"disable-focus-handling")) {
            T control = this.getDateControl();
            if (control != null && !((DateControl)((Object)control)).getSelections().contains(this.getEntry())) {
                ((DateControl)((Object)control)).getSelections().clear();
                ((DateControl)((Object)control)).select(this.getEntry());
            }
            this.bounce();
        }
    }

    public final void bounce() {
        ScaleTransition transition = new ScaleTransition(Duration.millis((double)200.0), (Node)this);
        this.setCache(true);
        this.setCacheHint(CacheHint.SCALE);
        transition.setAutoReverse(true);
        transition.setFromX(1.0);
        transition.setToX(0.8);
        transition.setFromY(1.0);
        transition.setToY(0.8);
        transition.setCycleCount(2);
        transition.setOnFinished(evt -> this.setCache(false));
        transition.play();
    }

    private void updateSelection() {
        T control = this.getDateControl();
        if (control != null) {
            Entry<?> entry = this.getEntry();
            if (((DateControl)((Object)control)).getSelections().contains(entry)) {
                this.selected.set(true);
            } else {
                this.selected.set(false);
            }
        }
    }

    private void updateDragged() {
        T control = this.getDateControl();
        if (control != null) {
            DraggedEntry draggedEntry = ((DateControl)((Object)control)).getDraggedEntry();
            if (draggedEntry != null) {
                if (draggedEntry.getOriginalEntry().equals(this.getEntry())) {
                    switch (draggedEntry.getDragMode()) {
                        case END_TIME: {
                            this.draggedEnd.set(true);
                            break;
                        }
                        case START_AND_END_TIME: {
                            this.dragged.set(true);
                            break;
                        }
                        case START_TIME: {
                            this.draggedStart.set(true);
                            break;
                        }
                    }
                } else {
                    this.dragged.set(false);
                    this.draggedStart.set(false);
                    this.draggedEnd.set(false);
                }
            } else {
                this.dragged.set(false);
                this.draggedStart.set(false);
                this.draggedEnd.set(false);
            }
        }
    }

    private void showDetails(InputEvent evt, double x, double y) {
        T control = this.getDateControl();
        if (control != null && this.getParent() != null) {
            Callback<DateControl.EntryDetailsParameter, Boolean> callback = ((DateControl)((Object)control)).getEntryDetailsCallback();
            DateControl.EntryDetailsParameter param = new DateControl.EntryDetailsParameter(evt, (DateControl)((Object)control), this.getEntry(), (Node)this.getParent(), x, y);
            callback.call((Object)param);
        }
    }

    public final ReadOnlyObjectProperty<Position> positionProperty() {
        if (this.position == null) {
            this.position = new ReadOnlyObjectWrapper((Object)this, "position", (Object)this._position);
        }
        return this.position.getReadOnlyProperty();
    }

    public final Position getPosition() {
        return this.position == null ? this._position : (Position)((Object)this.position.get());
    }

    private void setPosition(Position pos) {
        if (this.position == null) {
            this._position = pos;
        } else {
            this.position.set((Object)pos);
        }
    }

    public final ReadOnlyObjectProperty<T> dateControlProperty() {
        if (this.dateControl == null) {
            this.dateControl = new ReadOnlyObjectWrapper((Object)this, "dateControl", this._dateControl);
        }
        return this.dateControl.getReadOnlyProperty();
    }

    public final T getDateControl() {
        return (T)(this.dateControl == null ? this._dateControl : (DateControl)((Object)this.dateControl.get()));
    }

    private void setDateControl(T control) {
        if (this.dateControl == null) {
            this._dateControl = control;
        } else {
            this.dateControl.set(control);
        }
    }

    public final ReadOnlyObjectProperty<LocalDate> startDateProperty() {
        if (this.startDate == null) {
            this.startDate = new ReadOnlyObjectWrapper((Object)this, "startDate", (Object)this._startDate);
        }
        return this.startDate.getReadOnlyProperty();
    }

    public final LocalDate getStartDate() {
        return this.startDate == null ? this._startDate : (LocalDate)this.startDate.get();
    }

    private void setStartDate(LocalDate date) {
        if (this.startDate == null) {
            this._startDate = date;
        } else {
            this.startDate.set((Object)date);
        }
    }

    public final ReadOnlyObjectProperty<LocalDate> endDateProperty() {
        if (this.endDate == null) {
            this.endDate = new ReadOnlyObjectWrapper((Object)this, "endDate", (Object)this._endDate);
        }
        return this.endDate.getReadOnlyProperty();
    }

    public final LocalDate getEndDate() {
        return this.endDate == null ? this._endDate : (LocalDate)this.endDate.get();
    }

    private void setEndDate(LocalDate date) {
        if (this.endDate == null) {
            this._endDate = date;
        } else {
            this.endDate.set((Object)date);
        }
    }

    public final ReadOnlyObjectProperty<LocalTime> startTimeProperty() {
        if (this.startTime == null) {
            this.startTime = new ReadOnlyObjectWrapper((Object)this, "startTime", (Object)this._startTime);
        }
        return this.startTime.getReadOnlyProperty();
    }

    public final LocalTime getStartTime() {
        return this.startTime == null ? this._startTime : (LocalTime)this.startTime.get();
    }

    private void setStartTime(LocalTime time) {
        if (this.startTime == null) {
            this._startTime = time;
        } else {
            this.startTime.set((Object)time);
        }
    }

    public final ReadOnlyObjectProperty<LocalTime> endTimeProperty() {
        if (this.endTime == null) {
            this.endTime = new ReadOnlyObjectWrapper((Object)this, "endTime", (Object)this._endTime);
        }
        return this.endTime.getReadOnlyProperty();
    }

    public final LocalTime getEndTime() {
        return this.endTime == null ? this._endTime : (LocalTime)this.endTime.get();
    }

    private void setEndTime(LocalTime time) {
        if (this.endTime == null) {
            this._endTime = time;
        } else {
            this.endTime.set((Object)time);
        }
    }

    public final ReadOnlyBooleanProperty draggedProperty() {
        return this.dragged.getReadOnlyProperty();
    }

    public final boolean isDragged() {
        return this.draggedProperty().get();
    }

    public final ReadOnlyBooleanProperty draggedStartProperty() {
        return this.draggedStart.getReadOnlyProperty();
    }

    public final boolean isDraggedStart() {
        return this.draggedStartProperty().get();
    }

    public final ReadOnlyBooleanProperty draggedEndProperty() {
        return this.draggedEnd.getReadOnlyProperty();
    }

    public final boolean isDraggedEnd() {
        return this.draggedEndProperty().get();
    }

    public final ReadOnlyBooleanProperty selectedProperty() {
        return this.selected.getReadOnlyProperty();
    }

    public final boolean isSelected() {
        return this.selectedProperty().get();
    }

    public final boolean intersects(EntryViewBase<?> otherView) {
        return this.getEntry().intersects(otherView.getEntry());
    }

    public final boolean isReadOnly() {
        Entry<?> entry = this.getEntry();
        Calendar calendar = entry.getCalendar();
        if (calendar != null) {
            return calendar.isReadOnly();
        }
        return false;
    }

    @Override
    public int compareTo(EntryViewBase<T> o) {
        return this.getEntry().compareTo(o.getEntry());
    }

    public String toString() {
        return "EntryViewBase [entry=" + this.getEntry() + ", selected=" + this.isSelected() + "]";
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList items = FXCollections.observableArrayList();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(EntryViewBase.this.positionProperty());
            }

            public void setValue(Object value) {
                EntryViewBase.this.position.set((Object)((Position)((Object)value)));
            }

            public Object getValue() {
                return EntryViewBase.this.getPosition();
            }

            public Class<?> getType() {
                return Position.class;
            }

            public String getName() {
                return "Position";
            }

            public String getDescription() {
                return "Position (first, last, middle, only)";
            }

            public String getCategory() {
                return EntryViewBase.ENTRY_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(EntryViewBase.this.selectedProperty());
            }

            public void setValue(Object value) {
                EntryViewBase.this.selected.set(((Boolean)value).booleanValue());
            }

            public Object getValue() {
                return EntryViewBase.this.isSelected();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Selected";
            }

            public String getDescription() {
                return "Selected";
            }

            public String getCategory() {
                return EntryViewBase.ENTRY_VIEW_CATEGORY;
            }
        });
        return items;
    }

    public static enum Position {
        FIRST,
        MIDDLE,
        LAST,
        ONLY;

    }
}

