/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import java.time.Duration;
import java.util.Objects;

public final class DraggedEntry
extends Entry<Object> {
    private Duration offsetDuration;
    private Entry<?> originalEntry;
    private Calendar originalCalendar;
    private DragMode dragMode;

    public DraggedEntry(Entry<?> entry, DragMode dragMode) {
        this.originalEntry = Objects.requireNonNull(entry);
        this.originalCalendar = Objects.requireNonNull(entry.getCalendar());
        this.dragMode = dragMode;
        this.setTitle(entry.getTitle());
        this.setUserObject(entry.getUserObject());
        this.setFullDay(entry.isFullDay());
        this.setInterval(entry.getInterval());
        this.getStyleClass().add((Object)"dragged-entry");
    }

    public DragMode getDragMode() {
        return this.dragMode;
    }

    public void setDragMode(DragMode dragMode) {
        Objects.requireNonNull(dragMode);
        this.dragMode = dragMode;
    }

    public Entry<?> getOriginalEntry() {
        return this.originalEntry;
    }

    public Calendar getOriginalCalendar() {
        return this.originalCalendar;
    }

    public void setOffsetDuration(Duration duration) {
        this.offsetDuration = duration;
    }

    public Duration getOffsetDuration() {
        return this.offsetDuration;
    }

    public static enum DragMode {
        START_TIME,
        END_TIME,
        START_AND_END_TIME;

    }
}

