/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.AgendaView;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.CalendarHeaderView;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.TimeScaleView;
import impl.com.calendarfx.view.DetailedDayViewSkin;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class DetailedDayView
extends DayViewBase {
    private static final String DEFAULT_STYLE = "detailed-day-view";
    private final AllDayView allDayView;
    private final DayView dayView;
    private final TimeScaleView timeScaleView;
    private final CalendarHeaderView calendarHeader;
    private final AgendaView agendaView;
    private final BooleanProperty showAllDayView = new SimpleBooleanProperty((Object)this, "showAllDayView", true);
    private final BooleanProperty showAgendaView = new SimpleBooleanProperty((Object)this, "showAgendaView", false);
    private final BooleanProperty showTimeScaleView = new SimpleBooleanProperty((Object)this, "showTimeScaleView", true);
    private final BooleanProperty showScrollBar = new SimpleBooleanProperty((Object)this, "showScrollBar", true);
    private static final String DETAILED_DAY_VIEW_CATEGORY = "Detailed Day View";

    public DetailedDayView() {
        this.allDayView = new AllDayView(1);
        this.dayView = new DayView();
        this.timeScaleView = new TimeScaleView();
        this.calendarHeader = new CalendarHeaderView();
        this.agendaView = new AgendaView();
        this.agendaView.setLookBackPeriodInDays(0);
        this.agendaView.setLookAheadPeriodInDays(0);
        this.agendaView.setShowStatusLabel(false);
        this.agendaView.setCellFactory((Callback<AgendaView, ? extends AgendaView.AgendaEntryCell>)((Callback)view -> new AgendaView.AgendaEntryCell((AgendaView)((Object)view), false)));
        this.bind(this.dayView, true);
        this.bind(this.timeScaleView, true);
        this.bind(this.allDayView, true);
        this.bind(this.agendaView, true);
        this.calendarHeader.bind(this);
        this.getStyleClass().add((Object)DEFAULT_STYLE);
    }

    protected Skin<?> createDefaultSkin() {
        return new DetailedDayViewSkin(this);
    }

    public final AllDayView getAllDayView() {
        return this.allDayView;
    }

    public final DayView getDayView() {
        return this.dayView;
    }

    public final TimeScaleView getTimeScaleView() {
        return this.timeScaleView;
    }

    public final CalendarHeaderView getCalendarHeaderView() {
        return this.calendarHeader;
    }

    public final AgendaView getAgendaView() {
        return this.agendaView;
    }

    public final BooleanProperty showAllDayViewProperty() {
        return this.showAllDayView;
    }

    public final boolean isShowAllDayView() {
        return this.showAllDayViewProperty().get();
    }

    public final void setShowAllDayView(boolean show) {
        this.showAllDayViewProperty().set(show);
    }

    public final BooleanProperty showAgendaViewProperty() {
        return this.showAgendaView;
    }

    public final boolean isShowAgendaView() {
        return this.showAgendaViewProperty().get();
    }

    public final void setShowAgendaView(boolean show) {
        this.showAgendaViewProperty().set(show);
    }

    public final BooleanProperty showTimeScaleViewProperty() {
        return this.showTimeScaleView;
    }

    public final boolean isShowTimeScaleView() {
        return this.showTimeScaleViewProperty().get();
    }

    public final void setShowTimeScaleView(boolean show) {
        this.showTimeScaleViewProperty().set(show);
    }

    public final BooleanProperty showScrollBarProperty() {
        return this.showScrollBar;
    }

    public final void setShowScrollBar(boolean showScrollBar) {
        this.showScrollBar.set(showScrollBar);
    }

    public final boolean isShowScrollBar() {
        return this.showScrollBar.get();
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public void setValue(Object value) {
                DetailedDayView.this.setShowAllDayView((Boolean)value);
            }

            public Object getValue() {
                return DetailedDayView.this.isShowAllDayView();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedDayView.this.showAllDayViewProperty());
            }

            public String getName() {
                return "Show All Day View";
            }

            public String getDescription() {
                return "Show All Day View";
            }

            public String getCategory() {
                return DetailedDayView.DETAILED_DAY_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public void setValue(Object value) {
                DetailedDayView.this.setShowTimeScaleView((Boolean)value);
            }

            public Object getValue() {
                return DetailedDayView.this.isShowTimeScaleView();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedDayView.this.showTimeScaleViewProperty());
            }

            public String getName() {
                return "Show Time Scale View";
            }

            public String getDescription() {
                return "Show Time Scale View";
            }

            public String getCategory() {
                return DetailedDayView.DETAILED_DAY_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public void setValue(Object value) {
                DetailedDayView.this.setShowAgendaView((Boolean)value);
            }

            public Object getValue() {
                return DetailedDayView.this.isShowAgendaView();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedDayView.this.showAgendaViewProperty());
            }

            public String getName() {
                return "Show Agenda View";
            }

            public String getDescription() {
                return "Show Agenda View";
            }

            public String getCategory() {
                return DetailedDayView.DETAILED_DAY_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getCategory() {
                return DetailedDayView.DETAILED_DAY_VIEW_CATEGORY;
            }

            public String getName() {
                return "Show ScrollBar";
            }

            public String getDescription() {
                return "Show ScrollBar";
            }

            public Object getValue() {
                return DetailedDayView.this.isShowScrollBar();
            }

            public void setValue(Object value) {
                DetailedDayView.this.setShowScrollBar((Boolean)value);
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedDayView.this.showScrollBarProperty());
            }
        });
        return items;
    }
}

