/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.WeekDayView;
import com.calendarfx.view.ZonedDateTimeProvider;
import impl.com.calendarfx.view.ViewHelper;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import org.controlsfx.control.PropertySheet;

public abstract class DayViewBase
extends DateControl
implements ZonedDateTimeProvider {
    private final DoubleProperty entryWidthPercentage = new SimpleDoubleProperty(this, "entryWidthPercentage", 100.0){

        public void set(double newValue) {
            if (newValue < 10.0 || newValue > 100.0) {
                throw new IllegalArgumentException("percentage widht must be between 10 and 100 but was " + newValue);
            }
            super.set(newValue);
        }
    };
    private final ObjectProperty<EarlyLateHoursStrategy> earlyLateHoursStrategy = new SimpleObjectProperty((Object)this, "earlyLateHoursStrategy", (Object)EarlyLateHoursStrategy.SHOW);
    private final ObjectProperty<HoursLayoutStrategy> hoursLayoutStrategy = new SimpleObjectProperty((Object)this, "hoursLayoutStrategy", (Object)HoursLayoutStrategy.FIXED_HOUR_COUNT);
    private final IntegerProperty visibleHours = new SimpleIntegerProperty((Object)this, "visibleHours", 10);
    private final DoubleProperty hourHeight = new SimpleDoubleProperty((Object)this, "hourHeight", 70.0);
    private final DoubleProperty hourHeightCompressed = new SimpleDoubleProperty((Object)this, "hourHeightCompressed", 10.0);
    private final ReadOnlyBooleanWrapper showCurrentTimeMarker = new ReadOnlyBooleanWrapper((Object)this, "showCurrentTimeMarker", false);
    private final ReadOnlyBooleanWrapper showCurrentTimeTodayMarker = new ReadOnlyBooleanWrapper((Object)this, "showCurrentTimeTodayMarker", false);
    private final BooleanProperty enableCurrentTimeMarker = new SimpleBooleanProperty((Object)this, "enableCurrentTimeMarker", true);
    private final ReadOnlyObjectWrapper<LocalTime> earliestTimeUsed = new ReadOnlyObjectWrapper((Object)this, "earliestTimeUsed");
    private final ReadOnlyObjectWrapper<LocalTime> latestTimeUsed = new ReadOnlyObjectWrapper((Object)this, "latestTimeUsed");
    private final BooleanProperty trimTimeBounds = new SimpleBooleanProperty((Object)this, "timTimeBounds", false);
    private static final String DAY_VIEW_BASE_CATEGORY = "Date View Base";

    public DayViewBase() {
        MapChangeListener propertiesListener = change -> {
            if (change.wasAdded()) {
                if (change.getKey().equals("show.current.time.marker")) {
                    Boolean show = (Boolean)change.getValueAdded();
                    this.showCurrentTimeMarker.set(show.booleanValue());
                } else if (change.getKey().equals("show.current.time.today.marker")) {
                    Boolean show = (Boolean)change.getValueAdded();
                    this.showCurrentTimeTodayMarker.set(show.booleanValue());
                } else if (change.getKey().equals("earliest.time.used")) {
                    LocalTime time = (LocalTime)change.getValueAdded();
                    this.earliestTimeUsed.set((Object)time);
                } else if (change.getKey().equals("latest.time.used")) {
                    LocalTime time = (LocalTime)change.getValueAdded();
                    this.latestTimeUsed.set((Object)time);
                }
            }
        };
        this.getProperties().addListener(propertiesListener);
        InvalidationListener trimListener = it -> {
            if (this.isTrimTimeBounds()) {
                this.trimTimeBounds();
            }
        };
        this.earliestTimeUsedProperty().addListener(trimListener);
        this.latestTimeUsedProperty().addListener(trimListener);
        this.trimTimeBoundsProperty().addListener(trimListener);
    }

    public final DoubleProperty entryWidthPercentageProperty() {
        return this.entryWidthPercentage;
    }

    public final void setEntryWidthPercentage(double percentage) {
        this.entryWidthPercentage.set(percentage);
    }

    public double getEntryWidthPercentage() {
        return this.entryWidthPercentage.get();
    }

    @Override
    public ZonedDateTime getZonedDateTimeAt(double x, double y) {
        return ZonedDateTime.of(ViewHelper.getLocationTime(this, y, false, true), this.getZoneId());
    }

    public final ObjectProperty<EarlyLateHoursStrategy> earlyLateHoursStrategyProperty() {
        return this.earlyLateHoursStrategy;
    }

    public final void setEarlyLateHoursStrategy(EarlyLateHoursStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.earlyLateHoursStrategy.set((Object)strategy);
    }

    public final EarlyLateHoursStrategy getEarlyLateHoursStrategy() {
        return (EarlyLateHoursStrategy)((Object)this.earlyLateHoursStrategy.get());
    }

    public final ObjectProperty<HoursLayoutStrategy> hoursLayoutStrategyProperty() {
        return this.hoursLayoutStrategy;
    }

    public final void setHoursLayoutStrategy(HoursLayoutStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.hoursLayoutStrategy.set((Object)strategy);
    }

    public final HoursLayoutStrategy getHoursLayoutStrategy() {
        return (HoursLayoutStrategy)((Object)this.hoursLayoutStrategy.get());
    }

    public final IntegerProperty visibleHoursProperty() {
        return this.visibleHours;
    }

    public final void setVisibleHours(int hours) {
        this.visibleHoursProperty().set(hours);
    }

    public final int getVisibleHours() {
        return this.visibleHoursProperty().get();
    }

    public final DoubleProperty hourHeightProperty() {
        return this.hourHeight;
    }

    public final void setHourHeight(double height) {
        if (height < 1.0) {
            throw new IllegalArgumentException("height must be larger than 0 but was " + height);
        }
        this.hourHeightProperty().set(height);
    }

    public final double getHourHeight() {
        return this.hourHeightProperty().get();
    }

    public final DoubleProperty hourHeightCompressedProperty() {
        return this.hourHeightCompressed;
    }

    public final void setHourHeightCompressed(double height) {
        if (height < 1.0) {
            throw new IllegalArgumentException("height must be larger than 0 but was " + height);
        }
        this.hourHeightCompressedProperty().set(height);
    }

    public final double getHourHeightCompressed() {
        return this.hourHeightCompressedProperty().get();
    }

    public final ReadOnlyBooleanProperty showCurrentTimeMarkerProperty() {
        return this.showCurrentTimeMarker;
    }

    public final boolean isShowCurrentTimeMarker() {
        return this.showCurrentTimeMarker.get();
    }

    public final ReadOnlyBooleanProperty showCurrentTimeTodayMarkerProperty() {
        return this.showCurrentTimeTodayMarker;
    }

    public final boolean isShowCurrentTimeTodayMarker() {
        return this.showCurrentTimeTodayMarker.get();
    }

    public final BooleanProperty enableCurrentTimeMarkerProperty() {
        return this.enableCurrentTimeMarker;
    }

    public final boolean isEnableCurrentTimeMarker() {
        return this.enableCurrentTimeMarker.get();
    }

    public final void setEnableCurrentTimeMarker(boolean enable) {
        this.enableCurrentTimeMarker.set(enable);
    }

    public final ReadOnlyObjectProperty<LocalTime> earliestTimeUsedProperty() {
        return this.earliestTimeUsed.getReadOnlyProperty();
    }

    public final LocalTime getEarliestTimeUsed() {
        return (LocalTime)this.earliestTimeUsed.get();
    }

    public final ReadOnlyObjectProperty<LocalTime> latestTimeUsedProperty() {
        return this.latestTimeUsed.getReadOnlyProperty();
    }

    public final LocalTime getLatestTimeUsed() {
        return (LocalTime)this.latestTimeUsed.get();
    }

    public final BooleanProperty trimTimeBoundsProperty() {
        return this.trimTimeBounds;
    }

    public final boolean isTrimTimeBounds() {
        return this.trimTimeBounds.get();
    }

    public final void setTrimTimeBounds(boolean trimTimeBounds) {
        this.trimTimeBounds.set(trimTimeBounds);
    }

    private void trimTimeBounds() {
        if (this instanceof WeekDayView) {
            return;
        }
        LoggingDomain.PRINTING.fine("trimming hours");
        LocalTime st = LocalTime.of(8, 0);
        LocalTime et = LocalTime.of(19, 0);
        LocalTime etu = this.getEarliestTimeUsed();
        LocalTime ltu = this.getLatestTimeUsed();
        LoggingDomain.PRINTING.fine("earliest time: " + etu + ", latest time: " + ltu);
        this.setEarlyLateHoursStrategy(EarlyLateHoursStrategy.HIDE);
        if (etu != null && ltu != null && ltu.isAfter(etu)) {
            etu = !etu.isBefore(LocalTime.of(1, 0)) ? etu.minusHours(1L) : LocalTime.MIN;
            ltu = !ltu.isAfter(LocalTime.of(23, 0)) ? ltu.plusHours(1L) : LocalTime.MAX;
            if (etu.isBefore(st.plusHours(1L))) {
                this.setStartTime(etu);
            } else {
                this.setStartTime(st);
            }
            if (ltu.isAfter(et.minusHours(1L))) {
                this.setEndTime(ltu);
            } else {
                this.setEndTime(et);
            }
        } else {
            this.setStartTime(st);
            this.setEndTime(et);
        }
        this.setVisibleHours(Math.min(24, (int)this.getStartTime().until(this.getEndTime(), ChronoUnit.HOURS)));
    }

    public final void bind(DayViewBase otherControl, boolean bindDate) {
        super.bind(otherControl, bindDate);
        Bindings.bindBidirectional(otherControl.earlyLateHoursStrategyProperty(), this.earlyLateHoursStrategy);
        Bindings.bindBidirectional(otherControl.hoursLayoutStrategyProperty(), this.hoursLayoutStrategyProperty());
        Bindings.bindBidirectional((Property)otherControl.hourHeightProperty(), (Property)this.hourHeightProperty());
        Bindings.bindBidirectional((Property)otherControl.hourHeightCompressedProperty(), (Property)this.hourHeightCompressedProperty());
        Bindings.bindBidirectional((Property)otherControl.visibleHoursProperty(), (Property)this.visibleHoursProperty());
        Bindings.bindBidirectional((Property)otherControl.enableCurrentTimeMarkerProperty(), (Property)this.enableCurrentTimeMarkerProperty());
        Bindings.bindBidirectional((Property)otherControl.trimTimeBoundsProperty(), (Property)this.trimTimeBoundsProperty());
    }

    public final void unbind(DayViewBase otherControl) {
        super.unbind(otherControl);
        Bindings.unbindBidirectional(otherControl.earlyLateHoursStrategyProperty(), this.earlyLateHoursStrategy);
        Bindings.unbindBidirectional(otherControl.hoursLayoutStrategyProperty(), this.hoursLayoutStrategyProperty());
        Bindings.unbindBidirectional((Property)otherControl.hourHeightProperty(), (Property)this.hourHeightProperty());
        Bindings.unbindBidirectional((Property)otherControl.hourHeightCompressedProperty(), (Property)this.hourHeightCompressedProperty());
        Bindings.unbindBidirectional((Property)otherControl.visibleHoursProperty(), (Property)this.visibleHoursProperty());
        Bindings.unbindBidirectional((Property)otherControl.enableCurrentTimeMarkerProperty(), (Property)this.enableCurrentTimeMarkerProperty());
        Bindings.unbindBidirectional((Property)otherControl.trimTimeBoundsProperty(), (Property)this.trimTimeBoundsProperty());
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.enableCurrentTimeMarkerProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setEnableCurrentTimeMarker((Boolean)value);
            }

            public Object getValue() {
                return DayViewBase.this.isEnableCurrentTimeMarker();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Current time marker";
            }

            public String getDescription() {
                return "Early / Late Hours Layout Strategy";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.earlyLateHoursStrategyProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setEarlyLateHoursStrategy((EarlyLateHoursStrategy)((Object)value));
            }

            public Object getValue() {
                return DayViewBase.this.getEarlyLateHoursStrategy();
            }

            public Class<?> getType() {
                return EarlyLateHoursStrategy.class;
            }

            public String getName() {
                return "Early / Late Hours";
            }

            public String getDescription() {
                return "Early / Late Hours Layout Strategy";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.visibleHoursProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setVisibleHours((Integer)value);
            }

            public Object getValue() {
                return DayViewBase.this.getVisibleHours();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public String getName() {
                return "Visible Hours";
            }

            public String getDescription() {
                return "Number of visible hours";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.hourHeightProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setHourHeight((Double)value);
            }

            public Object getValue() {
                return DayViewBase.this.getHourHeight();
            }

            public Class<?> getType() {
                return Double.class;
            }

            public String getName() {
                return "Hour Height";
            }

            public String getDescription() {
                return "Height of one hour";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.hourHeightCompressedProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setHourHeightCompressed((Double)value);
            }

            public Object getValue() {
                return DayViewBase.this.getHourHeightCompressed();
            }

            public Class<?> getType() {
                return Double.class;
            }

            public String getName() {
                return "Hour Height Compressed";
            }

            public String getDescription() {
                return "Height of one hour when shown compressed (early / late hours).";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.hoursLayoutStrategyProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setHoursLayoutStrategy((HoursLayoutStrategy)((Object)value));
            }

            public Object getValue() {
                return DayViewBase.this.getHoursLayoutStrategy();
            }

            public Class<?> getType() {
                return HoursLayoutStrategy.class;
            }

            public String getName() {
                return "Layout Strategy";
            }

            public String getDescription() {
                return "Layout Strategy";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.trimTimeBoundsProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setTrimTimeBounds((Boolean)value);
            }

            public Object getValue() {
                return DayViewBase.this.isTrimTimeBounds();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Trim Time Bounds";
            }

            public String getDescription() {
                return "Adjust earliest / latest times shown";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.earliestTimeUsedProperty());
            }

            public void setValue(Object value) {
            }

            public Object getValue() {
                return DayViewBase.this.getEarliestTimeUsed();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "Earliest Time Used";
            }

            public String getDescription() {
                return "Earliest start time of any entry view";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.latestTimeUsedProperty());
            }

            public void setValue(Object value) {
            }

            public Object getValue() {
                return DayViewBase.this.getLatestTimeUsed();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "Latest Time Used";
            }

            public String getDescription() {
                return "Latest end time of any entry view";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        return items;
    }

    public static enum HoursLayoutStrategy {
        FIXED_HOUR_HEIGHT,
        FIXED_HOUR_COUNT;

    }

    public static enum EarlyLateHoursStrategy {
        SHOW,
        SHOW_COMPRESSED,
        HIDE;

    }
}

