/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.CalendarFXControl;
import com.calendarfx.view.CalendarView;
import com.calendarfx.view.ContextMenuProvider;
import com.calendarfx.view.DraggedEntry;
import com.calendarfx.view.EntryViewBase;
import com.calendarfx.view.Messages;
import com.calendarfx.view.VirtualGrid;
import com.calendarfx.view.ZonedDateTimeProvider;
import com.calendarfx.view.popover.DatePopOver;
import com.calendarfx.view.popover.EntryPopOverContentPane;
import impl.com.calendarfx.view.ViewHelper;
import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.effect.Light;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.PropertySheet;

public abstract class DateControl
extends CalendarFXControl {
    private int entryCounter = 1;
    private Boolean usesOwnContextMenu;
    private final InvalidationListener updateCalendarListListener = it -> this.updateCalendarList();
    private final WeakInvalidationListener weakUpdateCalendarListListener = new WeakInvalidationListener(this.updateCalendarListListener);
    private final ObservableMap<Calendar, BooleanProperty> calendarVisibilityMap = FXCollections.observableHashMap();
    private final ObjectProperty<DraggedEntry> draggedEntry = new SimpleObjectProperty((Object)this, "draggedEntry");
    private static PopOver entryPopOver;
    private static DatePopOver datePopOver;
    private final ObjectProperty<Callback<CreateEntryParameter, Entry<?>>> entryFactory = new SimpleObjectProperty((Object)this, "entryFactory");
    private final ObjectProperty<Callback<CreateCalendarSourceParameter, CalendarSource>> calendarSourceFactory = new SimpleObjectProperty((Object)this, "calendarSourceFactory");
    private final ObjectProperty<Callback<EntryEditParameter, Boolean>> entryEditPolicy = new SimpleObjectProperty(action -> true);
    private final ObjectProperty<Callback<EntryContextMenuParameter, ContextMenu>> entryContextMenuCallback = new SimpleObjectProperty((Object)this, "entryFactory");
    private final ObjectProperty<Callback<ContextMenuParameter, ContextMenu>> contextMenuCallback = new SimpleObjectProperty((Object)this, "contextMenuCallback");
    private final ObjectProperty<Callback<DateControl, Calendar>> defaultCalendarProvider = new SimpleObjectProperty((Object)this, "defaultCalendarProvider");
    private final ObjectProperty<Callback<DateDetailsParameter, Boolean>> dateDetailsCallback = new SimpleObjectProperty((Object)this, "dateDetailsCallback");
    private final ObjectProperty<Callback<EntryDetailsParameter, Boolean>> entryDetailsCallback = new SimpleObjectProperty((Object)this, "entryDetailsCallback");
    private final ObjectProperty<Callback<EntryDetailsPopOverContentParameter, Node>> entryDetailsPopoverContentCallback = new SimpleObjectProperty((Object)this, "entryDetailsPopoverContentCallback");
    private final ObjectProperty<LocalDate> today = new SimpleObjectProperty((Object)this, "today", (Object)LocalDate.now());
    private final BooleanProperty showToday = new SimpleBooleanProperty((Object)this, "showToday", true);
    private final ObjectProperty<LocalDate> date = new SimpleObjectProperty((Object)this, "date", (Object)LocalDate.now());
    private final ObjectProperty<ZoneId> zoneId = new SimpleObjectProperty((Object)this, "zoneId", (Object)ZoneId.systemDefault());
    private final ObjectProperty<LocalTime> time = new SimpleObjectProperty((Object)this, "time", (Object)LocalTime.now());
    private final ObjectProperty<LocalTime> startTime = new SimpleObjectProperty((Object)this, "startTime", (Object)LocalTime.of(6, 0));
    private final ObjectProperty<LocalTime> endTime = new SimpleObjectProperty((Object)this, "endTime", (Object)LocalTime.of(22, 0));
    private final ObjectProperty<WeekFields> weekFields = new SimpleObjectProperty((Object)this, "weekFields", (Object)WeekFields.of(Locale.getDefault()));
    private final ReadOnlyListWrapper<Calendar> calendars = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final ObservableList<Calendar> unmodifiableCalendars = FXCollections.unmodifiableObservableList((ObservableList)this.calendars.get());
    private final ObservableList<CalendarSource> calendarSources = FXCollections.observableArrayList();
    private final ObjectProperty<SelectionMode> selectionMode = new SimpleObjectProperty((Object)this, "selectionMode", (Object)SelectionMode.MULTIPLE);
    private final ObservableSet<Entry<?>> selections = FXCollections.observableSet((Object[])new Entry[0]);
    private final ObjectProperty<VirtualGrid> virtualGrid = new SimpleObjectProperty((Object)this, "virtualGrid", (Object)new VirtualGrid(Messages.getString("DateControl.DEFAULT_VIRTUAL_GRID_NAME"), Messages.getString("DateControl.DEFAULT_VIRTUAL_GRID_SHORT_NAME"), ChronoUnit.MINUTES, 15));
    private final ObjectProperty<LocalTime> requestedTime = new SimpleObjectProperty((Object)this, "requestedTime", (Object)LocalTime.now());
    private final ObjectProperty<Layout> layout = new SimpleObjectProperty((Object)this, "layout", (Object)Layout.STANDARD);
    private ObservableSet<DayOfWeek> weekendDays = FXCollections.observableSet((Object[])new DayOfWeek[0]);
    private List<DateControl> boundDateControls = FXCollections.observableArrayList();
    private final BooleanProperty enableHyperlinks = new SimpleBooleanProperty((Object)this, "enableHyperlinks", true);
    private final BooleanProperty suspendUpdates = new SimpleBooleanProperty((Object)this, "suspendUpdates", false);
    public final ObjectProperty<Callback<Integer, Usage>> usagePolicy = new SimpleObjectProperty((Object)this, "usagePolicy");
    private static final String DATE_CONTROL_CATEGORY = "Date Control";

    protected DateControl() {
        this.setFocusTraversable(false);
        this.setUsagePolicy((Callback<Integer, Usage>)((Callback)count -> {
            if (count < 0) {
                throw new IllegalArgumentException("usage count can not be smaller than zero, but was " + count);
            }
            switch (count) {
                case 0: {
                    return Usage.NONE;
                }
                case 1: {
                    return Usage.VERY_LOW;
                }
                case 2: {
                    return Usage.LOW;
                }
                case 3: {
                    return Usage.MEDIUM;
                }
                case 4: {
                    return Usage.HIGH;
                }
            }
            return Usage.VERY_HIGH;
        }));
        this.getWeekendDays().add((Object)DayOfWeek.SATURDAY);
        this.getWeekendDays().add((Object)DayOfWeek.SUNDAY);
        CalendarSource defaultCalendarSource = new CalendarSource(Messages.getString("DateControl.DEFAULT_CALENDAR_SOURCE_NAME"));
        Calendar defaultCalendar = new Calendar(Messages.getString("DateControl.DEFAULT_CALENDAR_NAME"));
        defaultCalendarSource.getCalendars().add((Object)defaultCalendar);
        this.getCalendarSources().add((Object)defaultCalendarSource);
        InvalidationListener hidePopOverListener = it -> this.maybeHidePopOvers();
        this.sceneProperty().addListener(hidePopOverListener);
        this.visibleProperty().addListener(hidePopOverListener);
        this.getCalendarSources().addListener((InvalidationListener)this.weakUpdateCalendarListListener);
        this.setEntryDetailsPopOverContentCallback((Callback<EntryDetailsPopOverContentParameter, Node>)((Callback)param -> new EntryPopOverContentPane(param.getPopOver(), param.getDateControl(), param.getEntry())));
        this.setDefaultCalendarProvider((Callback<DateControl, Calendar>)((Callback)control -> {
            ObservableList<CalendarSource> sources = this.getCalendarSources();
            if (sources != null && !sources.isEmpty()) {
                CalendarSource s = (CalendarSource)sources.get(0);
                ObservableList<Calendar> calendars = s.getCalendars();
                if (calendars != null && !calendars.isEmpty()) {
                    for (Calendar c : calendars) {
                        if (c.isReadOnly() || !this.isCalendarVisible(c)) continue;
                        return c;
                    }
                    Alert alert = new Alert(Alert.AlertType.WARNING);
                    alert.setTitle(Messages.getString("DateControl.TITLE_CALENDAR_PROBLEM"));
                    alert.setHeaderText(Messages.getString("DateControl.HEADER_TEXT_UNABLE_TO_CREATE_NEW_ENTRY"));
                    String newLine = System.getProperty("line.separator");
                    alert.setContentText(MessageFormat.format(Messages.getString("DateControl.CONTENT_TEXT_UNABLE_TO_CREATE_NEW_ENTRY"), newLine));
                    alert.show();
                } else {
                    Alert alert = new Alert(Alert.AlertType.WARNING);
                    alert.setTitle(Messages.getString("DateControl.TITLE_CALENDAR_PROBLEM"));
                    alert.setHeaderText(Messages.getString("DateControl.HEADER_TEXT_NO_CALENDARS_DEFINED"));
                    alert.setContentText(Messages.getString("DateControl.CONTENT_TEXT_NO_CALENDARS_DEFINED"));
                    alert.show();
                }
            }
            return null;
        }));
        this.setEntryFactory(param -> {
            DateControl control = param.getDateControl();
            VirtualGrid grid = control.getVirtualGrid();
            ZonedDateTime time = param.getZonedDateTime();
            DayOfWeek firstDayOfWeek = this.getFirstDayOfWeek();
            ZonedDateTime lowerTime = grid.adjustTime(time, false, firstDayOfWeek);
            ZonedDateTime upperTime = grid.adjustTime(time, true, firstDayOfWeek);
            time = Duration.between(time, lowerTime).abs().minus(Duration.between(time, upperTime).abs()).isNegative() ? lowerTime : upperTime;
            Entry entry = new Entry(MessageFormat.format(Messages.getString("DateControl.DEFAULT_ENTRY_TITLE"), this.entryCounter++));
            Interval interval = new Interval(time.toLocalDateTime(), time.toLocalDateTime().plusHours(1L));
            entry.setInterval(interval);
            if (control instanceof AllDayView) {
                entry.setFullDay(true);
            }
            return entry;
        });
        this.setEntryDetailsCallback((Callback<EntryDetailsParameter, Boolean>)((Callback)param -> {
            InputEvent evt = param.getInputEvent();
            if (evt instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)evt;
                if (mouseEvent.getClickCount() == 2) {
                    this.showEntryDetails(param.getEntry(), param.getOwner(), param.getScreenY());
                    return true;
                }
            } else {
                this.showEntryDetails(param.getEntry(), param.getOwner(), param.getScreenY());
                return true;
            }
            return false;
        }));
        this.setDateDetailsCallback((Callback<DateDetailsParameter, Boolean>)((Callback)param -> {
            MouseEvent mouseEvent;
            InputEvent evt = param.getInputEvent();
            if (evt == null) {
                this.showDateDetails(param.getOwner(), param.getLocalDate());
                return true;
            }
            if (evt instanceof MouseEvent && (mouseEvent = (MouseEvent)evt).getClickCount() == 1) {
                this.showDateDetails(param.getOwner(), param.getLocalDate());
                return true;
            }
            return false;
        }));
        this.setContextMenuCallback(new ContextMenuProvider());
        this.setEntryContextMenuCallback((Callback<EntryContextMenuParameter, ContextMenu>)((Callback)param -> {
            EntryViewBase<?> entryView = param.getEntryView();
            Entry<?> entry = entryView.getEntry();
            ContextMenu contextMenu = new ContextMenu();
            MenuItem informationItem = new MenuItem(Messages.getString("DateControl.MENU_ITEM_INFORMATION"));
            informationItem.setOnAction(evt -> {
                Callback<EntryDetailsParameter, Boolean> detailsCallback = this.getEntryDetailsCallback();
                if (detailsCallback != null) {
                    ContextMenuEvent ctxEvent = param.getContextMenuEvent();
                    EntryDetailsParameter entryDetailsParam = new EntryDetailsParameter((InputEvent)ctxEvent, this, entryView.getEntry(), (Node)this, ctxEvent.getScreenX(), ctxEvent.getScreenY());
                    detailsCallback.call((Object)entryDetailsParam);
                }
            });
            contextMenu.getItems().add((Object)informationItem);
            String stylesheet = CalendarView.class.getResource("calendar.css").toExternalForm();
            Menu calendarMenu = new Menu(Messages.getString("DateControl.MENU_CALENDAR"));
            for (Calendar calendar : this.getCalendars()) {
                RadioMenuItem calendarItem = new RadioMenuItem(calendar.getName());
                calendarItem.setOnAction(evt -> entry.setCalendar(calendar));
                calendarItem.setDisable(calendar.isReadOnly());
                calendarItem.setSelected(calendar.equals(param.getCalendar()));
                calendarMenu.getItems().add((Object)calendarItem);
                StackPane graphic = new StackPane();
                graphic.getStylesheets().add((Object)stylesheet);
                Rectangle icon = new Rectangle(10.0, 10.0);
                icon.setArcHeight(2.0);
                icon.setArcWidth(2.0);
                icon.getStyleClass().setAll((Object[])new String[]{calendar.getStyle() + "-icon"});
                graphic.getChildren().add((Object)icon);
                calendarItem.setGraphic((Node)graphic);
            }
            calendarMenu.setDisable(param.getCalendar().isReadOnly());
            contextMenu.getItems().add((Object)calendarMenu);
            if (((Boolean)this.getEntryEditPolicy().call((Object)new EntryEditParameter(this, entry, EditOperation.DELETE))).booleanValue()) {
                MenuItem delete = new MenuItem(Messages.getString("DateControl.MENU_ITEM_DELETE"));
                contextMenu.getItems().add((Object)delete);
                delete.setDisable(param.getCalendar().isReadOnly());
                delete.setOnAction(evt -> {
                    Calendar calendar = entry.getCalendar();
                    if (!calendar.isReadOnly()) {
                        if (entry.isRecurrence()) {
                            entry.getRecurrenceSourceEntry().removeFromCalendar();
                        } else {
                            entry.removeFromCalendar();
                        }
                    }
                });
            }
            return contextMenu;
        }));
        this.setCalendarSourceFactory((Callback<CreateCalendarSourceParameter, CalendarSource>)((Callback)param -> {
            CalendarSource source = new CalendarSource(Messages.getString("DateControl.DEFAULT_NEW_CALENDAR_SOURCE"));
            Calendar calendar = new Calendar(Messages.getString("DateControl.DEFAULT_NEW_CALENDAR"));
            calendar.setShortName(Messages.getString("DateControl.DEFAULT_NEW_CALENDAR").substring(0, 1));
            source.getCalendars().add((Object)calendar);
            return source;
        }));
        this.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, evt -> {
            if (null == this.usesOwnContextMenu) {
                this.usesOwnContextMenu = this.getContextMenu() != null;
            }
            if (!this.usesOwnContextMenu.booleanValue()) {
                evt.consume();
                Callback<ContextMenuParameter, ContextMenu> callback = this.getContextMenuCallback();
                if (callback != null) {
                    ContextMenuParameter param;
                    ContextMenu menu;
                    Callback<DateControl, Calendar> calendarProvider = this.getDefaultCalendarProvider();
                    Calendar calendar = (Calendar)calendarProvider.call((Object)this);
                    ZonedDateTime time = ZonedDateTime.now();
                    if (this instanceof ZonedDateTimeProvider) {
                        ZonedDateTimeProvider provider = (ZonedDateTimeProvider)((Object)this);
                        time = provider.getZonedDateTimeAt(evt.getX(), evt.getY());
                    }
                    if ((menu = (ContextMenu)callback.call((Object)(param = new ContextMenuParameter((ContextMenuEvent)evt, this, calendar, time)))) != null) {
                        this.setContextMenu(menu);
                        menu.show((Node)this, evt.getScreenX(), evt.getScreenY());
                    }
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, evt -> {
            this.maybeHidePopOvers();
            this.performSelection((MouseEvent)evt);
        });
    }

    public final ObservableMap<Calendar, BooleanProperty> getCalendarVisibilityMap() {
        return this.calendarVisibilityMap;
    }

    public final BooleanProperty getCalendarVisibilityProperty(Calendar calendar) {
        return (BooleanProperty)this.calendarVisibilityMap.computeIfAbsent((Object)calendar, cal -> new SimpleBooleanProperty((Object)this, "visible", true));
    }

    public final boolean isCalendarVisible(Calendar calendar) {
        BooleanProperty prop = this.getCalendarVisibilityProperty(calendar);
        return prop.get();
    }

    public final void setCalendarVisibility(Calendar calendar, boolean visible) {
        BooleanProperty prop = this.getCalendarVisibilityProperty(calendar);
        prop.set(visible);
    }

    public final void refreshData() {
        this.getProperties().put((Object)"refresh.data", (Object)true);
        this.getBoundDateControls().forEach(DateControl::refreshData);
    }

    private void performSelection(MouseEvent evt) {
        if ((evt.getButton().equals((Object)MouseButton.PRIMARY) || evt.isPopupTrigger()) && evt.getClickCount() == 1) {
            EntryViewBase view = null;
            if (evt.getTarget() instanceof EntryViewBase) {
                view = (EntryViewBase)evt.getTarget();
            }
            if (view == null) {
                return;
            }
            String disableFocusHandlingKey = "disable-focus-handling";
            view.getProperties().put((Object)disableFocusHandlingKey, (Object)true);
            view.requestFocus();
            Entry<?> entry = view.getEntry();
            if (entry != null) {
                if (!this.isMultiSelect(evt) && !this.getSelections().contains(entry)) {
                    this.clearSelection();
                }
                if (this.isMultiSelect(evt) && this.getSelections().contains(entry)) {
                    this.getSelections().remove(entry);
                } else if (!this.getSelections().contains(entry)) {
                    this.getSelections().add(entry);
                }
            }
            view.getProperties().remove((Object)disableFocusHandlingKey);
        }
    }

    private boolean isMultiSelect(MouseEvent evt) {
        return (evt.isShiftDown() || evt.isShortcutDown()) && this.getSelectionMode().equals((Object)SelectionMode.MULTIPLE);
    }

    public final void createCalendarSource() {
        CreateCalendarSourceParameter param;
        CalendarSource calendarSource;
        Callback<CreateCalendarSourceParameter, CalendarSource> factory = this.getCalendarSourceFactory();
        if (factory != null && (calendarSource = (CalendarSource)factory.call((Object)(param = new CreateCalendarSourceParameter(this)))) != null && !this.getCalendarSources().contains((Object)calendarSource)) {
            this.getCalendarSources().add((Object)calendarSource);
        }
    }

    public final ObjectProperty<DraggedEntry> draggedEntryProperty() {
        return this.draggedEntry;
    }

    public final DraggedEntry getDraggedEntry() {
        return (DraggedEntry)this.draggedEntry.get();
    }

    public final void setDraggedEntry(DraggedEntry entry) {
        this.draggedEntryProperty().set((Object)entry);
    }

    public final Entry<?> createEntryAt(ZonedDateTime time) {
        return this.createEntryAt(time, null);
    }

    public final Entry<?> createEntryAt(ZonedDateTime time, Calendar calendar) {
        Objects.requireNonNull(time);
        VirtualGrid grid = this.getVirtualGrid();
        if (grid != null) {
            ZonedDateTime timeA = grid.adjustTime(time, false, this.getFirstDayOfWeek());
            ZonedDateTime timeB = grid.adjustTime(time, true, this.getFirstDayOfWeek());
            time = Duration.between(time, timeA).abs().minus(Duration.between(time, timeB).abs()).isNegative() ? timeA : timeB;
        }
        if (calendar == null) {
            Callback<DateControl, Calendar> defaultCalendarProvider = this.getDefaultCalendarProvider();
            calendar = (Calendar)defaultCalendarProvider.call((Object)this);
        }
        if (calendar != null) {
            this.setCalendarVisibility(calendar, true);
            CreateEntryParameter param = new CreateEntryParameter(this, calendar, time);
            Callback<CreateEntryParameter, Entry<?>> factory = this.getEntryFactory();
            Entry entry = (Entry)factory.call((Object)param);
            if (entry != null) {
                entry.setCalendar(calendar);
            }
            return entry;
        }
        LoggingDomain.EDITING.warning("No calendar found for adding a new entry.");
        return null;
    }

    public Optional<Calendar> getCalendarAt(double x, double y) {
        return Optional.empty();
    }

    public final void showEntry(Entry<?> entry) {
        Objects.requireNonNull(entry);
        this.doShowEntry(entry, false);
    }

    public final void editEntry(Entry<?> entry) {
        Objects.requireNonNull(entry);
        this.doShowEntry(entry, true);
    }

    private void doShowEntry(Entry<?> entry, boolean startEditing) {
        this.setDate(entry.getStartDate());
        if (!entry.isFullDay()) {
            this.setRequestedTime(entry.getStartTime());
        }
        if (startEditing) {
            Platform.runLater(() -> this.doEditEntry(entry));
        } else {
            Platform.runLater(() -> this.doBounceEntry(entry));
        }
    }

    private void doEditEntry(Entry<?> entry) {
        EntryViewBase<?> entryView = this.findEntryView(entry);
        if (entryView != null) {
            entryView.bounce();
            Point2D localToScreen = entryView.localToScreen(0.0, 0.0);
            Callback<EntryDetailsParameter, Boolean> callback = this.getEntryDetailsCallback();
            EntryDetailsParameter param = new EntryDetailsParameter(null, this, entry, (Node)entryView, localToScreen.getX(), localToScreen.getY());
            callback.call((Object)param);
        }
    }

    private void doBounceEntry(Entry<?> entry) {
        EntryViewBase<?> entryView = this.findEntryView(entry);
        if (entryView != null) {
            entryView.bounce();
        }
    }

    private void showEntryDetails(Entry<?> entry, Node owner, double screenY) {
        this.maybeHidePopOvers();
        Callback<EntryDetailsPopOverContentParameter, Node> contentCallback = this.getEntryDetailsPopOverContentCallback();
        if (contentCallback == null) {
            throw new IllegalStateException("No content callback found for entry popover");
        }
        entryPopOver = new PopOver();
        EntryDetailsPopOverContentParameter param = new EntryDetailsPopOverContentParameter(entryPopOver, this, owner, entry);
        Node content = (Node)contentCallback.call((Object)param);
        if (content == null) {
            content = new Label(Messages.getString("DateControl.NO_CONTENT"));
        }
        entryPopOver.setContentNode(content);
        PopOver.ArrowLocation location = ViewHelper.findPopOverArrowLocation(owner);
        entryPopOver.setArrowLocation(location);
        Light.Point position = ViewHelper.findPopOverArrowPosition(owner, screenY, entryPopOver.getArrowSize(), location);
        entryPopOver.show(owner, position.getX(), position.getY());
    }

    public void showDateDetails(Node owner, LocalDate date) {
        this.maybeHidePopOvers();
        datePopOver = new DatePopOver(this, date);
        datePopOver.show(owner);
    }

    private void maybeHidePopOvers() {
        if (entryPopOver != null && entryPopOver.isShowing() && !entryPopOver.isDetached()) {
            entryPopOver.hide();
        }
        if (datePopOver != null && datePopOver.isShowing() && !datePopOver.isDetached()) {
            datePopOver.hide();
        }
    }

    public final ObjectProperty<Callback<CreateEntryParameter, Entry<?>>> entryFactoryProperty() {
        return this.entryFactory;
    }

    public final Callback<CreateEntryParameter, Entry<?>> getEntryFactory() {
        return (Callback)this.entryFactoryProperty().get();
    }

    public final void setEntryFactory(Callback<CreateEntryParameter, Entry<?>> factory) {
        Objects.requireNonNull(factory);
        this.entryFactoryProperty().set(factory);
    }

    public final ObjectProperty<Callback<CreateCalendarSourceParameter, CalendarSource>> calendarSourceFactoryProperty() {
        return this.calendarSourceFactory;
    }

    public final Callback<CreateCalendarSourceParameter, CalendarSource> getCalendarSourceFactory() {
        return (Callback)this.calendarSourceFactoryProperty().get();
    }

    public final void setCalendarSourceFactory(Callback<CreateCalendarSourceParameter, CalendarSource> callback) {
        this.calendarSourceFactoryProperty().set(callback);
    }

    public final ObjectProperty<Callback<EntryEditParameter, Boolean>> entryEditPolicyProperty() {
        return this.entryEditPolicy;
    }

    public final Callback<EntryEditParameter, Boolean> getEntryEditPolicy() {
        return (Callback)this.entryEditPolicy.get();
    }

    public final void setEntryEditPolicy(Callback<EntryEditParameter, Boolean> policy) {
        Objects.requireNonNull(policy, "The edit entry policy can not be null");
        this.entryEditPolicy.set(policy);
    }

    public final ObjectProperty<Callback<EntryContextMenuParameter, ContextMenu>> entryContextMenuCallbackProperty() {
        return this.entryContextMenuCallback;
    }

    public final Callback<EntryContextMenuParameter, ContextMenu> getEntryContextMenuCallback() {
        return (Callback)this.entryContextMenuCallbackProperty().get();
    }

    public final void setEntryContextMenuCallback(Callback<EntryContextMenuParameter, ContextMenu> callback) {
        this.entryContextMenuCallbackProperty().set(callback);
    }

    public final ObjectProperty<Callback<ContextMenuParameter, ContextMenu>> contextMenuCallbackProperty() {
        return this.contextMenuCallback;
    }

    public final Callback<ContextMenuParameter, ContextMenu> getContextMenuCallback() {
        return (Callback)this.contextMenuCallbackProperty().get();
    }

    public final void setContextMenuCallback(Callback<ContextMenuParameter, ContextMenu> callback) {
        this.contextMenuCallbackProperty().set(callback);
    }

    public final ObjectProperty<Callback<DateControl, Calendar>> defaultCalendarProviderProperty() {
        return this.defaultCalendarProvider;
    }

    public final Callback<DateControl, Calendar> getDefaultCalendarProvider() {
        return (Callback)this.defaultCalendarProviderProperty().get();
    }

    public final void setDefaultCalendarProvider(Callback<DateControl, Calendar> provider) {
        Objects.requireNonNull(provider);
        this.defaultCalendarProviderProperty().set(provider);
    }

    private void updateCalendarList() {
        ArrayList<Calendar> removedCalendars = new ArrayList<Calendar>((Collection<Calendar>)this.calendars);
        ArrayList<Calendar> newCalendars = new ArrayList<Calendar>();
        for (CalendarSource source : this.getCalendarSources()) {
            for (Calendar calendar : source.getCalendars()) {
                if (this.calendars.contains((Object)calendar)) {
                    removedCalendars.remove(calendar);
                    continue;
                }
                newCalendars.add(calendar);
            }
            source.getCalendars().removeListener((InvalidationListener)this.weakUpdateCalendarListListener);
            source.getCalendars().addListener((InvalidationListener)this.weakUpdateCalendarListListener);
        }
        this.calendars.addAll(newCalendars);
        this.calendars.removeAll(removedCalendars);
    }

    public final ObjectProperty<Callback<DateDetailsParameter, Boolean>> dateDetailsCallbackProperty() {
        return this.dateDetailsCallback;
    }

    public final void setDateDetailsCallback(Callback<DateDetailsParameter, Boolean> callback) {
        Objects.requireNonNull(callback);
        this.dateDetailsCallbackProperty().set(callback);
    }

    public final Callback<DateDetailsParameter, Boolean> getDateDetailsCallback() {
        return (Callback)this.dateDetailsCallbackProperty().get();
    }

    public final ObjectProperty<Callback<EntryDetailsParameter, Boolean>> entryDetailsCallbackProperty() {
        return this.entryDetailsCallback;
    }

    public final void setEntryDetailsCallback(Callback<EntryDetailsParameter, Boolean> callback) {
        Objects.requireNonNull(callback);
        this.entryDetailsCallbackProperty().set(callback);
    }

    public final Callback<EntryDetailsParameter, Boolean> getEntryDetailsCallback() {
        return (Callback)this.entryDetailsCallbackProperty().get();
    }

    public final ObjectProperty<Callback<EntryDetailsPopOverContentParameter, Node>> entryDetailsPopOverContentCallbackProperty() {
        return this.entryDetailsPopoverContentCallback;
    }

    public final void setEntryDetailsPopOverContentCallback(Callback<EntryDetailsPopOverContentParameter, Node> callback) {
        Objects.requireNonNull(callback);
        this.entryDetailsPopOverContentCallbackProperty().set(callback);
    }

    public final Callback<EntryDetailsPopOverContentParameter, Node> getEntryDetailsPopOverContentCallback() {
        return (Callback)this.entryDetailsPopOverContentCallbackProperty().get();
    }

    public final ObjectProperty<LocalDate> todayProperty() {
        return this.today;
    }

    public final void setToday(LocalDate date) {
        Objects.requireNonNull(date);
        this.todayProperty().set((Object)date);
    }

    public final LocalDate getToday() {
        return (LocalDate)this.todayProperty().get();
    }

    public final BooleanProperty showTodayProperty() {
        return this.showToday;
    }

    public final boolean isShowToday() {
        return this.showTodayProperty().get();
    }

    public final void setShowToday(boolean show) {
        this.showTodayProperty().set(show);
    }

    public final ObjectProperty<LocalDate> dateProperty() {
        return this.date;
    }

    public final void setDate(LocalDate date) {
        Objects.requireNonNull(date);
        this.dateProperty().set((Object)date);
    }

    public final LocalDate getDate() {
        return (LocalDate)this.dateProperty().get();
    }

    public final ObjectProperty<ZoneId> zoneIdProperty() {
        return this.zoneId;
    }

    public final void setZoneId(ZoneId zoneId) {
        Objects.requireNonNull(zoneId);
        this.zoneIdProperty().set((Object)zoneId);
    }

    public final ZoneId getZoneId() {
        return (ZoneId)this.zoneIdProperty().get();
    }

    public final ObjectProperty<LocalTime> timeProperty() {
        return this.time;
    }

    public final void setTime(LocalTime time) {
        Objects.requireNonNull(time);
        this.timeProperty().set((Object)time);
    }

    public final LocalTime getTime() {
        return (LocalTime)this.timeProperty().get();
    }

    public final ObjectProperty<LocalTime> startTimeProperty() {
        return this.startTime;
    }

    public final LocalTime getStartTime() {
        return (LocalTime)this.startTimeProperty().get();
    }

    public final void setStartTime(LocalTime time) {
        this.startTimeProperty().set((Object)time);
    }

    public final ObjectProperty<LocalTime> endTimeProperty() {
        return this.endTime;
    }

    public final LocalTime getEndTime() {
        return (LocalTime)this.endTimeProperty().get();
    }

    public final void setEndTime(LocalTime time) {
        this.endTimeProperty().set((Object)time);
    }

    public final ObjectProperty<WeekFields> weekFieldsProperty() {
        return this.weekFields;
    }

    public final void setWeekFields(WeekFields weekFields) {
        Objects.requireNonNull(weekFields);
        this.weekFieldsProperty().set((Object)weekFields);
    }

    public final WeekFields getWeekFields() {
        return (WeekFields)this.weekFieldsProperty().get();
    }

    public final DayOfWeek getFirstDayOfWeek() {
        return this.getWeekFields().getFirstDayOfWeek();
    }

    public final ReadOnlyListProperty<Calendar> calendarsProperty() {
        return this.calendars.getReadOnlyProperty();
    }

    public final ObservableList<Calendar> getCalendars() {
        return this.unmodifiableCalendars;
    }

    public final ObservableList<CalendarSource> getCalendarSources() {
        return this.calendarSources;
    }

    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        return this.selectionMode;
    }

    public final void setSelectionMode(SelectionMode mode) {
        Objects.requireNonNull(mode);
        this.selectionModeProperty().set((Object)mode);
    }

    public final SelectionMode getSelectionMode() {
        return (SelectionMode)this.selectionModeProperty().get();
    }

    public final ObservableSet<Entry<?>> getSelections() {
        return this.selections;
    }

    public final void select(Entry<?> entry) {
        Objects.requireNonNull(entry);
        this.selections.add(entry);
    }

    public final void deselect(Entry<?> entry) {
        Objects.requireNonNull(entry);
        this.selections.remove(entry);
    }

    public final void clearSelection() {
        this.getSelections().clear();
    }

    public final ObjectProperty<VirtualGrid> virtualGridProperty() {
        return this.virtualGrid;
    }

    public final VirtualGrid getVirtualGrid() {
        return (VirtualGrid)this.virtualGridProperty().get();
    }

    public final void setVirtualGrid(VirtualGrid grid) {
        Objects.requireNonNull(grid);
        this.virtualGridProperty().set((Object)grid);
    }

    public final ObjectProperty<LocalTime> requestedTimeProperty() {
        return this.requestedTime;
    }

    public final void setRequestedTime(LocalTime time) {
        this.requestedTimeProperty().set((Object)time);
    }

    public final LocalTime getRequestedTime() {
        return (LocalTime)this.requestedTimeProperty().get();
    }

    public final ObjectProperty<Layout> layoutProperty() {
        return this.layout;
    }

    public final void setLayout(Layout layout) {
        Objects.requireNonNull(layout);
        this.layoutProperty().set((Object)layout);
    }

    public final Layout getLayout() {
        return (Layout)((Object)this.layoutProperty().get());
    }

    public ObservableSet<DayOfWeek> getWeekendDays() {
        return this.weekendDays;
    }

    public void goForward() {
        this.setDate(this.getDate().plusDays(1L));
    }

    public void goBack() {
        this.setDate(this.getDate().minusDays(1L));
    }

    public void goToday() {
        this.setDate(this.getToday());
    }

    public final EntryViewBase<?> findEntryView(Entry<?> entry) {
        Objects.requireNonNull(entry);
        return this.doFindEntryView((Parent)this, entry);
    }

    private EntryViewBase<?> doFindEntryView(Parent parent, Entry<?> entry) {
        EntryViewBase result = null;
        for (Node node : parent.getChildrenUnmodifiable()) {
            if (node instanceof EntryViewBase) {
                EntryViewBase base = (EntryViewBase)node;
                if (!base.getEntry().equals(entry)) continue;
                result = base;
                break;
            }
            if (!(node instanceof Parent) || (result = this.doFindEntryView((Parent)node, entry)) == null) continue;
            break;
        }
        return result;
    }

    public final List<DateControl> getBoundDateControls() {
        return this.boundDateControls;
    }

    public final BooleanProperty enableHyperlinksProperty() {
        return this.enableHyperlinks;
    }

    public final void setEnableHyperlinks(boolean enable) {
        this.enableHyperlinks.set(enable);
    }

    public final boolean isEnableHyperlinks() {
        return this.enableHyperlinks.get();
    }

    public final void bind(DateControl otherControl, boolean bindDate) {
        Objects.requireNonNull(otherControl);
        this.boundDateControls.add(otherControl);
        Bindings.bindContentBidirectional(otherControl.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        Bindings.bindContentBidirectional(otherControl.getCalendarSources(), this.getCalendarSources());
        Bindings.bindContentBidirectional(otherControl.getSelections(), this.getSelections());
        Bindings.bindContentBidirectional(otherControl.getWeekendDays(), this.getWeekendDays());
        Bindings.bindBidirectional((Property)otherControl.suspendUpdatesProperty(), (Property)this.suspendUpdatesProperty());
        Bindings.bindBidirectional(otherControl.entryFactoryProperty(), this.entryFactoryProperty());
        Bindings.bindBidirectional(otherControl.defaultCalendarProviderProperty(), this.defaultCalendarProviderProperty());
        Bindings.bindBidirectional(otherControl.virtualGridProperty(), this.virtualGridProperty());
        Bindings.bindBidirectional(otherControl.draggedEntryProperty(), this.draggedEntryProperty());
        Bindings.bindBidirectional(otherControl.requestedTimeProperty(), this.requestedTimeProperty());
        Bindings.bindBidirectional(otherControl.selectionModeProperty(), this.selectionModeProperty());
        Bindings.bindBidirectional(otherControl.selectionModeProperty(), this.selectionModeProperty());
        Bindings.bindBidirectional(otherControl.weekFieldsProperty(), this.weekFieldsProperty());
        Bindings.bindBidirectional(otherControl.layoutProperty(), this.layoutProperty());
        Bindings.bindBidirectional(otherControl.startTimeProperty(), this.startTimeProperty());
        Bindings.bindBidirectional(otherControl.endTimeProperty(), this.endTimeProperty());
        Bindings.bindBidirectional(otherControl.timeProperty(), this.timeProperty());
        Bindings.bindBidirectional(otherControl.usagePolicyProperty(), this.usagePolicyProperty());
        if (bindDate) {
            Bindings.bindBidirectional(otherControl.dateProperty(), this.dateProperty());
        }
        Bindings.bindBidirectional(otherControl.todayProperty(), this.todayProperty());
        Bindings.bindBidirectional(otherControl.zoneIdProperty(), this.zoneIdProperty());
        Bindings.bindBidirectional(otherControl.entryDetailsCallbackProperty(), this.entryDetailsCallbackProperty());
        Bindings.bindBidirectional(otherControl.dateDetailsCallbackProperty(), this.dateDetailsCallbackProperty());
        Bindings.bindBidirectional(otherControl.contextMenuCallbackProperty(), this.contextMenuCallbackProperty());
        Bindings.bindBidirectional(otherControl.entryContextMenuCallbackProperty(), this.entryContextMenuCallbackProperty());
        Bindings.bindBidirectional(otherControl.calendarSourceFactoryProperty(), this.calendarSourceFactoryProperty());
        Bindings.bindBidirectional(otherControl.entryDetailsPopOverContentCallbackProperty(), this.entryDetailsPopOverContentCallbackProperty());
        Bindings.bindBidirectional(otherControl.entryEditPolicyProperty(), this.entryEditPolicyProperty());
    }

    public final void unbind(DateControl otherControl) {
        Objects.requireNonNull(otherControl);
        this.boundDateControls.remove((Object)otherControl);
        Bindings.unbindContentBidirectional(otherControl.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        Bindings.unbindContentBidirectional(otherControl.getCalendarSources(), this.getCalendarSources());
        Bindings.unbindContentBidirectional(otherControl.getSelections(), this.getSelections());
        Bindings.unbindBidirectional((Property)otherControl.suspendUpdatesProperty(), (Property)this.suspendUpdatesProperty());
        Bindings.unbindBidirectional(otherControl.entryFactoryProperty(), this.entryFactoryProperty());
        Bindings.unbindBidirectional(otherControl.defaultCalendarProviderProperty(), this.defaultCalendarProviderProperty());
        Bindings.unbindBidirectional(otherControl.virtualGridProperty(), this.virtualGridProperty());
        Bindings.unbindBidirectional(otherControl.draggedEntryProperty(), this.draggedEntryProperty());
        Bindings.unbindBidirectional(otherControl.requestedTimeProperty(), this.requestedTimeProperty());
        Bindings.unbindBidirectional(otherControl.selectionModeProperty(), this.selectionModeProperty());
        Bindings.unbindBidirectional(otherControl.selectionModeProperty(), this.selectionModeProperty());
        Bindings.unbindBidirectional(otherControl.weekFieldsProperty(), this.weekFieldsProperty());
        Bindings.unbindBidirectional(otherControl.dateProperty(), this.dateProperty());
        Bindings.unbindBidirectional(otherControl.todayProperty(), this.todayProperty());
        Bindings.unbindBidirectional(otherControl.zoneIdProperty(), this.zoneIdProperty());
        Bindings.unbindBidirectional(otherControl.layoutProperty(), this.layoutProperty());
        Bindings.unbindBidirectional(otherControl.startTimeProperty(), this.startTimeProperty());
        Bindings.unbindBidirectional(otherControl.endTimeProperty(), this.endTimeProperty());
        Bindings.unbindBidirectional(otherControl.timeProperty(), this.timeProperty());
        Bindings.unbindBidirectional(otherControl.usagePolicyProperty(), this.usagePolicyProperty());
        Bindings.unbindBidirectional(otherControl.entryDetailsCallbackProperty(), this.entryDetailsCallbackProperty());
        Bindings.unbindBidirectional(otherControl.dateDetailsCallbackProperty(), this.dateDetailsCallbackProperty());
        Bindings.unbindBidirectional(otherControl.contextMenuCallbackProperty(), this.contextMenuCallbackProperty());
        Bindings.unbindBidirectional(otherControl.entryContextMenuCallbackProperty(), this.entryContextMenuCallbackProperty());
        Bindings.unbindBidirectional(otherControl.calendarSourceFactoryProperty(), this.calendarSourceFactoryProperty());
        Bindings.unbindBidirectional(otherControl.entryEditPolicyProperty(), this.entryEditPolicyProperty());
    }

    public final BooleanProperty suspendUpdatesProperty() {
        return this.suspendUpdates;
    }

    public final boolean isSuspendUpdates() {
        return this.suspendUpdates.get();
    }

    public final void setSuspendUpdates(boolean suspend) {
        this.suspendUpdates.set(suspend);
    }

    public final ObjectProperty<Callback<Integer, Usage>> usagePolicyProperty() {
        return this.usagePolicy;
    }

    public final void setUsagePolicy(Callback<Integer, Usage> policy) {
        Objects.requireNonNull(policy);
        this.usagePolicy.set(policy);
    }

    public final Callback<Integer, Usage> getUsagePolicy() {
        return (Callback)this.usagePolicy.get();
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.dateProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setDate((LocalDate)value);
            }

            public Object getValue() {
                return DateControl.this.getDate();
            }

            public Class<?> getType() {
                return LocalDate.class;
            }

            public String getName() {
                return "Date";
            }

            public String getDescription() {
                return "Date";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.layoutProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setLayout((Layout)((Object)value));
            }

            public Object getValue() {
                return DateControl.this.getLayout();
            }

            public Class<?> getType() {
                return Layout.class;
            }

            public String getName() {
                return "Layout";
            }

            public String getDescription() {
                return "Layout";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.selectionModeProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setSelectionMode((SelectionMode)value);
            }

            public Object getValue() {
                return DateControl.this.getSelectionMode();
            }

            public Class<?> getType() {
                return SelectionMode.class;
            }

            public String getName() {
                return "Selection Mode";
            }

            public String getDescription() {
                return "Selection Mode";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.todayProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setToday((LocalDate)value);
            }

            public Object getValue() {
                return DateControl.this.getToday();
            }

            public Class<?> getType() {
                return LocalDate.class;
            }

            public String getName() {
                return "Today";
            }

            public String getDescription() {
                return "Today";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.showTodayProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setShowToday((Boolean)value);
            }

            public Object getValue() {
                return DateControl.this.isShowToday();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Today";
            }

            public String getDescription() {
                return "Highlight today";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.zoneIdProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setZoneId((ZoneId)value);
            }

            public Object getValue() {
                return DateControl.this.getZoneId();
            }

            public Class<?> getType() {
                return ZoneId.class;
            }

            public String getName() {
                return "Timezone";
            }

            public String getDescription() {
                return "Timezone";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.weekFieldsProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setWeekFields((WeekFields)value);
            }

            public Object getValue() {
                return DateControl.this.getWeekFields();
            }

            public Class<?> getType() {
                return WeekFields.class;
            }

            public String getName() {
                return "Week Fields";
            }

            public String getDescription() {
                return "Week Fields (calendar standard)";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.timeProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setTime((LocalTime)value);
            }

            public Object getValue() {
                return DateControl.this.getTime();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "Time";
            }

            public String getDescription() {
                return "Time";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.startTimeProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setStartTime((LocalTime)value);
            }

            public Object getValue() {
                return DateControl.this.getStartTime();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "Start Time";
            }

            public String getDescription() {
                return "The first visible time at the top.";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.endTimeProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setEndTime((LocalTime)value);
            }

            public Object getValue() {
                return DateControl.this.getEndTime();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "End Time";
            }

            public String getDescription() {
                return "The last visible time at the bottom.";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.enableHyperlinksProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setEnableHyperlinks((Boolean)value);
            }

            public Object getValue() {
                return DateControl.this.isEnableHyperlinks();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Hyperlinks";
            }

            public String getDescription() {
                return "Hyperlinks enabled / disabled";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        return items;
    }

    public static enum Usage {
        NONE,
        VERY_LOW,
        LOW,
        MEDIUM,
        HIGH,
        VERY_HIGH;

    }

    public static enum Layout {
        STANDARD,
        SWIMLANE;

    }

    public static final class EntryDetailsPopOverContentParameter {
        private DateControl dateControl;
        private Node node;
        private Entry<?> entry;
        private PopOver popOver;

        public EntryDetailsPopOverContentParameter(PopOver popOver, DateControl control, Node node, Entry<?> entry) {
            this.popOver = Objects.requireNonNull(popOver);
            this.dateControl = Objects.requireNonNull(control);
            this.node = Objects.requireNonNull(node);
            this.entry = Objects.requireNonNull(entry);
        }

        public PopOver getPopOver() {
            return this.popOver;
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }

        public Node getNode() {
            return this.node;
        }

        public Entry<?> getEntry() {
            return this.entry;
        }
    }

    public static final class DateDetailsParameter
    extends DetailsParameter {
        private LocalDate localDate;

        public DateDetailsParameter(InputEvent inputEvent, DateControl control, Node owner, LocalDate date, double screenX, double screenY) {
            super(inputEvent, control, owner, screenX, screenY);
            this.localDate = Objects.requireNonNull(date);
        }

        public LocalDate getLocalDate() {
            return this.localDate;
        }
    }

    public static final class EntryDetailsParameter
    extends DetailsParameter {
        private Entry<?> entry;

        public EntryDetailsParameter(InputEvent inputEvent, DateControl control, Entry<?> entry, Node owner, double screenX, double screenY) {
            super(inputEvent, control, owner, screenX, screenY);
            this.entry = entry;
        }

        public Entry<?> getEntry() {
            return this.entry;
        }
    }

    private static abstract class DetailsParameter {
        private InputEvent inputEvent;
        private DateControl dateControl;
        private Node owner;
        private double screenX;
        private double screenY;

        public DetailsParameter(InputEvent inputEvent, DateControl control, Node owner, double screenX, double screenY) {
            this.inputEvent = inputEvent;
            this.dateControl = Objects.requireNonNull(control);
            this.owner = Objects.requireNonNull(owner);
            this.screenX = screenX;
            this.screenY = screenY;
        }

        public Node getOwner() {
            return this.owner;
        }

        public double getScreenX() {
            return this.screenX;
        }

        public double getScreenY() {
            return this.screenY;
        }

        public InputEvent getInputEvent() {
            return this.inputEvent;
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }
    }

    public static final class ContextMenuParameter
    extends ContextMenuParameterBase {
        private Calendar calendar;
        private ZonedDateTime zonedDateTime;

        public ContextMenuParameter(ContextMenuEvent evt, DateControl dateControl, Calendar calendar, ZonedDateTime time) {
            super(evt, dateControl);
            this.calendar = Objects.requireNonNull(calendar);
            this.zonedDateTime = time;
        }

        public Calendar getCalendar() {
            return this.calendar;
        }

        public ZonedDateTime getZonedDateTime() {
            return this.zonedDateTime;
        }

        public String toString() {
            return "ContextMenuParameter [calendar=" + this.calendar + ", zonedDateTime=" + this.zonedDateTime + "]";
        }
    }

    public static final class EntryEditParameter {
        private final DateControl dateControl;
        private final Entry<?> entry;
        private final EditOperation editOperation;

        public EntryEditParameter(DateControl dateControl, Entry<?> entry, EditOperation editOperation) {
            this.dateControl = Objects.requireNonNull(dateControl);
            this.entry = Objects.requireNonNull(entry);
            this.editOperation = Objects.requireNonNull(editOperation);
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }

        public Entry<?> getEntry() {
            return this.entry;
        }

        public EditOperation getEditOperation() {
            return this.editOperation;
        }

        public String toString() {
            return "EntryEditParameter{dateControl=" + (Object)((Object)this.dateControl) + ", entry=" + this.entry + ", editOperation=" + (Object)((Object)this.editOperation) + '}';
        }
    }

    public static enum EditOperation {
        CHANGE_START,
        CHANGE_END,
        MOVE,
        DELETE;

    }

    public static final class EntryContextMenuParameter
    extends ContextMenuParameterBase {
        private EntryViewBase<?> entryView;

        public EntryContextMenuParameter(ContextMenuEvent evt, DateControl control, EntryViewBase<?> entryView) {
            super(evt, control);
            this.entryView = Objects.requireNonNull(entryView);
        }

        public EntryViewBase<?> getEntryView() {
            return this.entryView;
        }

        public Entry<?> getEntry() {
            return this.entryView.getEntry();
        }

        public Calendar getCalendar() {
            return this.getEntry().getCalendar();
        }

        public String toString() {
            return "EntryContextMenuParameter [entry=" + this.entryView + ", dateControl =" + (Object)((Object)this.getDateControl()) + "]";
        }
    }

    public static final class CreateCalendarSourceParameter {
        private DateControl dateControl;

        public CreateCalendarSourceParameter(DateControl dateControl) {
            this.dateControl = Objects.requireNonNull(dateControl);
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }
    }

    public static final class CreateEntryParameter {
        private final Calendar calendar;
        private final ZonedDateTime zonedDateTime;
        private final DateControl control;

        public CreateEntryParameter(DateControl control, Calendar calendar, ZonedDateTime time) {
            this.control = Objects.requireNonNull(control);
            this.calendar = Objects.requireNonNull(calendar);
            this.zonedDateTime = Objects.requireNonNull(time);
        }

        public Calendar getDefaultCalendar() {
            return this.calendar;
        }

        public ZonedDateTime getZonedDateTime() {
            return this.zonedDateTime;
        }

        public DateControl getDateControl() {
            return this.control;
        }

        public String toString() {
            return "CreateEntryParameter [calendar=" + this.calendar + ", zonedDateTime=" + this.zonedDateTime + "]";
        }
    }

    private static abstract class ContextMenuParameterBase {
        private DateControl dateControl;
        private ContextMenuEvent contextMenuEvent;

        public ContextMenuParameterBase(ContextMenuEvent contextMenuEvent, DateControl dateControl) {
            this.contextMenuEvent = Objects.requireNonNull(contextMenuEvent);
            this.dateControl = Objects.requireNonNull(dateControl);
        }

        public ContextMenuEvent getContextMenuEvent() {
            return this.contextMenuEvent;
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }
    }
}

