/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.ZonedDateTimeProvider;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

class CreateDeleteHandler {
    private DateControl dateControl;

    public CreateDeleteHandler(DateControl control) {
        this.dateControl = Objects.requireNonNull(control);
        this.dateControl.addEventHandler(MouseEvent.MOUSE_CLICKED, this::createEntry);
        this.dateControl.addEventHandler(KeyEvent.KEY_PRESSED, this::deleteEntries);
    }

    private void createEntry(MouseEvent evt) {
        if (evt.getButton().equals((Object)MouseButton.PRIMARY) && evt.getClickCount() == 2) {
            LoggingDomain.VIEW.fine("create entry mouse event received inside control: " + ((Object)((Object)this.dateControl)).getClass().getSimpleName());
            ZonedDateTime time = ZonedDateTime.now();
            if (this.dateControl instanceof ZonedDateTimeProvider) {
                ZonedDateTimeProvider provider = (ZonedDateTimeProvider)((Object)this.dateControl);
                time = provider.getZonedDateTimeAt(evt.getX(), evt.getY());
            }
            Optional<Calendar> calendar = this.dateControl.getCalendarAt(evt.getX(), evt.getY());
            if (time != null) {
                this.dateControl.createEntryAt(time, calendar.orElse(null));
            }
        }
    }

    private void deleteEntries(KeyEvent evt) {
        switch (evt.getCode()) {
            case DELETE: 
            case BACK_SPACE: {
                for (Entry entry : this.dateControl.getSelections()) {
                    Calendar calendar;
                    if (!((Boolean)this.dateControl.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dateControl, entry, DateControl.EditOperation.DELETE))).booleanValue()) continue;
                    if (entry.isRecurrence()) {
                        entry = entry.getRecurrenceSourceEntry();
                    }
                    if (!((Boolean)this.dateControl.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dateControl, entry, DateControl.EditOperation.DELETE))).booleanValue() || (calendar = entry.getCalendar()) == null || calendar.isReadOnly()) continue;
                    entry.removeFromCalendar();
                }
                this.dateControl.clearSelection();
                break;
            }
            case F5: {
                this.dateControl.refreshData();
            }
        }
    }
}

