/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Entry;
import com.calendarfx.util.Util;
import com.calendarfx.view.AllDayEntryView;
import com.calendarfx.view.CreateDeleteHandler;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.ZonedDateTimeProvider;
import impl.com.calendarfx.view.AllDayViewSkin;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Insets;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class AllDayView
extends DateControl
implements ZonedDateTimeProvider {
    private static final String ALL_DAY_VIEW = "all-day-view";
    private StyleableObjectProperty<Insets> extraPadding;
    private StyleableDoubleProperty rowHeight;
    private StyleableDoubleProperty rowSpacing;
    private StyleableDoubleProperty columnSpacing;
    private final BooleanProperty adjustToFirstDayOfWeek = new SimpleBooleanProperty((Object)this, "adjustToFirstDayOfWeek", true);
    private final IntegerProperty numberOfDays = new SimpleIntegerProperty((Object)this, "numberOfDays");
    private final ObjectProperty<Callback<Entry<?>, AllDayEntryView>> entryViewFactory = new SimpleObjectProperty((Object)this, "entryViewFactory", AllDayEntryView::new);
    private static final String ALL_DAY_VIEW_CATEGORY = "All Day View";

    public AllDayView(int numberOfDays) {
        if (numberOfDays <= 0) {
            throw new IllegalArgumentException("number of days must be larger than zero");
        }
        this.getStyleClass().add((Object)ALL_DAY_VIEW);
        this.setNumberOfDays(numberOfDays);
        new CreateDeleteHandler(this);
    }

    public AllDayView() {
        this(7);
    }

    @Override
    public final ZonedDateTime getZonedDateTimeAt(double x, double y) {
        int day = (int)(x / (this.getWidth() / (double)this.getNumberOfDays()));
        LocalDate date = this.getDate();
        if (this.isAdjustToFirstDayOfWeek()) {
            date = Util.adjustToFirstDayOfWeek(date, this.getFirstDayOfWeek());
        }
        date = date.plusDays(day);
        LocalTime time = LocalTime.NOON;
        ZoneId zoneId = this.getZoneId();
        return ZonedDateTime.of(date, time, zoneId);
    }

    protected Skin<?> createDefaultSkin() {
        return new AllDayViewSkin(this);
    }

    public final ObjectProperty<Insets> extraPaddingProperty() {
        if (this.extraPadding == null) {
            this.extraPadding = new StyleableObjectProperty<Insets>(new Insets(2.0, 0.0, 9.0, 0.0)){

                public CssMetaData<AllDayView, Insets> getCssMetaData() {
                    return StyleableProperties.EXTRA_PADDING;
                }

                public Object getBean() {
                    return AllDayView.this;
                }

                public String getName() {
                    return "extraPadding";
                }
            };
        }
        return this.extraPadding;
    }

    public final Insets getExtraPadding() {
        return (Insets)this.extraPaddingProperty().get();
    }

    public final void setExtraPadding(Insets padding) {
        Objects.requireNonNull(padding);
        this.extraPaddingProperty().set((Object)padding);
    }

    public final DoubleProperty rowHeightProperty() {
        if (this.rowHeight == null) {
            this.rowHeight = new StyleableDoubleProperty(20.0){

                public CssMetaData<AllDayView, Number> getCssMetaData() {
                    return StyleableProperties.ROW_HEIGHT;
                }

                public Object getBean() {
                    return AllDayView.this;
                }

                public String getName() {
                    return "rowHeight";
                }
            };
        }
        return this.rowHeight;
    }

    public final double getRowHeight() {
        return this.rowHeightProperty().get();
    }

    public final void setRowHeight(double height) {
        this.rowHeightProperty().set(height);
    }

    public final DoubleProperty rowSpacingProperty() {
        if (this.rowSpacing == null) {
            this.rowSpacing = new StyleableDoubleProperty(2.0){

                public CssMetaData<AllDayView, Number> getCssMetaData() {
                    return StyleableProperties.ROW_SPACING;
                }

                public Object getBean() {
                    return AllDayView.this;
                }

                public String getName() {
                    return "rowSpacing";
                }
            };
        }
        return this.rowSpacing;
    }

    public final double getRowSpacing() {
        return this.rowSpacingProperty().get();
    }

    public final void setRowSpacing(double space) {
        if (space < 0.0) {
            throw new IllegalArgumentException("row spacing can not be smaller than zero");
        }
        this.rowSpacingProperty().set(space);
    }

    public final DoubleProperty columnSpacingProperty() {
        if (this.columnSpacing == null) {
            this.columnSpacing = new StyleableDoubleProperty(2.0){

                public CssMetaData<AllDayView, Number> getCssMetaData() {
                    return StyleableProperties.COLUMN_SPACING;
                }

                public Object getBean() {
                    return AllDayView.this;
                }

                public String getName() {
                    return "columnSpacing";
                }
            };
        }
        return this.columnSpacing;
    }

    public final double getColumnSpacing() {
        return this.columnSpacingProperty().get();
    }

    public final void setColumnSpacing(double space) {
        this.columnSpacingProperty().set(space);
    }

    public final BooleanProperty adjustToFirstDayOfWeekProperty() {
        return this.adjustToFirstDayOfWeek;
    }

    public final boolean isAdjustToFirstDayOfWeek() {
        return this.adjustToFirstDayOfWeekProperty().get();
    }

    public final void setAdjustToFirstDayOfWeek(boolean adjust) {
        this.adjustToFirstDayOfWeekProperty().set(adjust);
    }

    public final IntegerProperty numberOfDaysProperty() {
        return this.numberOfDays;
    }

    public final int getNumberOfDays() {
        return this.numberOfDaysProperty().get();
    }

    public final void setNumberOfDays(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("invalid number of days, must be larger than 0 but was " + number);
        }
        this.numberOfDaysProperty().set(number);
    }

    public final ObjectProperty<Callback<Entry<?>, AllDayEntryView>> entryViewFactoryProperty() {
        return this.entryViewFactory;
    }

    public final Callback<Entry<?>, AllDayEntryView> getEntryViewFactory() {
        return (Callback)this.entryViewFactoryProperty().get();
    }

    public final void setEntryViewFactory(Callback<Entry<?>, AllDayEntryView> factory) {
        Objects.requireNonNull(factory);
        this.entryViewFactoryProperty().set(factory);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public final List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return AllDayView.getClassCssMetaData();
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(AllDayView.this.numberOfDaysProperty());
            }

            public void setValue(Object value) {
                AllDayView.this.setNumberOfDays((Integer)value);
            }

            public Object getValue() {
                return AllDayView.this.getNumberOfDays();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public String getName() {
                return "Number Of Days";
            }

            public String getDescription() {
                return "Determines how many days will be covered by this control";
            }

            public String getCategory() {
                return AllDayView.ALL_DAY_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(AllDayView.this.columnSpacingProperty());
            }

            public void setValue(Object value) {
                AllDayView.this.setColumnSpacing((Double)value);
            }

            public Object getValue() {
                return AllDayView.this.getColumnSpacing();
            }

            public Class<?> getType() {
                return Double.class;
            }

            public String getName() {
                return "Column Spacing";
            }

            public String getDescription() {
                return "The gap between the days / columns";
            }

            public String getCategory() {
                return AllDayView.ALL_DAY_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(AllDayView.this.rowHeightProperty());
            }

            public void setValue(Object value) {
                AllDayView.this.setRowHeight((Double)value);
            }

            public Object getValue() {
                return AllDayView.this.getRowHeight();
            }

            public Class<?> getType() {
                return Double.class;
            }

            public String getName() {
                return "Row Height";
            }

            public String getDescription() {
                return "The height of each row in the control";
            }

            public String getCategory() {
                return AllDayView.ALL_DAY_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(AllDayView.this.rowSpacingProperty());
            }

            public void setValue(Object value) {
                AllDayView.this.setRowSpacing((Double)value);
            }

            public Object getValue() {
                return AllDayView.this.getRowSpacing();
            }

            public Class<?> getType() {
                return Double.class;
            }

            public String getName() {
                return "Row Spacing";
            }

            public String getDescription() {
                return "The gap between the rows";
            }

            public String getCategory() {
                return AllDayView.ALL_DAY_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(AllDayView.this.extraPaddingProperty());
            }

            public void setValue(Object value) {
                AllDayView.this.setExtraPadding((Insets)value);
            }

            public Object getValue() {
                return AllDayView.this.getExtraPadding();
            }

            public Class<?> getType() {
                return Insets.class;
            }

            public String getName() {
                return "Extra Padding";
            }

            public String getDescription() {
                return "Additional padding inside the control";
            }

            public String getCategory() {
                return AllDayView.ALL_DAY_VIEW_CATEGORY;
            }
        });
        return items;
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        private static final CssMetaData<AllDayView, Number> ROW_HEIGHT;
        private static final CssMetaData<AllDayView, Number> ROW_SPACING;
        private static final CssMetaData<AllDayView, Number> COLUMN_SPACING;
        private static final CssMetaData<AllDayView, Insets> EXTRA_PADDING;

        private StyleableProperties() {
        }

        static {
            ROW_HEIGHT = new CssMetaData<AllDayView, Number>("-fx-row-height", StyleConverter.getSizeConverter(), (Number)20.0){

                public Double getInitialValue(AllDayView node) {
                    return node.getRowHeight();
                }

                public boolean isSettable(AllDayView n) {
                    return n.rowHeight == null || !n.rowHeight.isBound();
                }

                public StyleableProperty<Number> getStyleableProperty(AllDayView n) {
                    return (StyleableProperty)n.rowHeightProperty();
                }
            };
            ROW_SPACING = new CssMetaData<AllDayView, Number>("-fx-row-spacing", StyleConverter.getSizeConverter(), (Number)2.0){

                public Double getInitialValue(AllDayView node) {
                    return node.getRowSpacing();
                }

                public boolean isSettable(AllDayView n) {
                    return n.rowSpacing == null || !n.rowSpacing.isBound();
                }

                public StyleableProperty<Number> getStyleableProperty(AllDayView n) {
                    return (StyleableProperty)n.rowSpacingProperty();
                }
            };
            COLUMN_SPACING = new CssMetaData<AllDayView, Number>("-fx-column-spacing", StyleConverter.getSizeConverter(), (Number)2.0){

                public Double getInitialValue(AllDayView node) {
                    return node.getColumnSpacing();
                }

                public boolean isSettable(AllDayView n) {
                    return n.columnSpacing == null || !n.columnSpacing.isBound();
                }

                public StyleableProperty<Number> getStyleableProperty(AllDayView n) {
                    return (StyleableProperty)n.columnSpacingProperty();
                }
            };
            EXTRA_PADDING = new CssMetaData<AllDayView, Insets>("-fx-extra-padding", StyleConverter.getInsetsConverter(), Insets.EMPTY){

                public Insets getInitialValue(AllDayView node) {
                    return node.getExtraPadding();
                }

                public boolean isSettable(AllDayView n) {
                    return n.extraPadding == null || !n.extraPadding.isBound();
                }

                public StyleableProperty<Insets> getStyleableProperty(AllDayView n) {
                    return (StyleableProperty)n.extraPaddingProperty();
                }
            };
            ArrayList<Object> styleables = new ArrayList<Object>(Region.getClassCssMetaData());
            styleables.add(ROW_HEIGHT);
            styleables.add(ROW_SPACING);
            styleables.add(COLUMN_SPACING);
            styleables.add(EXTRA_PADDING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

