/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Entry;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RequestEvent;
import impl.com.calendarfx.view.AgendaViewSkin;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Skin;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.shape.Circle;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class AgendaView
extends DateControl {
    private static final String DEFAULT_STYLE_CLASS = "agenda-view";
    private final ListView<AgendaEntry> listView = new ListView();
    private final IntegerProperty lookBackPeriodInDays = new SimpleIntegerProperty((Object)this, "lookBackPeriodInDays", 0);
    private final IntegerProperty lookAheadPeriodInDays = new SimpleIntegerProperty((Object)this, "lookAheadPeriodInDays", 30);
    private final BooleanProperty showStatusLabel = new SimpleBooleanProperty((Object)this, "showStatusLabel", true);
    private final ObjectProperty<Callback<AgendaView, ? extends AgendaEntryCell>> cellFactory = new SimpleObjectProperty<Callback<AgendaView, ? extends AgendaEntryCell>>((Object)this, "cellFactory", view -> new AgendaEntryCell(this)){

        public void set(Callback<AgendaView, ? extends AgendaEntryCell> newValue) {
            super.set(Objects.requireNonNull(newValue));
        }
    };
    private final String AGENDA_CATEGORY = "Agenda View";

    public AgendaView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.listView.setCellFactory(listView -> (AgendaEntryCell)((Object)((Object)this.getCellFactory().call((Object)this))));
        this.setContextMenu(this.buildContextMenu());
    }

    public final ListView<AgendaEntry> getListView() {
        return this.listView;
    }

    protected Skin<?> createDefaultSkin() {
        return new AgendaViewSkin(this);
    }

    private ContextMenu buildContextMenu() {
        ContextMenu menu = new ContextMenu();
        Menu lookBackMenu = new Menu(Messages.getString("AgendaView.MENU_ITEM_LOOK_BACK"));
        Menu lookAheadMenu = new Menu(Messages.getString("AgendaView.MENU_ITEM_LOOK_AHEAD"));
        String format = Messages.getString("AgendaView.MENU_ITEM_DAYS");
        MenuItem lookBack0 = new MenuItem(MessageFormat.format(format, 0));
        MenuItem lookBack10 = new MenuItem(MessageFormat.format(format, 10));
        MenuItem lookBack20 = new MenuItem(MessageFormat.format(format, 20));
        MenuItem lookBack30 = new MenuItem(MessageFormat.format(format, 30));
        MenuItem lookAhead0 = new MenuItem(MessageFormat.format(format, 0));
        MenuItem lookAhead10 = new MenuItem(MessageFormat.format(format, 10));
        MenuItem lookAhead20 = new MenuItem(MessageFormat.format(format, 20));
        MenuItem lookAhead30 = new MenuItem(MessageFormat.format(format, 30));
        lookBackMenu.getItems().addAll((Object[])new MenuItem[]{lookBack0, lookBack10, lookBack20, lookBack30});
        lookAheadMenu.getItems().addAll((Object[])new MenuItem[]{lookAhead0, lookAhead10, lookAhead20, lookAhead30});
        menu.getItems().addAll((Object[])new MenuItem[]{lookBackMenu, lookAheadMenu});
        lookBack0.setOnAction(evt -> this.setLookBackPeriodInDays(0));
        lookBack10.setOnAction(evt -> this.setLookBackPeriodInDays(10));
        lookBack20.setOnAction(evt -> this.setLookBackPeriodInDays(20));
        lookBack30.setOnAction(evt -> this.setLookBackPeriodInDays(30));
        lookAhead0.setOnAction(evt -> this.setLookAheadPeriodInDays(0));
        lookAhead10.setOnAction(evt -> this.setLookAheadPeriodInDays(10));
        lookAhead20.setOnAction(evt -> this.setLookAheadPeriodInDays(20));
        lookAhead30.setOnAction(evt -> this.setLookAheadPeriodInDays(30));
        return menu;
    }

    public final IntegerProperty lookBackPeriodInDaysProperty() {
        return this.lookBackPeriodInDays;
    }

    public final int getLookBackPeriodInDays() {
        return this.lookBackPeriodInDaysProperty().get();
    }

    public final void setLookBackPeriodInDays(int days) {
        if (days < 0) {
            throw new IllegalArgumentException("days must be larger than or equal to 0");
        }
        this.lookBackPeriodInDaysProperty().set(days);
    }

    public final IntegerProperty lookAheadPeriodInDaysProperty() {
        return this.lookAheadPeriodInDays;
    }

    public final int getLookAheadPeriodInDays() {
        return this.lookAheadPeriodInDaysProperty().get();
    }

    public final void setLookAheadPeriodInDays(int days) {
        if (days < 0) {
            throw new IllegalArgumentException("days must be larger than or equal to 0");
        }
        this.lookAheadPeriodInDaysProperty().set(days);
    }

    public final BooleanProperty showStatusLabelProperty() {
        return this.showStatusLabel;
    }

    public final boolean isShowStatusLabel() {
        return this.showStatusLabelProperty().get();
    }

    public final void setShowStatusLabel(boolean showStatusLabel) {
        this.showStatusLabelProperty().set(showStatusLabel);
    }

    public final ObjectProperty<Callback<AgendaView, ? extends AgendaEntryCell>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final Callback<AgendaView, ? extends AgendaEntryCell> getCellFactory() {
        return (Callback)this.cellFactoryProperty().get();
    }

    public final void setCellFactory(Callback<AgendaView, ? extends AgendaEntryCell> cellFactory) {
        this.cellFactoryProperty().set(cellFactory);
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(AgendaView.this.lookAheadPeriodInDaysProperty());
            }

            public void setValue(Object value) {
                AgendaView.this.setLookAheadPeriodInDays((Integer)value);
            }

            public Object getValue() {
                return AgendaView.this.getLookAheadPeriodInDays();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public String getName() {
                return "Look Ahead Period";
            }

            public String getDescription() {
                return "Look ahead period in days";
            }

            public String getCategory() {
                return "Agenda View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(AgendaView.this.lookBackPeriodInDaysProperty());
            }

            public void setValue(Object value) {
                AgendaView.this.setLookBackPeriodInDays((Integer)value);
            }

            public Object getValue() {
                return AgendaView.this.getLookBackPeriodInDays();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public String getName() {
                return "Look Back Period";
            }

            public String getDescription() {
                return "Look back period in days";
            }

            public String getCategory() {
                return "Agenda View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(AgendaView.this.showStatusLabelProperty());
            }

            public void setValue(Object value) {
                AgendaView.this.setShowStatusLabel((Boolean)value);
            }

            public Object getValue() {
                return AgendaView.this.isShowStatusLabel();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Status Label";
            }

            public String getDescription() {
                return "Show Status Label";
            }

            public String getCategory() {
                return "Agenda View";
            }
        });
        return items;
    }

    public static class AgendaEntryCell
    extends ListCell<AgendaEntry> {
        private static final String AGENDA_VIEW_LIST_CELL = "agenda-view-list-cell";
        private static final String AGENDA_VIEW_TIME_LABEL = "time-label";
        private static final String AGENDA_VIEW_TITLE_LABEL = "title-label";
        private static final String AGENDA_VIEW_BODY = "body";
        private static final String AGENDA_VIEW_DATE_LABEL = "date-label";
        private static final String AGENDA_VIEW_DATE_LABEL_TODAY = "today";
        private static final String AGENDA_VIEW_WEEKDAY_LABEL = "weekday-label";
        private static final String AGENDA_VIEW_WEEKDAY_LABEL_TODAY = "today";
        private static final String AGENDA_VIEW_HEADER = "header";
        private static final String AGENDA_VIEW_HEADER_TODAY = "today";
        private static final String AGENDA_VIEW_BODY_SEPARATOR = "separator";
        private final DateTimeFormatter weekdayFormatter = DateTimeFormatter.ofPattern(Messages.getString("AgendaEntryCell.WEEKDAY_FORMAT"));
        private final DateTimeFormatter mediumDateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
        private final DateTimeFormatter shortDateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
        private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
        private Label weekdayLabel;
        private Label dateLabel;
        private GridPane gridPane;
        private BorderPane headerPane;
        private boolean headerPaneVisible;
        private final AgendaView agendaView;

        public AgendaEntryCell(AgendaView view) {
            this(view, true);
        }

        public AgendaEntryCell(AgendaView view, boolean headerPaneVisible) {
            this.agendaView = Objects.requireNonNull(view);
            this.headerPaneVisible = headerPaneVisible;
            BorderPane borderPane = new BorderPane();
            borderPane.getStyleClass().add((Object)"container");
            borderPane.setTop(this.createHeader());
            borderPane.setCenter(this.createBody());
            this.setGraphic((Node)borderPane);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.getStyleClass().add((Object)AGENDA_VIEW_LIST_CELL);
        }

        protected Node createBody() {
            ColumnConstraints iconColumn = new ColumnConstraints();
            ColumnConstraints descriptionColumn = new ColumnConstraints();
            descriptionColumn.setFillWidth(true);
            descriptionColumn.setHgrow(Priority.SOMETIMES);
            descriptionColumn.setMinWidth(0.0);
            descriptionColumn.setPrefWidth(0.0);
            ColumnConstraints timeColumn = new ColumnConstraints();
            timeColumn.setHalignment(HPos.RIGHT);
            this.gridPane = new GridPane();
            this.gridPane.setGridLinesVisible(true);
            this.gridPane.setMinWidth(0.0);
            this.gridPane.setPrefWidth(0.0);
            this.gridPane.getStyleClass().add((Object)AGENDA_VIEW_BODY);
            this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{iconColumn, descriptionColumn, timeColumn});
            return this.gridPane;
        }

        protected Node createHeader() {
            this.headerPane = new BorderPane();
            this.headerPane.getStyleClass().add((Object)AGENDA_VIEW_HEADER);
            this.headerPane.setVisible(this.headerPaneVisible);
            this.headerPane.managedProperty().bind((ObservableValue)this.headerPane.visibleProperty());
            this.weekdayLabel = new Label();
            this.weekdayLabel.getStyleClass().add((Object)AGENDA_VIEW_WEEKDAY_LABEL);
            this.weekdayLabel.setMinWidth(0.0);
            this.dateLabel = new Label();
            this.dateLabel.setMinWidth(0.0);
            this.dateLabel.getStyleClass().add((Object)AGENDA_VIEW_DATE_LABEL);
            this.headerPane.setLeft((Node)this.weekdayLabel);
            this.headerPane.setRight((Node)this.dateLabel);
            return this.headerPane;
        }

        protected void updateItem(AgendaEntry item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.gridPane.getChildren().clear();
            if (item != null) {
                LocalDate date = item.getDate();
                if (date.equals(this.agendaView.getToday())) {
                    if (!this.headerPane.getStyleClass().contains((Object)"today")) {
                        this.headerPane.getStyleClass().add((Object)"today");
                        this.dateLabel.getStyleClass().add((Object)"today");
                        this.weekdayLabel.getStyleClass().add((Object)"today");
                    }
                } else {
                    this.headerPane.getStyleClass().remove((Object)"today");
                    this.dateLabel.getStyleClass().remove((Object)"today");
                    this.weekdayLabel.getStyleClass().remove((Object)"today");
                }
                this.dateLabel.setText(this.mediumDateFormatter.format(date));
                this.weekdayLabel.setText(this.weekdayFormatter.format(date));
                int count = item.getEntries().size();
                int row = 0;
                for (int i = 0; i < count; ++i) {
                    Entry<?> entry = item.getEntries().get(i);
                    Node entryGraphic = this.createEntryGraphic(entry);
                    this.gridPane.add(entryGraphic, 0, row);
                    Label titleLabel = this.createEntryTitleLabel(entry);
                    titleLabel.setMinWidth(0.0);
                    this.gridPane.add((Node)titleLabel, 1, row);
                    Label timeLabel = this.createEntryTimeLabel(entry);
                    timeLabel.setMinWidth(0.0);
                    this.gridPane.add((Node)timeLabel, 2, row);
                    if (count > 1 && i < count - 1) {
                        Region separator = new Region();
                        separator.getStyleClass().add((Object)AGENDA_VIEW_BODY_SEPARATOR);
                        this.gridPane.add((Node)separator, 0, ++row);
                        GridPane.setColumnSpan((Node)separator, (Integer)3);
                        GridPane.setFillWidth((Node)separator, (Boolean)true);
                    }
                    ++row;
                }
                this.getGraphic().setVisible(true);
            } else {
                this.getGraphic().setVisible(false);
            }
        }

        protected Label createEntryTimeLabel(Entry<?> entry) {
            Label timeLabel = new Label(this.getTimeText(entry));
            timeLabel.getStyleClass().add((Object)AGENDA_VIEW_TIME_LABEL);
            if (this.agendaView.isEnableHyperlinks()) {
                timeLabel.setOnMouseClicked(evt -> this.fireEvent(new RequestEvent((Object)this, (EventTarget)this, entry)));
                timeLabel.getStyleClass().add((Object)"date-hyperlink");
            }
            return timeLabel;
        }

        protected Label createEntryTitleLabel(Entry<?> entry) {
            Label titleLabel = new Label(entry.getTitle());
            titleLabel.getStyleClass().add((Object)AGENDA_VIEW_TITLE_LABEL);
            if (this.agendaView.isEnableHyperlinks()) {
                titleLabel.setOnMouseClicked(evt -> this.fireEvent(new RequestEvent((Object)this, (EventTarget)this, entry)));
                titleLabel.getStyleClass().add((Object)"date-hyperlink");
            }
            return titleLabel;
        }

        protected Node createEntryGraphic(Entry<?> entry) {
            Circle circle = new Circle(4.0);
            circle.getStyleClass().add((Object)(entry.getCalendar().getStyle() + "-icon"));
            return circle;
        }

        protected String getTimeText(Entry<?> entry) {
            LocalDate endDate;
            if (entry.isFullDay()) {
                return Messages.getString("AgendaEntryCell.ALL_DAY");
            }
            LocalDate startDate = entry.getStartDate();
            String text = startDate.equals(endDate = entry.getEndDate()) ? MessageFormat.format(Messages.getString("AgendaEntryCell.ENTRY_TIME_RANGE"), this.timeFormatter.format(entry.getStartTime()), this.timeFormatter.format(entry.getEndTime())) : MessageFormat.format(Messages.getString("AgendaEntryCell.ENTRY_TIME_RANGE_WITH_DATE"), this.shortDateFormatter.format(entry.getStartDate()), this.timeFormatter.format(entry.getStartTime()), this.shortDateFormatter.format(entry.getEndDate()), this.timeFormatter.format(entry.getEndTime()));
            return text;
        }
    }

    public static class AgendaEntry
    implements Comparable<AgendaEntry> {
        private LocalDate date;
        private final List<Entry<?>> entries = new ArrayList();

        public AgendaEntry(LocalDate date) {
            this.date = Objects.requireNonNull(date);
        }

        public LocalDate getDate() {
            return this.date;
        }

        public final List<Entry<?>> getEntries() {
            return this.entries;
        }

        @Override
        public int compareTo(AgendaEntry o) {
            return this.getDate().compareTo(o.getDate());
        }
    }
}

