/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.util;

import com.calendarfx.view.Messages;
import com.google.ical.values.DateValue;
import com.google.ical.values.Frequency;
import com.google.ical.values.RRule;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakListener;
import javafx.beans.property.Property;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollBar;

public class Util {
    public static String convertRFC2445ToText(String rrule, LocalDate startDate) {
        try {
            int count;
            List byDay;
            RRule rule = new RRule(rrule);
            StringBuilder sb = new StringBuilder();
            String granularity = "";
            String granularities = "";
            switch (rule.getFreq()) {
                case DAILY: {
                    granularity = Messages.getString("Util.DAY");
                    granularities = Messages.getString("Util.DAYS");
                    break;
                }
                case MONTHLY: {
                    granularity = Messages.getString("Util.MONTH");
                    granularities = Messages.getString("Util.MONTHS");
                    break;
                }
                case WEEKLY: {
                    granularity = Messages.getString("Util.WEEK");
                    granularities = Messages.getString("Util.WEEKS");
                    break;
                }
                case YEARLY: {
                    granularity = Messages.getString("Util.YEAR");
                    granularities = Messages.getString("Util.YEARS");
                    break;
                }
                case HOURLY: {
                    granularity = Messages.getString("Util.HOUR");
                    granularities = Messages.getString("Util.HOURS");
                    break;
                }
                case MINUTELY: {
                    granularity = Messages.getString("Util.MINUTE");
                    granularities = Messages.getString("Util.MINUTES");
                    break;
                }
                case SECONDLY: {
                    granularity = Messages.getString("Util.SECOND");
                    granularities = Messages.getString("Util.SECONDS");
                }
            }
            int interval = rule.getInterval();
            if (interval > 1) {
                sb.append(MessageFormat.format(Messages.getString("Util.EVERY_PLURAL"), rule.getInterval(), granularities));
            } else {
                sb.append(MessageFormat.format(Messages.getString("Util.EVERY_SINGULAR"), granularity));
            }
            if (rule.getFreq().equals((Object)Frequency.WEEKLY) && !(byDay = rule.getByDay()).isEmpty()) {
                sb.append(Messages.getString("Util.ON_WEEKDAY"));
                for (int i = 0; i < byDay.size(); ++i) {
                    WeekdayNum num = (WeekdayNum)byDay.get(i);
                    sb.append(Util.makeHuman(num.wday));
                    if (i >= byDay.size() - 1) continue;
                    sb.append(", ");
                }
            }
            if (rule.getFreq().equals((Object)Frequency.MONTHLY)) {
                if (rule.getByMonthDay().length > 0) {
                    int day = rule.getByMonthDay()[0];
                    sb.append(Messages.getString("Util.ON_MONTH_DAY"));
                    sb.append(day);
                } else if (!rule.getByDay().isEmpty()) {
                    WeekdayNum num = (WeekdayNum)rule.getByDay().get(0);
                    sb.append(MessageFormat.format(Messages.getString("Util.ON_MONTH_WEEKDAY"), Util.makeHuman(num.num), Util.makeHuman(num.wday)));
                }
            }
            if (rule.getFreq().equals((Object)Frequency.YEARLY)) {
                sb.append(MessageFormat.format(Messages.getString("Util.ON_DATE"), DateTimeFormatter.ofPattern(Messages.getString("Util.MONTH_AND_DAY_FORMAT")).format(startDate)));
            }
            if ((count = rule.getCount()) > 0) {
                if (count == 1) {
                    return Messages.getString("Util.ONCE");
                }
                sb.append(MessageFormat.format(Messages.getString("Util.TIMES"), count));
            } else {
                DateValue until = rule.getUntil();
                if (until != null) {
                    LocalDate localDate = LocalDate.of(until.year(), until.month(), until.day());
                    sb.append(MessageFormat.format(Messages.getString("Util.UNTIL_DATE"), DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(localDate)));
                }
            }
            return sb.toString();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return Messages.getString("Util.INVALID_RULE");
        }
    }

    private static String makeHuman(Weekday wday) {
        switch (wday) {
            case FR: {
                return Messages.getString("Util.FRIDAY");
            }
            case MO: {
                return Messages.getString("Util.MONDAY");
            }
            case SA: {
                return Messages.getString("Util.SATURDAY");
            }
            case SU: {
                return Messages.getString("Util.SUNDAY");
            }
            case TH: {
                return Messages.getString("Util.THURSDAY");
            }
            case TU: {
                return Messages.getString("Util.TUESDAY");
            }
            case WE: {
                return Messages.getString("Util.WEDNESDAY");
            }
        }
        throw new IllegalArgumentException("unknown weekday: " + wday);
    }

    private static String makeHuman(int num) {
        switch (num) {
            case 1: {
                return Messages.getString("Util.FIRST");
            }
            case 2: {
                return Messages.getString("Util.SECOND");
            }
            case 3: {
                return Messages.getString("Util.THIRD");
            }
            case 4: {
                return Messages.getString("Util.FOURTH");
            }
            case 5: {
                return Messages.getString("Util.FIFTH");
            }
        }
        return Integer.toString(num);
    }

    public static ScrollBar findScrollBar(Parent parent, Orientation orientation) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            ScrollBar b;
            if (node instanceof ScrollBar && (b = (ScrollBar)node).getOrientation().equals((Object)orientation)) {
                return b;
            }
            if (!(node instanceof Parent) || (b = Util.findScrollBar((Parent)node, orientation)) == null) continue;
            return b;
        }
        return null;
    }

    public static LocalDate adjustToFirstDayOfWeek(LocalDate date, DayOfWeek firstDayOfWeek) {
        LocalDate newDate = date.with(ChronoField.DAY_OF_WEEK, firstDayOfWeek.getValue());
        if (newDate.isAfter(date)) {
            newDate = newDate.minusWeeks(1L);
        }
        return newDate;
    }

    public static LocalDate adjustToLastDayOfWeek(LocalDate date, DayOfWeek firstDayOfWeek) {
        LocalDate startOfWeek = Util.adjustToFirstDayOfWeek(date, firstDayOfWeek);
        return startOfWeek.plusDays(6L);
    }

    public static <L, R> void bindBidirectional(Property<L> leftProperty, Property<R> rightProperty, Converter<L, R> converter) {
        BidirectionalConversionBinding binding = new BidirectionalConversionBinding(leftProperty, rightProperty, converter);
        leftProperty.addListener(binding);
        rightProperty.addListener(binding);
        leftProperty.setValue(converter.toLeft(rightProperty.getValue()));
    }

    private static class BidirectionalConversionBinding<L, R>
    implements InvalidationListener,
    WeakListener {
        private WeakReference<Property<L>> leftReference;
        private WeakReference<Property<R>> rightReference;
        private Converter<L, R> converter;
        private boolean updating;

        private BidirectionalConversionBinding(Property<L> leftProperty, Property<R> rightProperty, Converter<L, R> converter) {
            this.leftReference = new WeakReference<Property<L>>(Objects.requireNonNull(leftProperty));
            this.rightReference = new WeakReference<Property<R>>(Objects.requireNonNull(rightProperty));
            this.converter = Objects.requireNonNull(converter);
        }

        public Property<L> getLeftProperty() {
            return (Property)this.leftReference.get();
        }

        public Property<R> getRightProperty() {
            return (Property)this.rightReference.get();
        }

        public boolean wasGarbageCollected() {
            return this.getLeftProperty() == null || this.getRightProperty() == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidated(Observable observable) {
            if (this.updating) {
                return;
            }
            Property<L> leftProperty = this.getLeftProperty();
            Property<R> rightProperty = this.getRightProperty();
            if (this.wasGarbageCollected()) {
                if (leftProperty != null) {
                    leftProperty.removeListener((InvalidationListener)this);
                }
                if (rightProperty != null) {
                    rightProperty.removeListener((InvalidationListener)this);
                }
            } else {
                try {
                    this.updating = true;
                    if (observable == leftProperty) {
                        rightProperty.setValue(this.converter.toRight(leftProperty.getValue()));
                    } else {
                        leftProperty.setValue(this.converter.toLeft(rightProperty.getValue()));
                    }
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }

    public static interface Converter<L, R> {
        public L toLeft(R var1);

        public R toRight(L var1);
    }
}

