/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.model;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.Interval;
import com.calendarfx.util.LoggingDomain;
import com.google.ical.compat.javatime.LocalDateIterator;
import com.google.ical.compat.javatime.LocalDateIteratorFactory;
import com.google.ical.values.DateValue;
import com.google.ical.values.RRule;
import impl.com.calendarfx.view.util.Util;
import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.controlsfx.control.PropertySheet;

public class Entry<T>
implements Comparable<Entry<?>> {
    private static final Duration DEFAULT_MINIMUM_DURATION = Duration.ofMinutes(15L);
    private static long idCounter;
    private String id = Entry.createId();
    private ObservableMap<Object, Object> properties;
    private ObservableList<String> styleClass;
    private final ObjectProperty<Interval> interval = new SimpleObjectProperty<Interval>((Object)this, "interval"){

        public void set(Interval newInterval) {
            if (newInterval == null) {
                return;
            }
            Interval oldInterval = (Interval)this.getValue();
            if (!Util.equals(newInterval, oldInterval)) {
                Calendar calendar = Entry.this.getCalendar();
                if (!Entry.this.isRecurrence() && calendar != null) {
                    calendar.impl_removeEntry(Entry.this);
                }
                super.set((Object)newInterval);
                if (Entry.this.startDate != null) {
                    Entry.this.startDate.set((Object)newInterval.getStartDate());
                }
                if (Entry.this.startTime != null) {
                    Entry.this.startTime.set((Object)newInterval.getStartTime());
                }
                if (Entry.this.endDate != null) {
                    Entry.this.endDate.set((Object)newInterval.getEndDate());
                }
                if (Entry.this.endTime != null) {
                    Entry.this.endTime.set((Object)newInterval.getEndTime());
                }
                if (Entry.this.zoneId != null) {
                    Entry.this.zoneId.set((Object)newInterval.getZoneId());
                }
                Entry.this.updateMultiDay();
                if (calendar != null) {
                    if (!Entry.this.isRecurrence()) {
                        calendar.impl_addEntry(Entry.this);
                    }
                    calendar.fireEvent(new CalendarEvent(CalendarEvent.ENTRY_INTERVAL_CHANGED, calendar, Entry.this, oldInterval));
                }
            }
        }
    };
    private ReadOnlyObjectWrapper<Entry<T>> recurrenceSource;
    private boolean _recurrence;
    private ReadOnlyBooleanWrapper recurrence;
    private StringProperty recurrenceRule;
    private String _recurrenceId;
    private ReadOnlyStringWrapper recurrenceId;
    private LocalDate _recurrenceEnd;
    private ReadOnlyObjectWrapper<LocalDate> recurrenceEnd;
    private SimpleObjectProperty<Calendar> calendar = new SimpleObjectProperty<Calendar>((Object)this, "calendar"){

        public void set(Calendar newCalendar) {
            Calendar oldCalendar = (Calendar)this.get();
            if (!Util.equals(oldCalendar, newCalendar)) {
                if (oldCalendar != null && !Entry.this.isRecurrence()) {
                    oldCalendar.impl_removeEntry(Entry.this);
                }
                super.set((Object)newCalendar);
                if (newCalendar != null && !Entry.this.isRecurrence()) {
                    newCalendar.impl_addEntry(Entry.this);
                }
                if (newCalendar != null) {
                    newCalendar.fireEvent(new CalendarEvent(CalendarEvent.ENTRY_CALENDAR_CHANGED, newCalendar, Entry.this, oldCalendar));
                } else if (oldCalendar != null) {
                    oldCalendar.fireEvent(new CalendarEvent(CalendarEvent.ENTRY_CALENDAR_CHANGED, newCalendar, Entry.this, oldCalendar));
                }
            }
        }
    };
    private ObjectProperty<T> userObject;
    private ReadOnlyObjectWrapper<ZoneId> zoneId;
    private final StringProperty title = new SimpleStringProperty(this, "title"){

        public void set(String newTitle) {
            String oldTitle = this.get();
            if (!Util.equals(oldTitle, newTitle)) {
                super.set(newTitle);
                Calendar calendar = Entry.this.getCalendar();
                if (calendar != null) {
                    calendar.fireEvent(new CalendarEvent(CalendarEvent.ENTRY_TITLE_CHANGED, calendar, Entry.this, oldTitle));
                }
            }
        }
    };
    private StringProperty location;
    private ReadOnlyObjectWrapper<LocalDate> startDate;
    private ReadOnlyObjectWrapper<LocalTime> startTime;
    private ReadOnlyObjectWrapper<LocalDate> endDate;
    private ReadOnlyObjectWrapper<LocalTime> endTime;
    private final BooleanProperty fullDay = new SimpleBooleanProperty(this, "fullDay", false){

        public void set(boolean newFullDay) {
            boolean oldFullDay = this.get();
            if (!Util.equals(oldFullDay, newFullDay)) {
                super.set(newFullDay);
                Calendar calendar = Entry.this.getCalendar();
                if (calendar != null) {
                    calendar.fireEvent(new CalendarEvent(CalendarEvent.ENTRY_FULL_DAY_CHANGED, calendar, Entry.this));
                }
            }
        }
    };
    private Duration _minimumDuration = DEFAULT_MINIMUM_DURATION;
    private ObjectProperty<Duration> minimumDuration;
    private boolean _multiDay;
    private ReadOnlyBooleanWrapper multiDay;
    private static final String ENTRY_CATEGORY = "Entry";

    private static synchronized String createId() {
        return Long.toString(idCounter++);
    }

    public Entry() {
        this("Untitled", new Interval());
    }

    public Entry(String title) {
        this(title, new Interval());
    }

    public Entry(String title, Interval interval) {
        Objects.requireNonNull(title);
        Objects.requireNonNull(interval);
        this.setTitle(title);
        this.setInterval(interval);
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
            MapChangeListener changeListener = change -> {
                if (change.getKey().equals("com.calendarfx.recurrence.source")) {
                    if (change.getValueAdded() != null) {
                        Entry source = (Entry)change.getValueAdded();
                        this.recurrenceSourceProperty();
                        this.recurrenceSource.set((Object)source);
                    }
                } else if (change.getKey().equals("com.calendarfx.recurrence.id") && change.getValueAdded() != null) {
                    this.setRecurrenceId((String)change.getValueAdded());
                }
            };
            this.properties.addListener(changeListener);
        }
        return this.properties;
    }

    public final boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public final boolean hasStyleClass() {
        return this.styleClass != null && !this.styleClass.isEmpty();
    }

    public final ObservableList<String> getStyleClass() {
        if (this.styleClass == null) {
            this.styleClass = FXCollections.observableArrayList();
        }
        return this.styleClass;
    }

    public final ObjectProperty<Interval> intervalProperty() {
        return this.interval;
    }

    public final Interval getInterval() {
        return (Interval)this.interval.get();
    }

    public final void setInterval(Interval interval) {
        Objects.requireNonNull(interval);
        this.intervalProperty().set((Object)interval);
    }

    public final void setInterval(LocalDate date) {
        this.setInterval(date, ZoneId.systemDefault());
    }

    public final void setInterval(LocalDate date, ZoneId zoneId) {
        this.setInterval(date, date, zoneId);
    }

    public final void setInterval(LocalDate startDate, LocalDate endDate) {
        this.setInterval(startDate, endDate, ZoneId.systemDefault());
    }

    public final void setInterval(LocalDate startDate, LocalDate endDate, ZoneId zoneId) {
        this.setInterval(startDate, LocalTime.MIN, endDate, LocalTime.MAX, zoneId);
    }

    public final void setInterval(LocalDate startDate, LocalTime startTime, LocalDate endDate, LocalTime endTime) {
        this.setInterval(startDate, startTime, endDate, endTime, ZoneId.systemDefault());
    }

    public final void setInterval(LocalDate startDate, LocalTime startTime, LocalDate endDate, LocalTime endTime, ZoneId zoneId) {
        this.setInterval(new Interval(startDate, startTime, endDate, endTime, zoneId));
    }

    public final void setInterval(LocalTime startTime, LocalTime endTime) {
        this.setInterval(startTime, endTime, ZoneId.systemDefault());
    }

    public final void setInterval(LocalTime startTime, LocalTime endTime, ZoneId zoneId) {
        this.setInterval(this.getStartDate(), startTime, this.getEndDate(), endTime, zoneId);
    }

    public final void setInterval(LocalDateTime dateTime) {
        this.setInterval(dateTime, dateTime);
    }

    public final void setInterval(LocalDateTime dateTime, ZoneId zoneId) {
        this.setInterval(dateTime, dateTime, zoneId);
    }

    public final void setInterval(LocalDateTime startDateTime, LocalDateTime endDateTime) {
        this.setInterval(startDateTime, endDateTime, ZoneId.systemDefault());
    }

    public final void setInterval(LocalDateTime startDateTime, LocalDateTime endDateTime, ZoneId zoneId) {
        this.setInterval(new Interval(startDateTime, endDateTime, zoneId));
    }

    public final void setInterval(ZonedDateTime date) {
        this.setInterval(date, date);
    }

    public final void setInterval(ZonedDateTime startDate, ZonedDateTime endDate) {
        this.setInterval(new Interval(startDate, endDate));
    }

    public final void changeStartDate(LocalDate date) {
        this.changeStartDate(date, false);
    }

    public final void changeStartDate(LocalDate date, boolean keepDuration) {
        Objects.requireNonNull(date);
        Interval interval = this.getInterval();
        LocalDateTime newStartDateTime = this.getStartAsLocalDateTime().with(date);
        LocalDateTime endDateTime = this.getEndAsLocalDateTime();
        if (keepDuration) {
            endDateTime = newStartDateTime.plus(this.getDuration());
            this.setInterval(newStartDateTime, endDateTime, this.getZoneId());
        } else {
            if (newStartDateTime.isAfter(endDateTime)) {
                interval = interval.withEndDateTime(newStartDateTime.plus(interval.getDuration()));
            }
            this.setInterval(interval.withStartDate(date));
        }
    }

    public final void changeStartTime(LocalTime time) {
        this.changeStartTime(time, false);
    }

    public final void changeStartTime(LocalTime time, boolean keepDuration) {
        Objects.requireNonNull(time);
        Interval interval = this.getInterval();
        LocalDateTime newStartDateTime = this.getStartAsLocalDateTime().with(time);
        LocalDateTime endDateTime = this.getEndAsLocalDateTime();
        if (keepDuration) {
            endDateTime = newStartDateTime.plus(this.getDuration());
            this.setInterval(newStartDateTime, endDateTime);
        } else {
            if (newStartDateTime.isAfter(endDateTime.minus(this.getMinimumDuration()))) {
                interval = interval.withEndDateTime(newStartDateTime.plus(this.getMinimumDuration()));
            }
            this.setInterval(interval.withStartTime(time));
        }
    }

    public final void changeEndDate(LocalDate date) {
        this.changeEndDate(date, false);
    }

    public final void changeEndDate(LocalDate date, boolean keepDuration) {
        Objects.requireNonNull(date);
        Interval interval = this.getInterval();
        LocalDateTime newEndDateTime = this.getEndAsLocalDateTime().with(date);
        LocalDateTime startDateTime = this.getStartAsLocalDateTime();
        if (keepDuration) {
            startDateTime = newEndDateTime.minus(this.getDuration());
            this.setInterval(startDateTime, newEndDateTime, this.getZoneId());
        } else {
            if (newEndDateTime.isBefore(startDateTime)) {
                interval = interval.withStartDateTime(newEndDateTime.minus(interval.getDuration()));
            }
            this.setInterval(interval.withEndDate(date));
        }
    }

    public final void changeEndTime(LocalTime time) {
        this.changeEndTime(time, false);
    }

    public final void changeEndTime(LocalTime time, boolean keepDuration) {
        Objects.requireNonNull(time);
        Interval interval = this.getInterval();
        LocalDateTime newEndDateTime = this.getEndAsLocalDateTime().with(time);
        LocalDateTime startDateTime = this.getStartAsLocalDateTime();
        if (keepDuration) {
            startDateTime = newEndDateTime.minus(this.getDuration());
            this.setInterval(startDateTime, newEndDateTime, this.getZoneId());
        } else {
            if (newEndDateTime.isBefore(startDateTime.plus(this.getMinimumDuration()))) {
                interval = interval.withStartDateTime(newEndDateTime.minus(this.getMinimumDuration()));
            }
            this.setInterval(interval.withEndTime(time));
        }
    }

    public final ReadOnlyObjectProperty<Entry<T>> recurrenceSourceProperty() {
        if (this.recurrenceSource == null) {
            this.recurrenceSource = new ReadOnlyObjectWrapper<Entry<T>>(this, "recurrenceSource"){

                public void set(Entry<T> newEntry) {
                    super.set(newEntry);
                    if (newEntry != null) {
                        Entry.this.setRecurrence(true);
                    } else {
                        Entry.this.setRecurrence(false);
                    }
                }
            };
        }
        return this.recurrenceSource.getReadOnlyProperty();
    }

    public final Entry<T> getRecurrenceSourceEntry() {
        return this.recurrenceSource == null ? null : (Entry)this.recurrenceSource.get();
    }

    public Entry<T> createRecurrence() {
        return new Entry<T>();
    }

    public final ReadOnlyBooleanProperty recurrenceProperty() {
        if (this.recurrence == null) {
            this.recurrence = new ReadOnlyBooleanWrapper((Object)this, "recurrence", this._recurrence);
        }
        return this.recurrence.getReadOnlyProperty();
    }

    public final boolean isRecurrence() {
        return this.recurrence == null ? this._recurrence : this.recurrence.get();
    }

    private void setRecurrence(boolean b) {
        if (this.recurrence == null) {
            this._recurrence = b;
        } else {
            this.recurrence.set(b);
        }
    }

    public final boolean isRecurring() {
        return this.recurrenceRule != null && this.recurrenceRule.get() != null && !((String)this.recurrenceRule.get()).trim().equals("");
    }

    public final StringProperty recurrenceRuleProperty() {
        if (this.recurrenceRule == null) {
            this.recurrenceRule = new SimpleStringProperty(null, "recurrenceRule"){

                public void set(String newRecurrence) {
                    String oldRecurrence = this.get();
                    if (!Util.equals(oldRecurrence, newRecurrence)) {
                        Calendar calendar = Entry.this.getCalendar();
                        if (calendar != null && !Entry.this.isRecurrence()) {
                            calendar.impl_removeEntry(Entry.this);
                        }
                        super.set(newRecurrence);
                        this.updateRecurrenceEndProperty(newRecurrence);
                        if (calendar != null) {
                            if (!Entry.this.isRecurrence()) {
                                calendar.impl_addEntry(Entry.this);
                            }
                            calendar.fireEvent(new CalendarEvent(CalendarEvent.ENTRY_RECURRENCE_RULE_CHANGED, calendar, Entry.this, oldRecurrence));
                        }
                    }
                }

                private void updateRecurrenceEndProperty(String newRecurrence) {
                    block5: {
                        if (newRecurrence != null && !newRecurrence.trim().equals("")) {
                            try {
                                RRule rule = new RRule(newRecurrence);
                                DateValue until = rule.getUntil();
                                if (until != null) {
                                    Entry.this.setRecurrenceEnd(LocalDate.of(until.year(), until.month(), until.day()));
                                    break block5;
                                }
                                Entry.this.setRecurrenceEnd(LocalDate.MAX);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        } else {
                            Entry.this.setRecurrenceEnd(LocalDate.MAX);
                        }
                    }
                }
            };
        }
        return this.recurrenceRule;
    }

    public final void setRecurrenceRule(String rec) {
        if (this.recurrenceRule == null && rec == null) {
            return;
        }
        this.recurrenceRuleProperty().set((Object)rec);
    }

    public final String getRecurrenceRule() {
        return this.recurrenceRule == null ? null : (String)this.recurrenceRule.get();
    }

    public final ReadOnlyStringProperty recurrenceIdProperty() {
        if (this.recurrenceId == null) {
            this.recurrenceId = new ReadOnlyStringWrapper((Object)this, "recurrenceId", this._recurrenceId);
        }
        return this.recurrenceId.getReadOnlyProperty();
    }

    public final String getRecurrenceId() {
        return this.recurrenceId == null ? this._recurrenceId : this.recurrenceId.get();
    }

    private void setRecurrenceId(String id) {
        if (this.recurrenceId == null) {
            this._recurrenceId = id;
        } else {
            this.recurrenceId.set(id);
        }
    }

    public final ReadOnlyObjectProperty<LocalDate> recurrenceEndProperty() {
        if (this.recurrenceEnd == null) {
            this.recurrenceEnd = new ReadOnlyObjectWrapper((Object)this, "recurrenceEnd", (Object)this._recurrenceEnd);
        }
        return this.recurrenceEnd.getReadOnlyProperty();
    }

    public final LocalDate getRecurrenceEnd() {
        return this.recurrenceEnd == null ? this._recurrenceEnd : (LocalDate)this.recurrenceEnd.get();
    }

    private void setRecurrenceEnd(LocalDate date) {
        if (this.recurrenceEnd == null) {
            this._recurrenceEnd = date;
        } else {
            this.recurrenceEnd.set((Object)date);
        }
    }

    public final void setId(String id) {
        Objects.requireNonNull(id);
        if (LoggingDomain.MODEL.isLoggable(Level.FINE)) {
            LoggingDomain.MODEL.fine("setting id to " + id);
        }
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public final ObjectProperty<Calendar> calendarProperty() {
        return this.calendar;
    }

    public final void setCalendar(Calendar cal) {
        this.calendar.set((Object)cal);
    }

    public final Calendar getCalendar() {
        return (Calendar)this.calendar.get();
    }

    public final void removeFromCalendar() {
        this.setCalendar(null);
    }

    public final ObjectProperty<T> userObjectProperty() {
        if (this.userObject == null) {
            this.userObject = new SimpleObjectProperty<T>(this, "userObject"){

                public void set(T newObject) {
                    Object oldUserObject = this.get();
                    if (oldUserObject != newObject) {
                        super.set(newObject);
                        Calendar calendar = Entry.this.getCalendar();
                        if (calendar != null) {
                            calendar.fireEvent(new CalendarEvent(CalendarEvent.ENTRY_USER_OBJECT_CHANGED, calendar, Entry.this, oldUserObject));
                        }
                    }
                }
            };
        }
        return this.userObject;
    }

    public final void setUserObject(T object) {
        if (this.userObject == null && object == null) {
            return;
        }
        this.userObjectProperty().set(object);
    }

    public final T getUserObject() {
        return (T)(this.userObject == null ? null : this.userObject.get());
    }

    public final ReadOnlyObjectProperty<ZoneId> zoneIdProperty() {
        if (this.zoneId == null) {
            this.zoneId = new ReadOnlyObjectWrapper((Object)this, "zoneId", (Object)this.getInterval().getZoneId());
        }
        return this.zoneId.getReadOnlyProperty();
    }

    public final void setZoneId(ZoneId zoneId) {
        Objects.requireNonNull(zoneId);
        this.setInterval(this.getInterval().withZoneId(zoneId));
    }

    public final ZoneId getZoneId() {
        return this.getInterval().getZoneId();
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.titleProperty().set((Object)title);
    }

    public final String getTitle() {
        return (String)this.titleProperty().get();
    }

    public final StringProperty locationProperty() {
        if (this.location == null) {
            this.location = new SimpleStringProperty(null, "location"){

                public void set(String newLocation) {
                    String oldLocation = this.get();
                    if (!Util.equals(oldLocation, newLocation)) {
                        super.set(newLocation);
                        Calendar calendar = Entry.this.getCalendar();
                        if (calendar != null) {
                            calendar.fireEvent(new CalendarEvent(CalendarEvent.ENTRY_LOCATION_CHANGED, calendar, Entry.this, oldLocation));
                        }
                    }
                }
            };
        }
        return this.location;
    }

    public final void setLocation(String loc) {
        if (this.location == null && loc == null) {
            return;
        }
        this.locationProperty().set((Object)loc);
    }

    public final String getLocation() {
        return this.location == null ? null : (String)this.location.get();
    }

    public final ReadOnlyObjectProperty<LocalDate> startDateProperty() {
        if (this.startDate == null) {
            this.startDate = new ReadOnlyObjectWrapper((Object)this, "startDate", (Object)this.getInterval().getStartDate());
        }
        return this.startDate.getReadOnlyProperty();
    }

    public final LocalDate getStartDate() {
        return this.getInterval().getStartDate();
    }

    public final ReadOnlyObjectProperty<LocalTime> startTimeProperty() {
        if (this.startTime == null) {
            this.startTime = new ReadOnlyObjectWrapper((Object)this, "startTime", (Object)this.getInterval().getStartTime());
        }
        return this.startTime.getReadOnlyProperty();
    }

    public final LocalTime getStartTime() {
        return this.getInterval().getStartTime();
    }

    public final ReadOnlyObjectProperty<LocalDate> endDateProperty() {
        if (this.endDate == null) {
            this.endDate = new ReadOnlyObjectWrapper((Object)this, "endDate", (Object)this.getInterval().getEndDate());
        }
        return this.endDate.getReadOnlyProperty();
    }

    public final LocalDate getEndDate() {
        return this.getInterval().getEndDate();
    }

    public final ReadOnlyObjectProperty<LocalTime> endTimeProperty() {
        if (this.endTime == null) {
            this.endTime = new ReadOnlyObjectWrapper((Object)this, "endTime", (Object)this.getInterval().getEndTime());
        }
        return this.endTime.getReadOnlyProperty();
    }

    public final LocalTime getEndTime() {
        return this.getInterval().getEndTime();
    }

    public final BooleanProperty fullDayProperty() {
        return this.fullDay;
    }

    public final boolean isFullDay() {
        return this.fullDayProperty().get();
    }

    public final void setFullDay(boolean fullDay) {
        this.fullDayProperty().set(fullDay);
    }

    public final ObjectProperty<Duration> minimumDurationProperty() {
        if (this.minimumDuration == null) {
            this.minimumDuration = new SimpleObjectProperty((Object)this, "minimumDuration", (Object)this._minimumDuration);
        }
        return this.minimumDuration;
    }

    public final Duration getMinimumDuration() {
        return this.minimumDuration == null ? this._minimumDuration : (Duration)this.minimumDuration.get();
    }

    public final void setMinimumDuration(Duration duration) {
        Objects.requireNonNull(duration);
        if (this.minimumDuration != null) {
            this.minimumDuration.set((Object)duration);
        } else {
            this._minimumDuration = duration;
        }
    }

    public boolean matches(String searchTerm) {
        String title = this.getTitle();
        if (title != null) {
            return title.toLowerCase().contains(searchTerm.toLowerCase());
        }
        return false;
    }

    public final ZonedDateTime getStartAsZonedDateTime() {
        return this.getInterval().getStartZonedDateTime();
    }

    public final long getStartMillis() {
        return this.getInterval().getStartMillis();
    }

    public final LocalDateTime getStartAsLocalDateTime() {
        return this.getInterval().getStartDateTime();
    }

    public final ZonedDateTime getEndAsZonedDateTime() {
        return this.getInterval().getEndZonedDateTime();
    }

    public final long getEndMillis() {
        return this.getInterval().getEndMillis();
    }

    public final LocalDateTime getEndAsLocalDateTime() {
        return this.getInterval().getEndDateTime();
    }

    private void updateMultiDay() {
        this.setMultiDay(this.getEndDate().isAfter(this.getStartDate()));
    }

    public final ReadOnlyBooleanProperty multiDayProperty() {
        if (this.multiDay == null) {
            this.multiDay = new ReadOnlyBooleanWrapper((Object)this, "multiDay", this._multiDay);
        }
        return this.multiDay.getReadOnlyProperty();
    }

    public final boolean isMultiDay() {
        return this.multiDay == null ? this._multiDay : this.multiDay.get();
    }

    private void setMultiDay(boolean b) {
        if (this.multiDay == null) {
            this._multiDay = b;
        } else {
            this.multiDay.set(b);
        }
    }

    public final boolean intersects(Entry<?> entry) {
        return this.intersects(entry.getStartAsZonedDateTime(), entry.getEndAsZonedDateTime());
    }

    public final boolean intersects(ZonedDateTime startTime, ZonedDateTime endTime) {
        return Util.intersect(startTime, endTime, this.getStartAsZonedDateTime(), this.getEndAsZonedDateTime());
    }

    public final Duration getDuration() {
        return Duration.between(this.getStartAsZonedDateTime(), this.getEndAsZonedDateTime());
    }

    public final boolean isShowing(LocalDate startDate, LocalDate endDate, ZoneId zoneId) {
        return this.isShowing(this, startDate, endDate, zoneId);
    }

    private boolean isShowing(Entry<?> entry, LocalDate startDate, LocalDate endDate, ZoneId zoneId) {
        ZonedDateTime st = ZonedDateTime.of(startDate, LocalTime.MIN, zoneId);
        ZonedDateTime et = ZonedDateTime.of(endDate, LocalTime.MAX, zoneId);
        if (entry.isRecurring() || entry.isRecurrence()) {
            return this.isRecurrenceShowing(entry, st, et, zoneId);
        }
        Interval interval = entry.getInterval();
        return Util.intersect(interval.getStartZonedDateTime(), interval.getEndZonedDateTime(), st, et);
    }

    private boolean isRecurrenceShowing(Entry<?> entry, ZonedDateTime st, ZonedDateTime et, ZoneId zoneId) {
        String recurrenceRule = entry.getRecurrenceRule();
        LocalDate utilStartDate = entry.getStartAsZonedDateTime().toLocalDate();
        try {
            LocalDate repeatingDate;
            LocalDate utilEndDate = et.toLocalDate();
            LocalDateIterator iterator = LocalDateIteratorFactory.createLocalDateIterator((String)recurrenceRule, (LocalDate)utilStartDate, (ZoneId)zoneId, (boolean)true);
            while (iterator.hasNext() && !(repeatingDate = (LocalDate)iterator.next()).isAfter(utilEndDate)) {
                ZonedDateTime recurrenceEnd;
                ZonedDateTime recurrenceStart = ZonedDateTime.of(repeatingDate, LocalTime.MIN, zoneId);
                if (!Util.intersect(recurrenceStart, recurrenceEnd = recurrenceStart.plus(entry.getDuration()), st, et)) continue;
                return true;
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public final int compareTo(Entry<?> other) {
        LocalDateTime b;
        if (this.isFullDay() && other.isFullDay()) {
            return this.getStartDate().compareTo(other.getStartDate());
        }
        if (this.isFullDay()) {
            return -1;
        }
        if (other.isFullDay()) {
            return 1;
        }
        LocalDateTime a = LocalDateTime.of(this.getStartDate(), this.getStartTime());
        int result = a.compareTo(b = LocalDateTime.of(other.getStartDate(), other.getStartTime()));
        if (result == 0) {
            String titleA = this.getTitle() != null ? this.getTitle() : "";
            String titleB = other.getTitle() != null ? other.getTitle() : "";
            result = titleA.compareTo(titleB);
        }
        return result;
    }

    public String toString() {
        return "Entry [title=" + this.getTitle() + ", id=" + this.getId() + ", fullDay=" + this.isFullDay() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", zoneId=" + this.getZoneId() + ", recurring = " + this.isRecurring() + ", rrule = " + this.getRecurrenceRule() + ", recurrence = " + this.isRecurrence() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.getRecurrenceId() == null ? 0 : this.getRecurrenceId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entry other = (Entry)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        String recId = this.getRecurrenceId();
        String otherRecId = other.getRecurrenceId();
        return !(recId == null ? otherRecId != null : !recId.equals(otherRecId));
    }

    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList items = FXCollections.observableArrayList();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.calendarProperty());
            }

            public Class<?> getType() {
                return Calendar.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "Calendar";
            }

            public String getDescription() {
                return "Calendar";
            }

            public Object getValue() {
                return Entry.this.getCalendar();
            }

            public void setValue(Object value) {
                Entry.this.setCalendar((Calendar)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.startTimeProperty());
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "Start time";
            }

            public String getDescription() {
                return "Start time";
            }

            public Object getValue() {
                return Entry.this.getStartTime();
            }

            public void setValue(Object value) {
                Entry.this.changeStartTime((LocalTime)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.endTimeProperty());
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "End time";
            }

            public String getDescription() {
                return "End time";
            }

            public Object getValue() {
                return Entry.this.getStartTime();
            }

            public void setValue(Object value) {
                Entry.this.changeEndTime((LocalTime)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.startDateProperty());
            }

            public Class<?> getType() {
                return LocalDate.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "Start date";
            }

            public String getDescription() {
                return "Start date";
            }

            public Object getValue() {
                return Entry.this.getStartDate();
            }

            public void setValue(Object value) {
                Entry.this.changeStartDate((LocalDate)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.endDateProperty());
            }

            public Class<?> getType() {
                return LocalDate.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "End date";
            }

            public String getDescription() {
                return "End date";
            }

            public Object getValue() {
                return Entry.this.getEndDate();
            }

            public void setValue(Object value) {
                Entry.this.changeEndDate((LocalDate)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.zoneIdProperty());
            }

            public Class<?> getType() {
                return ZoneId.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "Zone ID";
            }

            public String getDescription() {
                return "Zone ID";
            }

            public Object getValue() {
                return Entry.this.getZoneId();
            }

            public void setValue(Object value) {
                Entry.this.setZoneId((ZoneId)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.titleProperty());
            }

            public Class<?> getType() {
                return String.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "Title";
            }

            public String getDescription() {
                return "Title";
            }

            public Object getValue() {
                return Entry.this.getTitle();
            }

            public void setValue(Object value) {
                Entry.this.setTitle((String)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.fullDayProperty());
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "Full Day";
            }

            public String getDescription() {
                return "Full Day";
            }

            public Object getValue() {
                return Entry.this.isFullDay();
            }

            public void setValue(Object value) {
                Entry.this.setFullDay((Boolean)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.locationProperty());
            }

            public Class<?> getType() {
                return String.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "Location";
            }

            public String getDescription() {
                return "Geographic location (free text)";
            }

            public Object getValue() {
                return Entry.this.getLocation();
            }

            public void setValue(Object value) {
                Entry.this.setLocation((String)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.recurrenceRuleProperty());
            }

            public Class<?> getType() {
                return String.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "Recurrence Rule";
            }

            public String getDescription() {
                return "RRULE";
            }

            public Object getValue() {
                return Entry.this.getRecurrenceRule();
            }

            public void setValue(Object value) {
                Entry.this.setRecurrenceRule((String)value);
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Entry.this.minimumDurationProperty());
            }

            public Class<?> getType() {
                return Duration.class;
            }

            public String getCategory() {
                return Entry.ENTRY_CATEGORY;
            }

            public String getName() {
                return "Minimum Duration";
            }

            public String getDescription() {
                return "Minimum Duration";
            }

            public Object getValue() {
                return Entry.this.getMinimumDuration();
            }

            public void setValue(Object value) {
                Entry.this.setMinimumDuration((Duration)value);
            }
        });
        return items;
    }
}

