/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.model;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import java.time.ZonedDateTime;
import java.util.Objects;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;

public class CalendarEvent
extends Event {
    private static final long serialVersionUID = 4279597664476680474L;
    public static final EventType<CalendarEvent> ANY = new EventType(Event.ANY, "ANY");
    public static final EventType<CalendarEvent> CALENDAR_CHANGED = new EventType(ANY, "CALENDAR_CHANGED");
    public static final EventType<CalendarEvent> ENTRY_CHANGED = new EventType(ANY, "ENTRY_CHANGED");
    public static final EventType<CalendarEvent> ENTRY_CALENDAR_CHANGED = new EventType(ENTRY_CHANGED, "ENTRY_CALENDAR_CHANGED");
    public static final EventType<CalendarEvent> ENTRY_FULL_DAY_CHANGED = new EventType(ENTRY_CHANGED, "ENTRY_FULL_DAY_CHANGED");
    public static final EventType<CalendarEvent> ENTRY_RECURRENCE_RULE_CHANGED = new EventType(ENTRY_CHANGED, "ENTRY_RECURRENCE_RULE_CHANGED");
    public static final EventType<CalendarEvent> ENTRY_TITLE_CHANGED = new EventType(ENTRY_CHANGED, "ENTRY_TITLE_CHANGED");
    public static final EventType<CalendarEvent> ENTRY_USER_OBJECT_CHANGED = new EventType(ENTRY_CHANGED, "ENTRY_USER_OBJECT_CHANGED");
    public static final EventType<CalendarEvent> ENTRY_LOCATION_CHANGED = new EventType(ENTRY_CHANGED, "ENTRY_LOCATION_CHANGED");
    public static final EventType<CalendarEvent> ENTRY_INTERVAL_CHANGED = new EventType(ENTRY_CHANGED, "ENTRY_INTERVAL_CHANGED");
    private Entry<?> entry;
    private Calendar calendar;
    private boolean oldFullDay;
    private String oldText;
    private Calendar oldCalendar;
    private Interval oldInterval;
    private Object oldUserObject;

    protected CalendarEvent(EventType<? extends CalendarEvent> eventType, Calendar calendar) {
        super((Object)calendar, (EventTarget)calendar, eventType);
        this.calendar = Objects.requireNonNull(calendar);
    }

    public CalendarEvent(EventType<? extends CalendarEvent> eventType, Calendar calendar, Entry<?> entry) {
        super((Object)calendar, (EventTarget)calendar, eventType);
        this.calendar = calendar;
        this.entry = Objects.requireNonNull(entry);
    }

    public CalendarEvent(EventType<CalendarEvent> eventType, Calendar calendar, Entry<?> entry, Calendar oldCalendar) {
        this(eventType, calendar, entry);
        this.oldCalendar = oldCalendar;
    }

    public CalendarEvent(EventType<CalendarEvent> eventType, Calendar calendar, Entry<?> entry, Object oldUserObject) {
        this(eventType, calendar, entry);
        this.oldUserObject = oldUserObject;
    }

    public CalendarEvent(EventType<CalendarEvent> eventType, Calendar calendar, Entry<?> entry, Interval oldInterval) {
        this(eventType, calendar, entry);
        this.oldInterval = Objects.requireNonNull(oldInterval);
    }

    public CalendarEvent(EventType<CalendarEvent> eventType, Calendar calendar, Entry<?> entry, String oldText) {
        this(eventType, calendar, entry);
        this.oldText = oldText;
    }

    public CalendarEvent(EventType<CalendarEvent> eventType, Calendar calendar, Entry<?> entry, boolean oldFullDay) {
        this(eventType, calendar, entry);
        this.oldFullDay = oldFullDay;
    }

    public Entry<?> getEntry() {
        return this.entry;
    }

    public final Calendar getCalendar() {
        return this.calendar;
    }

    public Object getOldUserObject() {
        return this.oldUserObject;
    }

    public Interval getOldInterval() {
        return this.oldInterval;
    }

    public final String getOldText() {
        return this.oldText;
    }

    public final boolean getOldFullDay() {
        return this.oldFullDay;
    }

    public final Calendar getOldCalendar() {
        return this.oldCalendar;
    }

    public final boolean isEntryAdded() {
        if (this.eventType == ENTRY_CALENDAR_CHANGED) {
            return this.getOldCalendar() == null && this.entry.getCalendar() != null;
        }
        return false;
    }

    public final boolean isEntryRemoved() {
        if (this.eventType == ENTRY_CALENDAR_CHANGED) {
            return this.getOldCalendar() != null && this.entry.getCalendar() == null;
        }
        return false;
    }

    public final boolean isDayChange() {
        if (!this.getEventType().equals(ENTRY_INTERVAL_CHANGED)) {
            return false;
        }
        Interval newInterval = this.entry.getInterval();
        Interval oldInterval = this.getOldInterval();
        ZonedDateTime newStart = newInterval.getStartZonedDateTime();
        ZonedDateTime oldStart = oldInterval.getStartZonedDateTime();
        if (!newStart.toLocalDate().equals(oldStart.toLocalDate())) {
            return true;
        }
        ZonedDateTime newEnd = newInterval.getEndZonedDateTime();
        ZonedDateTime oldEnd = oldInterval.getEndZonedDateTime();
        return !newEnd.toLocalDate().equals(oldEnd.toLocalDate());
    }

    public String toString() {
        return "CalendarEvent [" + (this.entry == null ? "" : "entry=" + this.entry + ", ") + "calendar=" + this.calendar + ", oldInterval=" + this.oldInterval + ", oldFullDay=" + this.oldFullDay + ", oldText=" + this.oldText + ", oldCalendar=" + this.oldCalendar + ", eventType=" + this.eventType + ", target=" + this.target + ", consumed=" + this.consumed + ", source=" + this.source + "]";
    }
}

