/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.model;

import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import com.calendarfx.model.IntervalTree;
import com.calendarfx.util.LoggingDomain;
import com.google.ical.compat.javatime.LocalDateIterator;
import com.google.ical.compat.javatime.LocalDateIteratorFactory;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;

public class Calendar
implements EventTarget {
    private IntervalTree<Entry<?>> intervalTree = new IntervalTree();
    private boolean batchUpdates;
    private boolean dirty;
    private final ObjectProperty<Duration> lookAheadDuration = new SimpleObjectProperty((Object)this, "lookAheadDuration", (Object)Duration.ofDays(730L));
    private final ObjectProperty<Duration> lookBackDuration = new SimpleObjectProperty((Object)this, "lookBackDuration", (Object)Duration.ofDays(730L));
    private final StringProperty name = new SimpleStringProperty((Object)this, "name", "Untitled");
    private final StringProperty shortName = new SimpleStringProperty((Object)this, "shortName", "Unt.");
    private final StringProperty style = new SimpleStringProperty((Object)this, "style", Style.STYLE1.name().toLowerCase());
    private final BooleanProperty readOnly = new SimpleBooleanProperty((Object)this, "readOnly", false);
    private ObservableList<EventHandler<CalendarEvent>> eventHandlers = FXCollections.observableArrayList();
    private boolean fireEvents = true;

    public Calendar() {
        this.addEventHandler((EventHandler<CalendarEvent>)((EventHandler)evt -> {
            Entry<?> entry = evt.getEntry();
            if (evt.getEventType().getSuperType().equals(CalendarEvent.ENTRY_CHANGED) && entry.isRecurrence()) {
                this.updateRecurrenceSourceEntry((CalendarEvent)evt, entry.getRecurrenceSourceEntry());
            }
        }));
    }

    public Calendar(String name) {
        this();
        this.setName(name);
        if (name != null) {
            this.setShortName(name.substring(0, 1));
        }
    }

    private void updateRecurrenceSourceEntry(CalendarEvent evt, Entry source) {
        Entry<?> recurrence = evt.getEntry();
        if (evt.getEventType().equals(CalendarEvent.ENTRY_INTERVAL_CHANGED)) {
            Interval oldInterval = evt.getOldInterval();
            Interval newInterval = this.calculateSourceBoundsFromRecurrenceBounds(source, recurrence, oldInterval);
            source.setInterval(newInterval);
        } else if (evt.getEventType().equals(CalendarEvent.ENTRY_LOCATION_CHANGED)) {
            source.setLocation(recurrence.getLocation());
        } else if (evt.getEventType().equals(CalendarEvent.ENTRY_RECURRENCE_RULE_CHANGED)) {
            source.setRecurrenceRule(recurrence.getRecurrenceRule());
        } else if (evt.getEventType().equals(CalendarEvent.ENTRY_TITLE_CHANGED)) {
            source.setTitle(recurrence.getTitle());
        } else if (evt.getEventType().equals(CalendarEvent.ENTRY_USER_OBJECT_CHANGED)) {
            source.setUserObject(recurrence.getUserObject());
        } else if (evt.getEventType().equals(CalendarEvent.ENTRY_CALENDAR_CHANGED)) {
            source.setCalendar(recurrence.getCalendar());
        } else if (evt.getEventType().equals(CalendarEvent.ENTRY_FULL_DAY_CHANGED)) {
            source.setFullDay(recurrence.isFullDay());
        }
    }

    private Interval calculateSourceBoundsFromRecurrenceBounds(Entry<?> source, Entry<?> recurrence, Interval oldInterval) {
        ZonedDateTime recurrenceStart = recurrence.getStartAsZonedDateTime();
        ZonedDateTime recurrenceEnd = recurrence.getEndAsZonedDateTime();
        Duration startDelta = Duration.between(oldInterval.getStartZonedDateTime(), recurrenceStart);
        Duration endDelta = Duration.between(oldInterval.getEndZonedDateTime(), recurrenceEnd);
        ZonedDateTime sourceStart = source.getStartAsZonedDateTime();
        ZonedDateTime sourceEnd = source.getEndAsZonedDateTime();
        sourceStart = sourceStart.plus(startDelta);
        sourceEnd = sourceEnd.plus(endDelta);
        return new Interval(sourceStart.toLocalDate(), sourceStart.toLocalTime(), sourceEnd.toLocalDate(), sourceEnd.toLocalTime(), source.getZoneId());
    }

    public final Instant getEarliestTimeUsed() {
        return this.intervalTree.getEarliestTimeUsed();
    }

    public final Instant getLatestTimeUsed() {
        return this.intervalTree.getLatestTimeUsed();
    }

    public final void startBatchUpdates() {
        this.batchUpdates = true;
        this.dirty = false;
    }

    public final void stopBatchUpdates() {
        this.batchUpdates = false;
        if (this.dirty) {
            this.dirty = false;
            this.fireEvent(new CalendarEvent(CalendarEvent.CALENDAR_CHANGED, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<LocalDate, List<Entry<?>>> findEntries(LocalDate startDate, LocalDate endDate, ZoneId zoneId) {
        Map<LocalDate, List<Entry<?>>> result;
        this.fireEvents = false;
        try {
            result = this.doGetEntries(startDate, endDate, zoneId);
        }
        finally {
            this.fireEvents = true;
        }
        return result;
    }

    private Map<LocalDate, List<Entry<?>>> doGetEntries(LocalDate startDate, LocalDate endDate, ZoneId zoneId) {
        if (LoggingDomain.MODEL.isLoggable(Level.FINE)) {
            LoggingDomain.MODEL.fine(this.getName() + ": getting entries from " + startDate + " until " + endDate + ", zone = " + zoneId);
        }
        ZonedDateTime st = ZonedDateTime.of(startDate, LocalTime.MIN, zoneId);
        ZonedDateTime et = ZonedDateTime.of(endDate, LocalTime.MAX, zoneId);
        Collection<Entry<?>> intersectingEntries = this.intervalTree.getIntersectingObjects(st.toInstant(), et.toInstant());
        if (intersectingEntries.isEmpty()) {
            if (LoggingDomain.MODEL.isLoggable(Level.FINE)) {
                LoggingDomain.MODEL.fine(this.getName() + ": found no entries");
            }
            return Collections.emptyMap();
        }
        if (LoggingDomain.MODEL.isLoggable(Level.FINE)) {
            LoggingDomain.MODEL.fine(this.getName() + ": found " + intersectingEntries.size() + " entries");
        }
        HashMap result = new HashMap();
        for (Entry<?> entry : intersectingEntries) {
            if (entry.isRecurring()) {
                String recurrenceRule = entry.getRecurrenceRule();
                if (recurrenceRule == null || recurrenceRule.trim().equals("")) continue;
                LocalDate utilStartDate = entry.getStartAsZonedDateTime().toLocalDate();
                try {
                    LocalDate repeatingDate;
                    LocalDate utilEndDate = et.toLocalDate();
                    LocalDateIterator iterator = LocalDateIteratorFactory.createLocalDateIterator((String)recurrenceRule, (LocalDate)utilStartDate, (ZoneId)zoneId, (boolean)true);
                    while (iterator.hasNext() && !(repeatingDate = (LocalDate)iterator.next()).isAfter(utilEndDate)) {
                        ZonedDateTime zonedDateTime = ZonedDateTime.of(repeatingDate, LocalTime.MIN, zoneId);
                        Entry<?> recurrence = entry.createRecurrence();
                        recurrence.setId(entry.getId());
                        recurrence.getProperties().put((Object)"com.calendarfx.recurrence.source", entry);
                        recurrence.getProperties().put((Object)"com.calendarfx.recurrence.id", (Object)zonedDateTime.toString());
                        recurrence.setRecurrenceRule(entry.getRecurrenceRule());
                        LocalDate recurrenceStartDate = zonedDateTime.toLocalDate();
                        LocalDate recurrenceEndDate = recurrenceStartDate.plus(entry.getStartDate().until(entry.getEndDate()));
                        Interval recurrenceInterval = entry.getInterval().withDates(recurrenceStartDate, recurrenceEndDate);
                        recurrence.setInterval(recurrenceInterval);
                        recurrence.setUserObject(entry.getUserObject());
                        recurrence.setTitle(entry.getTitle());
                        recurrence.setMinimumDuration(entry.getMinimumDuration());
                        recurrence.setFullDay(entry.isFullDay());
                        recurrence.setLocation(entry.getLocation());
                        recurrence.setCalendar(this);
                        this.addEntryToResult(result, recurrence, startDate, endDate);
                    }
                    continue;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            this.addEntryToResult(result, entry, startDate, endDate);
        }
        if (LoggingDomain.MODEL.isLoggable(Level.FINE)) {
            LoggingDomain.MODEL.fine(this.getName() + ": found entries for " + result.size() + " different days");
        }
        result.values().forEach(Collections::sort);
        return result;
    }

    private void addEntryToResult(Map<LocalDate, List<Entry<?>>> result, Entry<?> entry, LocalDate startDate, LocalDate endDate) {
        LocalDate entryStartDate = entry.getStartDate();
        LocalDate entryEndDate = entry.getEndDate();
        if (entryEndDate.isBefore(startDate) || entryStartDate.isAfter(endDate)) {
            return;
        }
        if (entryStartDate.isAfter(startDate)) {
            startDate = entryStartDate;
        }
        if (entryEndDate.isBefore(endDate)) {
            endDate = entryEndDate;
        }
        LocalDate date = startDate;
        do {
            result.computeIfAbsent(date, it -> new ArrayList()).add(entry);
        } while (!(date = date.plusDays(1L)).isAfter(endDate));
    }

    public final ObjectProperty<Duration> lookAheadDurationProperty() {
        return this.lookAheadDuration;
    }

    public final void setLookAheadDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.lookAheadDurationProperty().set((Object)duration);
    }

    public final Duration getLookAheadDuration() {
        return (Duration)this.lookAheadDurationProperty().get();
    }

    public final ObjectProperty<Duration> lookBackDurationProperty() {
        return this.lookBackDuration;
    }

    public final void setLookBackDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.lookBackDurationProperty().set((Object)duration);
    }

    public final Duration getLookBackDuration() {
        return (Duration)this.lookBackDurationProperty().get();
    }

    public List<Entry<?>> findEntries(String searchText) {
        if (LoggingDomain.MODEL.isLoggable(Level.FINE)) {
            LoggingDomain.MODEL.fine(this.getName() + ": getting entries for search term: " + searchText);
        }
        Instant horizonStart = Instant.now().minus(this.getLookBackDuration());
        Instant horizonEnd = Instant.now().plus(this.getLookAheadDuration());
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime st = ZonedDateTime.ofInstant(horizonStart, zoneId);
        ZonedDateTime et = ZonedDateTime.ofInstant(horizonEnd, zoneId);
        ArrayList result = new ArrayList();
        Map<LocalDate, List<Entry<?>>> map = this.findEntries(st.toLocalDate(), et.toLocalDate(), zoneId);
        for (List<Entry<?>> list : map.values()) {
            for (Entry<?> entry : list) {
                if (!entry.matches(searchText)) continue;
                result.add(entry);
            }
        }
        if (LoggingDomain.MODEL.isLoggable(Level.FINE)) {
            LoggingDomain.MODEL.fine(this.getName() + ": found " + result.size() + " entries");
        }
        return result;
    }

    public final void clear() {
        this.intervalTree.clear();
        this.fireEvent(new CalendarEvent(CalendarEvent.CALENDAR_CHANGED, this));
    }

    public final void addEntry(Entry<?> entry) {
        this.addEntries(entry);
    }

    public final void addEntries(Entry<?> ... entries) {
        if (entries != null) {
            for (Entry<?> entry : entries) {
                entry.setCalendar(this);
            }
        }
    }

    public final void addEntries(Collection<Entry<?>> entries) {
        if (entries != null) {
            entries.forEach(this::addEntry);
        }
    }

    public final void addEntries(Iterator<Entry<?>> entries) {
        if (entries != null) {
            while (entries.hasNext()) {
                this.addEntry(entries.next());
            }
        }
    }

    public final void addEntries(Iterable<Entry<?>> entries) {
        if (entries != null) {
            this.addEntries(entries.iterator());
        }
    }

    public final void removeEntry(Entry<?> entry) {
        this.removeEntries(entry);
    }

    public final void removeEntries(Entry<?> ... entries) {
        if (entries != null) {
            for (Entry<?> entry : entries) {
                entry.setCalendar(null);
            }
        }
    }

    public final void removeEntries(Collection<Entry<?>> entries) {
        if (entries != null) {
            entries.forEach(this::removeEntry);
        }
    }

    public final void removeEntries(Iterator<Entry<?>> entries) {
        if (entries != null) {
            while (entries.hasNext()) {
                this.removeEntry(entries.next());
            }
        }
    }

    public final void removeEntries(Iterable<Entry<?>> entries) {
        if (entries != null) {
            this.removeEntries(entries.iterator());
        }
    }

    final void impl_addEntry(Entry<?> entry) {
        if (entry.isRecurrence()) {
            throw new IllegalArgumentException("a recurrence entry can not be added to a calendar");
        }
        this.dirty = true;
        this.intervalTree.add(entry);
    }

    final void impl_removeEntry(Entry<?> entry) {
        if (entry.isRecurrence()) {
            throw new IllegalArgumentException("a recurrence entry can not be added to a calendar");
        }
        this.dirty = true;
        this.intervalTree.remove(entry);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final StringProperty shortNameProperty() {
        return this.shortName;
    }

    public final void setShortName(String name) {
        this.shortNameProperty().set((Object)name);
    }

    public final String getShortName() {
        return (String)this.shortNameProperty().get();
    }

    public final StringProperty styleProperty() {
        return this.style;
    }

    public final void setStyle(Style style) {
        LoggingDomain.MODEL.finer(this.getName() + ": setting style to: " + (Object)((Object)style));
        this.setStyle(style.name().toLowerCase());
    }

    public final void setStyle(String stylePrefix) {
        Objects.requireNonNull(stylePrefix);
        LoggingDomain.MODEL.finer(this.getName() + ": setting style to: " + this.style);
        this.styleProperty().set((Object)stylePrefix);
    }

    public final String getStyle() {
        return (String)this.styleProperty().get();
    }

    public final BooleanProperty readOnlyProperty() {
        return this.readOnly;
    }

    public final boolean isReadOnly() {
        return this.readOnlyProperty().get();
    }

    public final void setReadOnly(boolean readOnly) {
        LoggingDomain.MODEL.finer(this.getName() + ": setting read only to: " + readOnly);
        this.readOnlyProperty().set(readOnly);
    }

    public final void addEventHandler(EventHandler<CalendarEvent> l) {
        if (l != null) {
            if (LoggingDomain.MODEL.isLoggable(Level.FINER)) {
                LoggingDomain.MODEL.finer(this.getName() + ": adding event handler: " + l);
            }
            this.eventHandlers.add(l);
        }
    }

    public final void removeEventHandler(EventHandler<CalendarEvent> l) {
        if (l != null) {
            if (LoggingDomain.MODEL.isLoggable(Level.FINER)) {
                LoggingDomain.MODEL.finer(this.getName() + ": removing event handler: " + l);
            }
            this.eventHandlers.remove(l);
        }
    }

    public final void fireEvent(CalendarEvent evt) {
        if (this.fireEvents && !this.batchUpdates) {
            if (LoggingDomain.MODEL.isLoggable(Level.FINER)) {
                LoggingDomain.MODEL.finer(this.getName() + ": fireing event: " + (Object)((Object)evt));
            }
            Objects.requireNonNull(evt);
            Event.fireEvent((EventTarget)this, (Event)evt);
        }
    }

    public final EventDispatchChain buildEventDispatchChain(EventDispatchChain givenTail) {
        return givenTail.append((event, tail) -> {
            if (event instanceof CalendarEvent) {
                for (EventHandler handler : this.eventHandlers) {
                    handler.handle((Event)((CalendarEvent)event));
                }
            }
            return event;
        });
    }

    public String toString() {
        return "Calendar [name=" + this.getName() + ", style=" + this.getStyle() + ", readOnly=" + this.isReadOnly() + "]";
    }

    public static enum Style {
        STYLE1,
        STYLE2,
        STYLE3,
        STYLE4,
        STYLE5,
        STYLE6,
        STYLE7;


        public static Style getStyle(int ordinal) {
            return Style.values()[ordinal % Style.values().length];
        }
    }
}

