/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.engine.model;

import com.frameworkset.orm.engine.EngineException;
import com.frameworkset.orm.engine.model.ConstraintNameGenerator;
import com.frameworkset.orm.engine.model.JavaNameGenerator;
import com.frameworkset.orm.engine.model.NameGenerator;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;

public class NameFactory
implements Serializable {
    public static final String JAVA_GENERATOR = JavaNameGenerator.class.getName();
    public static final String CONSTRAINT_GENERATOR = ConstraintNameGenerator.class.getName();
    private static NameFactory instance = new NameFactory();
    private Hashtable algorithms = new Hashtable(5);

    protected NameFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NameGenerator getAlgorithm(String name) throws EngineException {
        Hashtable hashtable = this.algorithms;
        synchronized (hashtable) {
            NameGenerator algorithm = (NameGenerator)this.algorithms.get(name);
            if (algorithm == null) {
                try {
                    algorithm = (NameGenerator)Class.forName(name).newInstance();
                }
                catch (InstantiationException e) {
                    throw new EngineException("Unable to instantiate class " + name + ": Make sure it's in your run-time classpath", e);
                }
                catch (Exception e) {
                    throw new EngineException(e);
                }
                this.algorithms.put(name, algorithm);
            }
            return algorithm;
        }
    }

    public static String generateName(String algorithmName, List inputs, boolean IGNORE_FIRST_TOKEN) throws EngineException {
        NameGenerator algorithm = instance.getAlgorithm(algorithmName);
        return algorithm.generateName(inputs, IGNORE_FIRST_TOKEN);
    }
}

