/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.update;

import com.baomidou.mybatisplus.core.conditions.AbstractLambdaWrapper;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.conditions.update.Update;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class LambdaUpdateWrapper<T>
extends AbstractLambdaWrapper<T, LambdaUpdateWrapper<T>>
implements Update<LambdaUpdateWrapper<T>, SFunction<T, ?>> {
    private final List<String> sqlSet;

    public LambdaUpdateWrapper() {
        this(null);
    }

    public LambdaUpdateWrapper(T entity) {
        super.setEntity(entity);
        super.initNeed();
        this.sqlSet = new ArrayList<String>();
    }

    public LambdaUpdateWrapper(Class<T> entityClass) {
        super.setEntityClass(entityClass);
        super.initNeed();
        this.sqlSet = new ArrayList<String>();
    }

    LambdaUpdateWrapper(T entity, Class<T> entityClass, List<String> sqlSet, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString paramAlias, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.sqlSet = sqlSet;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.paramAlias = paramAlias;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
    }

    @Override
    public LambdaUpdateWrapper<T> set(boolean condition, SFunction<T, ?> column, Object val, String mapping) {
        return (LambdaUpdateWrapper)this.maybeDo(condition, () -> {
            String sql = this.formatParam(mapping, val);
            this.sqlSet.add(this.columnToString(column) + "=" + sql);
        });
    }

    @Override
    public LambdaUpdateWrapper<T> setSql(boolean condition, String setSql, Object ... params) {
        if (condition && StringUtils.isNotBlank(setSql)) {
            this.sqlSet.add(this.formatSqlMaybeWithParam(setSql, params));
        }
        return (LambdaUpdateWrapper)this.typedThis;
    }

    public LambdaUpdateWrapper<T> setIncrBy(SFunction<T, ?> column, Number val) {
        return this.setIncrBy(true, column, val);
    }

    public LambdaUpdateWrapper<T> setIncrBy(boolean condition, SFunction<T, ?> column, Number val) {
        return (LambdaUpdateWrapper)this.maybeDo(condition, () -> {
            String realColumn = this.columnToString(column);
            this.sqlSet.add(realColumn + "=" + realColumn + "+" + (val instanceof BigDecimal ? ((BigDecimal)val).toPlainString() : val));
        });
    }

    public LambdaUpdateWrapper<T> setDecrBy(SFunction<T, ?> column, Number val) {
        return this.setDecrBy(true, column, val);
    }

    public LambdaUpdateWrapper<T> setDecrBy(boolean condition, SFunction<T, ?> column, Number val) {
        return (LambdaUpdateWrapper)this.maybeDo(condition, () -> {
            String realColumn = this.columnToString(column);
            this.sqlSet.add(realColumn + "=" + realColumn + "-" + (val instanceof BigDecimal ? ((BigDecimal)val).toPlainString() : val));
        });
    }

    @Override
    public String getSqlSet() {
        if (CollectionUtils.isEmpty(this.sqlSet)) {
            return null;
        }
        return String.join((CharSequence)",", this.sqlSet);
    }

    @Override
    protected LambdaUpdateWrapper<T> instance() {
        return new LambdaUpdateWrapper(this.getEntity(), this.getEntityClass(), null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), this.paramAlias, SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString());
    }

    @Override
    public void clear() {
        super.clear();
        this.sqlSet.clear();
    }
}

