/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.web.interceptor;

import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.annotation.LoginIgnore;
import com.baomidou.kisso.common.util.HttpUtil;
import com.baomidou.kisso.web.handler.KissoDefaultHandler;
import com.baomidou.kisso.web.handler.SSOHandlerInterceptor;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class SSOSpringInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SSOSpringInterceptor.class);
    private SSOHandlerInterceptor handlerInterceptor;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            LoginIgnore loginIgnore = method.getAnnotation(LoginIgnore.class);
            if (null != loginIgnore) {
                return true;
            }
            Object ssoToken = SSOHelper.getSSOToken(request);
            if (ssoToken == null) {
                if (HttpUtil.isAjax(request)) {
                    this.getHandlerInterceptor().preTokenIsNullAjax(request, response);
                    return false;
                }
                if (this.getHandlerInterceptor().preTokenIsNull(request, response)) {
                    log.debug("logout. request url:" + request.getRequestURL());
                    SSOHelper.clearRedirectLogin(request, response);
                }
                return false;
            }
            request.setAttribute("kissoTokenAttr", ssoToken);
        }
        return true;
    }

    public SSOHandlerInterceptor getHandlerInterceptor() {
        if (this.handlerInterceptor == null) {
            return KissoDefaultHandler.getInstance();
        }
        return this.handlerInterceptor;
    }

    public void setHandlerInterceptor(SSOHandlerInterceptor handlerInterceptor) {
        this.handlerInterceptor = handlerInterceptor;
    }
}

