/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.web.interceptor;

import com.baomidou.kisso.SSOAuthorization;
import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.annotation.Permission;
import com.baomidou.kisso.common.util.HttpUtil;
import com.baomidou.kisso.security.token.SSOToken;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class SSOPermissionInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SSOPermissionInterceptor.class);
    private SSOAuthorization authorization;
    private String illegalUrl;
    private boolean nothingAnnotationPass = false;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            Object token = SSOHelper.attrToken(request);
            if (null == token) {
                return true;
            }
            if (this.isVerification(request, handler, (SSOToken)token)) {
                return true;
            }
            return this.unauthorizedAccess(request, response);
        }
        return true;
    }

    protected boolean isVerification(HttpServletRequest request, Object handler, SSOToken token) {
        String uri;
        if (SSOConfig.getInstance().isPermissionUri() && ((uri = request.getRequestURI()) == null || this.getAuthorization().isPermitted(token, uri))) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Permission pm = method.getAnnotation(Permission.class);
        if (pm != null) {
            if (pm.ignore()) {
                return true;
            }
            if (!"".equals(pm.value()) && this.getAuthorization().isPermitted(token, pm.value())) {
                return true;
            }
        } else if (this.isNothingAnnotationPass()) {
            return true;
        }
        return false;
    }

    protected boolean unauthorizedAccess(HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug(" request 403 url: " + request.getRequestURI());
        if (HttpUtil.isAjax(request)) {
            HttpUtil.ajaxStatus(response, 403, "ajax Unauthorized access.");
        } else if (this.getIllegalUrl() == null || "".equals(this.getIllegalUrl())) {
            response.sendError(403, "Forbidden");
        } else {
            response.sendRedirect(this.getIllegalUrl());
        }
        return false;
    }

    public SSOAuthorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(SSOAuthorization authorization) {
        this.authorization = authorization;
    }

    public String getIllegalUrl() {
        return this.illegalUrl;
    }

    public void setIllegalUrl(String illegalUrl) {
        this.illegalUrl = illegalUrl;
    }

    public boolean isNothingAnnotationPass() {
        return this.nothingAnnotationPass;
    }

    public void setNothingAnnotationPass(boolean nothingAnnotationPass) {
        this.nothingAnnotationPass = nothingAnnotationPass;
    }
}

