/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.web.auth;

import com.baomidou.kisso.common.util.Base64Util;
import com.baomidou.kisso.common.util.StringUtils;
import com.baomidou.kisso.web.BaseFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticateFilter
implements BaseFilter {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthenticateFilter.class);
    private String username;
    private String password;

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration enumeration = filterConfig.getInitParameterNames();
        if (enumeration.hasMoreElements()) {
            this.initParameter(filterConfig, "basicAuthenticateUsername", username -> {
                this.username = username;
            });
            this.initParameter(filterConfig, "basicAuthenticatePassword", password -> {
                this.password = password;
            });
        }
        log.info("BasicAuthenticateFilter init success");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String auth;
        String[] arr;
        String authorization;
        boolean certified = false;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession httpSession = request.getSession();
        Object bas = httpSession.getAttribute("basicAuthenticateSession");
        if (null != bas) {
            certified = Objects.equals(bas, this.username);
        }
        if (!certified && StringUtils.isNotEmpty(authorization = request.getHeader("Authorization")) && 2 == (arr = (auth = new String(Base64Util.decode(authorization.substring(6)))).split(":")).length && Objects.equals(arr[0], this.username) && Objects.equals(arr[1], this.password)) {
            httpSession.setAttribute("basicAuthenticateSession", (Object)this.username);
            certified = true;
        }
        if (certified) {
            filterChain.doFilter((ServletRequest)request, servletResponse);
            return;
        }
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "Basic realm=\"no auth\"");
        response.getWriter().write("No permission to access the current resource");
    }

    public void destroy() {
        log.warn("BasicAuthenticateFilter destroy");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BasicAuthenticateFilter() {
    }

    public BasicAuthenticateFilter(String username, String password) {
        this.username = username;
        this.password = password;
    }
}

