/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.service;

import com.baomidou.kisso.SSOCache;
import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.SSOPlugin;
import com.baomidou.kisso.common.CookieHelper;
import com.baomidou.kisso.common.util.HttpUtil;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.enums.TokenFlag;
import com.baomidou.kisso.security.token.SSOToken;
import com.baomidou.kisso.service.IKissoService;
import com.baomidou.kisso.service.KissoServiceSupport;
import com.baomidou.kisso.service.SSOCookie;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKissoService
extends KissoServiceSupport
implements IKissoService {
    private static final Logger log = LoggerFactory.getLogger(AbstractKissoService.class);

    @Override
    public SSOToken getSSOToken(HttpServletRequest request) {
        SSOToken tk = this.checkIpBrowser(request, this.cacheSSOToken(request, this.config.getCache()));
        List<SSOPlugin> pluginList = this.config.getPluginList();
        if (pluginList != null) {
            for (SSOPlugin plugin : pluginList) {
                boolean valid = plugin.validateToken(tk);
                if (valid) continue;
                return null;
            }
        }
        return tk;
    }

    @Override
    public boolean kickLogin(Object userId) {
        SSOCache cache = this.config.getCache();
        if (cache != null) {
            return cache.delete(SSOConfig.toCacheKey(userId));
        }
        log.info(" kickLogin! please implements SSOCache class.");
        return false;
    }

    @Override
    public void setCookie(HttpServletRequest request, HttpServletResponse response, SSOToken ssoToken) {
        List<SSOPlugin> pluginList;
        boolean rlt;
        SSOCookie ssoCookie = this.generateCookie(request, ssoToken);
        SSOCache cache = this.config.getCache();
        if (cache != null && !(rlt = cache.set(ssoToken.toCacheKey(), ssoToken, this.config.getCacheExpires()))) {
            ssoToken.setFlag(TokenFlag.CACHE_SHUT);
        }
        if ((pluginList = this.config.getPluginList()) != null) {
            for (SSOPlugin plugin : pluginList) {
                boolean login = plugin.login(request, response);
                if (login) continue;
                plugin.login(request, response);
            }
        }
        CookieHelper.addSSOCookie(response, ssoCookie);
    }

    public void authCookie(HttpServletRequest request, HttpServletResponse response, SSOToken SSOToken2) {
        CookieHelper.authJSESSIONID(request, RandomUtil.getCharacterAndNumber(8));
        this.setCookie(request, response, SSOToken2);
    }

    @Override
    public boolean clearLogin(HttpServletRequest request, HttpServletResponse response) {
        return this.logout(request, response, this.config.getCache());
    }

    @Override
    public void clearRedirectLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.clearLogin(request, response);
        String loginUrl = this.config.getLoginUrl();
        if ("".equals(loginUrl)) {
            response.getWriter().write("{code:\"logout\", msg:\"Please login\"}");
        } else {
            String retUrl = HttpUtil.getQueryString(request, this.config.getEncoding());
            log.debug("loginAgain redirect pageUrl.." + retUrl);
            response.sendRedirect(HttpUtil.encodeRetURL(loginUrl, this.config.getParamReturnUrl(), retUrl));
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logout(request, response, this.config.getCache());
        String logoutUrl = this.config.getLogoutUrl();
        if ("".equals(logoutUrl)) {
            response.getWriter().write("sso.properties Must include: sso.logout.url");
        } else {
            response.sendRedirect(logoutUrl);
        }
    }
}

