/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.security.token;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.Browser;
import com.baomidou.kisso.common.IpHelper;
import com.baomidou.kisso.common.util.StringUtils;
import com.baomidou.kisso.enums.TokenFlag;
import com.baomidou.kisso.enums.TokenOrigin;
import com.baomidou.kisso.security.JwtHelper;
import com.baomidou.kisso.security.token.AccessToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOToken
extends AccessToken {
    private static final Logger log = LoggerFactory.getLogger(SSOToken.class);
    private TokenFlag flag = TokenFlag.NORMAL;
    private TokenOrigin origin = TokenOrigin.COOKIE;
    private String id;
    private String tenantId;
    private String issuer;
    private String ip;
    private long time = System.currentTimeMillis();
    private String userAgent;
    private Object data;
    private JwtBuilder jwtBuilder;
    private Claims claims;

    public SSOToken() {
    }

    public SSOToken(JwtBuilder jwtBuilder) {
        this.jwtBuilder = jwtBuilder;
    }

    public static SSOToken create() {
        return new SSOToken();
    }

    public static SSOToken create(JwtBuilder jwtBuilder) {
        return SSOToken.create().setJwtBuilder(jwtBuilder);
    }

    @Override
    public String getToken() {
        if (null == this.jwtBuilder) {
            this.jwtBuilder = Jwts.builder();
        }
        if (null != this.getId()) {
            this.jwtBuilder.setId(this.getId());
        }
        if (null != this.getTenantId()) {
            this.jwtBuilder.claim("tid", (Object)this.getTenantId());
        }
        if (null != this.getIp()) {
            this.jwtBuilder.claim("ip", (Object)this.getIp());
        }
        if (null != this.getIssuer()) {
            this.jwtBuilder.setIssuer(this.getIssuer());
        }
        if (null != this.getUserAgent()) {
            this.jwtBuilder.claim("ua", (Object)this.getUserAgent());
        }
        if (null != this.getClaims()) {
            this.jwtBuilder.setClaims(this.getClaims());
        }
        if (TokenFlag.NORMAL != this.getFlag()) {
            this.jwtBuilder.claim("fg", (Object)this.getFlag().value());
        }
        if (null != this.getOrigin()) {
            this.jwtBuilder.claim("og", (Object)this.getOrigin().value());
        }
        this.jwtBuilder.setIssuedAt(new Date(this.time));
        return JwtHelper.signCompact(this.jwtBuilder);
    }

    public TokenFlag getFlag() {
        return this.flag;
    }

    public SSOToken setFlag(TokenFlag flag) {
        this.flag = flag;
        return this;
    }

    public TokenOrigin getOrigin() {
        return this.origin;
    }

    public SSOToken setOrigin(TokenOrigin origin) {
        this.origin = origin;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SSOToken setId(Object id) {
        this.id = String.valueOf(id);
        return this;
    }

    public SSOToken setId(String id) {
        this.id = id;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public SSOToken setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public SSOToken setTenantId(Object tenantId) {
        this.tenantId = String.valueOf(tenantId);
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public SSOToken setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public SSOToken setIp(HttpServletRequest request) {
        this.ip = IpHelper.getIpAddr(request);
        return this;
    }

    public SSOToken setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public SSOToken setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public SSOToken setUserAgent(HttpServletRequest request) {
        this.userAgent = Browser.getUserAgent(request);
        return this;
    }

    public long getTime() {
        return this.time;
    }

    public SSOToken setTime(long time) {
        this.time = time;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public SSOToken setData(Object data) {
        this.data = data;
        return this;
    }

    public JwtBuilder getJwtBuilder() {
        return this.jwtBuilder;
    }

    public SSOToken setJwtBuilder(JwtBuilder jwtBuilder) {
        this.jwtBuilder = jwtBuilder;
        return this;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public SSOToken setClaims(Claims claims) {
        this.claims = claims;
        return this;
    }

    public String toCacheKey() {
        return SSOConfig.toCacheKey(this.getId());
    }

    public static SSOToken parser(String jwtToken) {
        return SSOToken.parser(jwtToken, false);
    }

    public static SSOToken parser(String jwtToken, boolean header) {
        String tenantId;
        String flag;
        String userAgent;
        Claims claims = (Claims)JwtHelper.verifyParser().parseClaimsJws(jwtToken).getBody();
        if (null == claims) {
            return null;
        }
        String origin = (String)claims.get("og", String.class);
        if (header && StringUtils.isEmpty(origin)) {
            log.warn("illegal token request orgin.");
            return null;
        }
        SSOToken ssoToken = new SSOToken();
        ssoToken.setId(claims.getId());
        ssoToken.setIssuer(claims.getIssuer());
        String ip = (String)claims.get("ip", String.class);
        if (StringUtils.isNotEmpty(ip)) {
            ssoToken.setIp(ip);
        }
        if (StringUtils.isNotEmpty(userAgent = (String)claims.get("ua", String.class))) {
            ssoToken.setUserAgent(userAgent);
        }
        if (StringUtils.isNotEmpty(flag = (String)claims.get("fg", String.class))) {
            ssoToken.setFlag(TokenFlag.fromValue(flag));
        }
        if (StringUtils.isNotEmpty(tenantId = (String)claims.get("tid", String.class))) {
            ssoToken.setTenantId(tenantId);
        }
        if (StringUtils.isNotEmpty(origin)) {
            ssoToken.setOrigin(TokenOrigin.fromValue(origin));
        }
        ssoToken.setTime(claims.getIssuedAt().getTime());
        ssoToken.setClaims(claims);
        return ssoToken;
    }
}

