/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.signature;

import com.baomidou.kisso.common.signature.IVerify;
import com.baomidou.kisso.common.signature.ShaAlgorithm;
import com.baomidou.kisso.common.util.Base64Util;
import com.baomidou.kisso.exception.UnsupportedAlgorithmException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Objects;
import javax.crypto.Mac;

public class VerifySymmetric
implements IVerify {
    private final Key key;

    public VerifySymmetric(Key key) {
        this.key = key;
    }

    @Override
    public boolean verify(Provider provider, ShaAlgorithm shaAlgorithm, byte[] signingStringBytes, String verifyString) {
        try {
            Mac mac = provider == null ? Mac.getInstance(shaAlgorithm.getJmvName()) : Mac.getInstance(shaAlgorithm.getJmvName(), provider);
            mac.init(this.key);
            byte[] hash = mac.doFinal(signingStringBytes);
            return Objects.equals(Base64Util.encode(hash), verifyString);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedAlgorithmException(shaAlgorithm.getJmvName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

