/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.signature;

import com.baomidou.kisso.common.signature.IVerify;
import com.baomidou.kisso.common.signature.ShaAlgorithm;
import com.baomidou.kisso.common.util.Base64Util;
import com.baomidou.kisso.exception.UnsupportedAlgorithmException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;

public class VerifyAsymmetric
implements IVerify {
    private final PublicKey key;

    public VerifyAsymmetric(PublicKey key) {
        this.key = key;
    }

    @Override
    public boolean verify(Provider provider, ShaAlgorithm shaAlgorithm, byte[] signingStringBytes, String verifyString) {
        try {
            Signature instance = provider == null ? Signature.getInstance(shaAlgorithm.getJmvName()) : Signature.getInstance(shaAlgorithm.getJmvName(), provider);
            instance.initVerify(this.key);
            instance.update(signingStringBytes);
            return instance.verify(Base64Util.decode(verifyString));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedAlgorithmException(shaAlgorithm.getJmvName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

