/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.signature;

import com.baomidou.kisso.common.signature.ISign;
import com.baomidou.kisso.common.signature.ShaAlgorithm;
import com.baomidou.kisso.exception.UnsupportedAlgorithmException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;

public class SignAsymmetric
implements ISign {
    private final PrivateKey key;

    public SignAsymmetric(PrivateKey key) {
        this.key = key;
    }

    @Override
    public byte[] sign(Provider provider, ShaAlgorithm shaAlgorithm, byte[] signingStringBytes) {
        try {
            Signature instance = provider == null ? Signature.getInstance(shaAlgorithm.getJmvName()) : Signature.getInstance(shaAlgorithm.getJmvName(), provider);
            instance.initSign(this.key);
            instance.update(signingStringBytes);
            return instance.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedAlgorithmException(shaAlgorithm.getJmvName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

