/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common;

public class OperatingSystem {
    private static final OS OS = OperatingSystem.get(System.getProperty("os.name", "").toLowerCase());

    public static OS get() {
        return OS;
    }

    private static OS get(String osName) {
        if (OperatingSystem.isWindows(osName)) {
            return com.baomidou.kisso.common.OperatingSystem$OS.WINDOWS;
        }
        if (OperatingSystem.isMac(osName)) {
            return com.baomidou.kisso.common.OperatingSystem$OS.MAC;
        }
        if (OperatingSystem.isUnix(osName)) {
            return com.baomidou.kisso.common.OperatingSystem$OS.UNIX;
        }
        return null;
    }

    public static boolean isWindows(String osName) {
        return osName.contains("win");
    }

    public static boolean isMac(String osName) {
        return osName.contains("mac");
    }

    public static boolean isUnix(String osName) {
        return osName.contains("nix") || osName.contains("nux") || osName.contains("aix");
    }

    public static enum OS {
        WINDOWS,
        MAC,
        UNIX;

    }
}

