/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common;

import com.baomidou.kisso.common.util.StringUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpHelper {
    private static final Logger log = LoggerFactory.getLogger(IpHelper.class);
    public static String LOCAL_IP;
    public static String HOST_NAME;
    private static final String[] HEADERS;

    private static boolean isNotUnknown(String checkIp) {
        return StringUtils.isNotEmpty(checkIp) && !"unknown".equalsIgnoreCase(checkIp);
    }

    private static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (!IpHelper.isNotUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = null;
        for (String header : HEADERS) {
            String currentIp = request.getHeader(header);
            if (!IpHelper.isNotUnknown(currentIp)) continue;
            ip = currentIp;
            break;
        }
        if (null == ip) {
            ip = request.getRemoteAddr();
        }
        if (null == ip) {
            return "";
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            return "127.0.0.1";
        }
        return IpHelper.getMultistageReverseProxyIp(ip);
    }

    public static boolean isLocalIp(String ip) {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    String address;
                    InetAddress ia = e2.nextElement();
                    if (ia instanceof Inet6Address || null == (address = ia.getHostAddress()) || !address.contains(ip)) continue;
                    return true;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        HEADERS = new String[]{"x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR", "X-Real-IP"};
        String ip = "";
        try {
            InetAddress inetAddr = InetAddress.getLocalHost();
            HOST_NAME = inetAddr.getHostName();
            byte[] addr = inetAddr.getAddress();
            for (int i = 0; i < addr.length; ++i) {
                if (i > 0) {
                    ip = ip + ".";
                }
                ip = ip + (addr[i] & 0xFF);
            }
        }
        catch (UnknownHostException e) {
            ip = "unknown";
            log.error(e.getMessage());
        }
        finally {
            LOCAL_IP = ip;
        }
    }
}

