/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common;

import com.baomidou.kisso.common.util.StringUtils;
import com.baomidou.kisso.service.SSOCookie;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieHelper {
    private static final Logger log = LoggerFactory.getLogger(CookieHelper.class);
    public static final int CLEAR_BROWSER_IS_CLOSED = -1;
    public static final int CLEAR_IMMEDIATELY_REMOVE = 0;

    public static void authJSESSIONID(HttpServletRequest request, String value) {
        request.getSession().invalidate();
        request.getSession().setAttribute("KISSO-" + value, (Object)true);
    }

    public static Cookie findCookieByName(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(cookieName)) continue;
            return cookies[i];
        }
        return null;
    }

    public static void clearCookieByName(HttpServletResponse response, String cookieName) {
        Cookie cookie = new Cookie(cookieName, "");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static void clearAllCookie(HttpServletRequest request, HttpServletResponse response, String domain, String path) {
        Cookie[] cookies = request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            CookieHelper.clearCookie(response, cookies[i].getName(), domain, path);
        }
        log.info("clearAllCookie in  domain " + domain);
    }

    public static boolean clearCookieByName(HttpServletRequest request, HttpServletResponse response, String cookieName, String domain, String path) {
        boolean result = false;
        Cookie ck = CookieHelper.findCookieByName(request, cookieName);
        if (ck != null) {
            result = CookieHelper.clearCookie(response, cookieName, domain, path);
        }
        return result;
    }

    private static boolean clearCookie(HttpServletResponse response, String cookieName, String domain, String path) {
        boolean result = false;
        try {
            Cookie cookie = new Cookie(cookieName, "");
            cookie.setMaxAge(0);
            if (StringUtils.isNotEmpty(domain)) {
                cookie.setDomain(domain);
            }
            cookie.setPath(path);
            response.addCookie(cookie);
            log.debug("clear cookie " + cookieName);
            result = true;
        }
        catch (Exception e) {
            log.error("clear cookie " + cookieName + " is exception!\n" + e.toString());
        }
        return result;
    }

    public static void addCookie(HttpServletResponse response, String domain, String path, String name, String value, int maxAge, boolean httpOnly, boolean secure) {
        SSOCookie ssoCookie = new SSOCookie(name, value);
        if (StringUtils.isNotEmpty(domain)) {
            ssoCookie.setDomain(domain);
        }
        ssoCookie.setPath(path);
        ssoCookie.setMaxAge(maxAge);
        if (httpOnly) {
            ssoCookie.setHttpOnly(true);
        }
        if (secure) {
            ssoCookie.setSecure(secure);
        }
        CookieHelper.addSSOCookie(response, ssoCookie);
    }

    public static void addSSOCookie(HttpServletResponse response, SSOCookie ssoCookie) {
        String sameSite;
        String path;
        String domain;
        if (null == ssoCookie) {
            return;
        }
        String cookieName = ssoCookie.getName();
        String cookieValue = ssoCookie.getValue();
        StringBuffer sf = new StringBuffer();
        sf.append(cookieName).append("=").append(cookieValue).append(";");
        int maxAge = ssoCookie.getMaxAge();
        if (maxAge >= 0) {
            sf.append("Max-Age=").append(maxAge).append(";");
        }
        if (null != (domain = ssoCookie.getDomain())) {
            sf.append("domain=").append(domain).append(";");
        }
        if (null != (path = ssoCookie.getPath())) {
            sf.append("path=").append(path).append(";");
        }
        if (ssoCookie.getSecure()) {
            sf.append("secure;");
        }
        if (ssoCookie.isHttpOnly()) {
            sf.append("HTTPOnly;");
        }
        if (null != (sameSite = ssoCookie.getSameSite())) {
            sf.append("SameSite=").append(sameSite).append(";");
        }
        response.addHeader("Set-Cookie", sf.toString());
    }
}

