/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.CommandCode;
import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventHandler;
import com.alipay.remoting.ConnectionEventListener;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.DefaultConnectionManager;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.ProtocolCode;
import com.alipay.remoting.ProtocolManager;
import com.alipay.remoting.RandomSelectStrategy;
import com.alipay.remoting.RemotingAddressParser;
import com.alipay.remoting.RemotingProcessor;
import com.alipay.remoting.RemotingServer;
import com.alipay.remoting.ServerIdleHandler;
import com.alipay.remoting.SystemProperties;
import com.alipay.remoting.Url;
import com.alipay.remoting.codec.ProtocolCodeBasedEncoder;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.RpcAddressParser;
import com.alipay.remoting.rpc.RpcCommandFactory;
import com.alipay.remoting.rpc.RpcConnectionEventHandler;
import com.alipay.remoting.rpc.RpcHandler;
import com.alipay.remoting.rpc.RpcRemoting;
import com.alipay.remoting.rpc.RpcResponseFuture;
import com.alipay.remoting.rpc.RpcServerRemoting;
import com.alipay.remoting.rpc.protocol.RpcProtocolDecoder;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.remoting.util.GlobalSwitch;
import com.alipay.remoting.util.RemotingUtil;
import com.alipay.remoting.util.StringUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class RpcServer
extends RemotingServer {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");
    private ServerBootstrap bootstrap;
    private ChannelFuture channelFuture;
    private GlobalSwitch globalSwitch = new GlobalSwitch();
    private ConnectionEventHandler connectionEventHandler;
    private ConnectionEventListener connectionEventListener = new ConnectionEventListener();
    private ConcurrentHashMap<String, UserProcessor<?>> userProcessors = new ConcurrentHashMap(4);
    private final EventLoopGroup bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("Rpc-netty-server-boss", false));
    private static final NioEventLoopGroup workerGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2, (ThreadFactory)new NamedThreadFactory("Rpc-netty-server-worker", true));
    private RemotingAddressParser addressParser;
    private DefaultConnectionManager connectionManager;
    protected RpcRemoting rpcRemoting;

    public RpcServer(int port) {
        super(port);
    }

    public RpcServer(int port, boolean manageConnection) {
        this(port);
        if (manageConnection) {
            this.globalSwitch.turnOn(2);
        }
    }

    public RpcServer(int port, boolean manageConnection, boolean syncStop) {
        this(port, manageConnection);
        if (syncStop) {
            this.globalSwitch.turnOn(3);
        }
    }

    @Override
    protected void doInit() {
        if (this.addressParser == null) {
            this.addressParser = new RpcAddressParser();
        }
        if (this.globalSwitch.isOn(2)) {
            this.connectionEventHandler = new RpcConnectionEventHandler(this.globalSwitch);
            this.connectionManager = new DefaultConnectionManager(new RandomSelectStrategy());
            this.connectionEventHandler.setConnectionManager(this.connectionManager);
            this.connectionEventHandler.setConnectionEventListener(this.connectionEventListener);
        } else {
            this.connectionEventHandler = new ConnectionEventHandler(this.globalSwitch);
            this.connectionEventHandler.setConnectionEventListener(this.connectionEventListener);
        }
        this.initRpcRemoting();
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)SystemProperties.tcp_so_backlog())).option(ChannelOption.SO_REUSEADDR, (Object)SystemProperties.tcp_so_reuseaddr())).childOption(ChannelOption.TCP_NODELAY, (Object)SystemProperties.tcp_nodelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)SystemProperties.tcp_so_keepalive());
        this.initWriteBufferWaterMark();
        if (SystemProperties.netty_buffer_pooled()) {
            ((ServerBootstrap)this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        } else {
            ((ServerBootstrap)this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT);
        }
        final boolean idleSwitch = SystemProperties.tcp_idle_switch();
        final int idleTime = SystemProperties.tcp_server_idle();
        ServerIdleHandler serverIdleHandler = new ServerIdleHandler();
        RpcHandler rpcHandler = new RpcHandler(true, this.userProcessors);
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>((ChannelHandler)serverIdleHandler, rpcHandler){
            final /* synthetic */ ChannelHandler val$serverIdleHandler;
            final /* synthetic */ RpcHandler val$rpcHandler;
            {
                this.val$serverIdleHandler = channelHandler;
                this.val$rpcHandler = rpcHandler;
            }

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new RpcProtocolDecoder(1));
                pipeline.addLast("encoder", (ChannelHandler)new ProtocolCodeBasedEncoder(ProtocolCode.fromBytes(2)));
                if (idleSwitch) {
                    pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTime, TimeUnit.MILLISECONDS));
                    pipeline.addLast("serverIdleHandler", this.val$serverIdleHandler);
                }
                pipeline.addLast("connectionEventHandler", (ChannelHandler)RpcServer.this.connectionEventHandler);
                pipeline.addLast("handler", (ChannelHandler)this.val$rpcHandler);
                this.createConnection(channel);
            }

            private void createConnection(SocketChannel channel) {
                Url url = RpcServer.this.addressParser.parse(RemotingUtil.parseRemoteAddress((Channel)channel));
                if (RpcServer.this.globalSwitch.isOn(2)) {
                    RpcServer.this.connectionManager.add(new Connection((Channel)channel, url), url.getUniqueKey());
                } else {
                    new Connection((Channel)channel, url);
                }
                channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT);
            }
        });
    }

    @Override
    protected boolean doStart() throws InterruptedException {
        this.channelFuture = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port)).sync();
        return this.channelFuture.isSuccess();
    }

    @Override
    protected boolean doStart(String ip) throws InterruptedException {
        this.channelFuture = this.bootstrap.bind((SocketAddress)new InetSocketAddress(ip, this.port)).sync();
        return this.channelFuture.isSuccess();
    }

    @Override
    protected void doStop() {
        if (null != this.channelFuture) {
            this.channelFuture.channel().close();
        }
        if (this.globalSwitch.isOn(3)) {
            this.bossGroup.shutdownGracefully().awaitUninterruptibly();
        } else {
            this.bossGroup.shutdownGracefully();
        }
        if (this.globalSwitch.isOn(2)) {
            this.connectionManager.removeAll();
            logger.warn("Close all connections from server side!");
        }
        logger.warn("Rpc Server stopped!");
    }

    protected void initRpcRemoting() {
        this.rpcRemoting = new RpcServerRemoting(new RpcCommandFactory(), this.addressParser, this.connectionManager);
    }

    @Override
    public void registerProcessor(byte protocolCode, CommandCode cmd, RemotingProcessor<?> processor) {
        ProtocolManager.getProtocol(ProtocolCode.fromBytes(protocolCode)).getCommandHandler().registerProcessor(cmd, processor);
    }

    @Override
    public void registerDefaultExecutor(byte protocolCode, ExecutorService executor) {
        ProtocolManager.getProtocol(ProtocolCode.fromBytes(protocolCode)).getCommandHandler().registerDefaultExecutor(executor);
    }

    public void addConnectionEventProcessor(ConnectionEventType type, ConnectionEventProcessor processor) {
        this.connectionEventListener.addConnectionEventProcessor(type, processor);
    }

    @Override
    public void registerUserProcessor(UserProcessor<?> processor) {
        if (processor == null || StringUtils.isBlank(processor.interest())) {
            throw new RuntimeException("User processor or processor interest should not be blank!");
        }
        UserProcessor<?> preProcessor = this.userProcessors.putIfAbsent(processor.interest(), processor);
        if (preProcessor != null) {
            String errMsg = "Processor with interest key [" + processor.interest() + "] has already been registered to rpc server, can not register again!";
            throw new RuntimeException(errMsg);
        }
    }

    public void oneway(String addr, Object request) throws RemotingException, InterruptedException {
        this.check();
        this.rpcRemoting.oneway(addr, request, null);
    }

    public void oneway(String addr, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        this.check();
        this.rpcRemoting.oneway(addr, request, invokeContext);
    }

    public void oneway(Url url, Object request) throws RemotingException, InterruptedException {
        this.check();
        this.rpcRemoting.oneway(url, request, null);
    }

    public void oneway(Url url, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        this.check();
        this.rpcRemoting.oneway(url, request, invokeContext);
    }

    public void oneway(Connection conn, Object request) throws RemotingException {
        this.rpcRemoting.oneway(conn, request, null);
    }

    public void oneway(Connection conn, Object request, InvokeContext invokeContext) throws RemotingException {
        this.rpcRemoting.oneway(conn, request, invokeContext);
    }

    public Object invokeSync(String addr, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        return this.rpcRemoting.invokeSync(addr, request, null, timeoutMillis);
    }

    public Object invokeSync(String addr, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        return this.rpcRemoting.invokeSync(addr, request, invokeContext, timeoutMillis);
    }

    public Object invokeSync(Url url, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        return this.rpcRemoting.invokeSync(url, request, null, timeoutMillis);
    }

    public Object invokeSync(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        return this.rpcRemoting.invokeSync(url, request, invokeContext, timeoutMillis);
    }

    public Object invokeSync(Connection conn, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeSync(conn, request, null, timeoutMillis);
    }

    public Object invokeSync(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeSync(conn, request, invokeContext, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(String addr, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        return this.rpcRemoting.invokeWithFuture(addr, request, null, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(String addr, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        return this.rpcRemoting.invokeWithFuture(addr, request, invokeContext, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Url url, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        return this.rpcRemoting.invokeWithFuture(url, request, null, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        return this.rpcRemoting.invokeWithFuture(url, request, invokeContext, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Connection conn, Object request, int timeoutMillis) throws RemotingException {
        return this.rpcRemoting.invokeWithFuture(conn, request, null, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException {
        return this.rpcRemoting.invokeWithFuture(conn, request, invokeContext, timeoutMillis);
    }

    public void invokeWithCallback(String addr, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        this.rpcRemoting.invokeWithCallback(addr, request, null, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(String addr, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        this.rpcRemoting.invokeWithCallback(addr, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Url url, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        this.rpcRemoting.invokeWithCallback(url, request, null, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Url url, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.check();
        this.rpcRemoting.invokeWithCallback(url, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Connection conn, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException {
        this.rpcRemoting.invokeWithCallback(conn, request, null, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Connection conn, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException {
        this.rpcRemoting.invokeWithCallback(conn, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public boolean isConnected(String remoteAddr) {
        Url url = this.rpcRemoting.addressParser.parse(remoteAddr);
        return this.isConnected(url);
    }

    public boolean isConnected(Url url) {
        Connection conn = this.rpcRemoting.connectionManager.get(url.getUniqueKey());
        if (null != conn) {
            return conn.isFine();
        }
        return false;
    }

    private void check() {
        if (!this.globalSwitch.isOn(2)) {
            throw new UnsupportedOperationException("Please enable connection manage feature of Rpc Server before call this method! See comments in constructor RpcServer(int port, boolean manageConnection) to find how to enable!");
        }
    }

    private void initWriteBufferWaterMark() {
        int highWaterMark;
        int lowWaterMark = SystemProperties.netty_buffer_low_watermark();
        if (lowWaterMark > (highWaterMark = SystemProperties.netty_buffer_high_watermark())) {
            throw new IllegalArgumentException(String.format("[server side] bolt netty high water mark {%s} should not be smaller than low water mark {%s} bytes)", highWaterMark, lowWaterMark));
        }
        logger.warn("[server side] bolt netty low water mark is {} bytes, high water mark is {} bytes", (Object)lowWaterMark, (Object)highWaterMark);
        this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(lowWaterMark, highWaterMark));
    }

    public RemotingAddressParser getAddressParser() {
        return this.addressParser;
    }

    public void setAddressParser(RemotingAddressParser addressParser) {
        this.addressParser = addressParser;
    }

    public DefaultConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    static {
        workerGroup.setIoRatio(SystemProperties.netty_io_ratio());
    }
}

