/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.AbstractTypeReference;
import org.springframework.aot.hint.TypeReference;
import org.springframework.util.Assert;

final class ReflectionTypeReference
extends AbstractTypeReference {
    private final Class<?> type;

    private ReflectionTypeReference(Class<?> type) {
        super(type.getPackageName(), type.getSimpleName(), ReflectionTypeReference.getEnclosingClass(type));
        this.type = type;
    }

    private static @Nullable TypeReference getEnclosingClass(Class<?> type) {
        Class<?> candidate = type.isArray() ? ((Class)type.componentType()).getEnclosingClass() : type.getEnclosingClass();
        return candidate != null ? new ReflectionTypeReference(candidate) : null;
    }

    static ReflectionTypeReference of(Class<?> type) {
        Assert.notNull(type, "'type' must not be null");
        Assert.notNull((Object)type.getCanonicalName(), "'type.getCanonicalName()' must not be null");
        return new ReflectionTypeReference(type);
    }

    @Override
    public String getCanonicalName() {
        return this.type.getCanonicalName();
    }

    @Override
    protected boolean isPrimitive() {
        return this.type.isPrimitive() || this.type.isArray() && ((Class)this.type.componentType()).isPrimitive();
    }
}

