/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.springframework.data.relational.core.sql.AbstractImportValidator;
import org.springframework.data.relational.core.sql.AsteriskFromTable;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Join;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Visitable;

class SelectValidator
extends AbstractImportValidator {
    private final Stack<Select> selects = new Stack();
    private int selectFieldCount;
    private Set<Table> requiredBySelect = new HashSet<Table>();
    private Set<Table> requiredByOrderBy = new HashSet<Table>();
    private Set<Table> join = new HashSet<Table>();

    SelectValidator() {
    }

    public static void validate(Select select) {
        new SelectValidator().doValidate(select);
    }

    private void doValidate(Select select) {
        select.visit(this);
        if (this.selectFieldCount == 0) {
            throw new IllegalStateException("SELECT does not declare a select list");
        }
        for (Table table : this.requiredBySelect) {
            if (this.join.contains(table) || this.from.contains(table)) continue;
            throw new IllegalStateException(String.format("Required table [%s] by a SELECT column not imported by FROM %s or JOIN %s", table, this.from, this.join));
        }
        for (Table table : this.requiredByWhere) {
            if (this.join.contains(table) || this.from.contains(table)) continue;
            throw new IllegalStateException(String.format("Required table [%s] by a WHERE predicate not imported by FROM %s or JOIN %s", table, this.from, this.join));
        }
        for (Table table : this.requiredByOrderBy) {
            if (this.join.contains(table) || this.from.contains(table)) continue;
            throw new IllegalStateException(String.format("Required table [%s] by a ORDER BY column not imported by FROM %s or JOIN %s", table, this.from, this.join));
        }
    }

    @Override
    public void enter(Visitable segment) {
        Table table;
        if (segment instanceof Select) {
            this.selects.push((Select)segment);
        }
        if (this.selects.size() > 1) {
            return;
        }
        if (segment instanceof Expression && this.parent instanceof Select) {
            ++this.selectFieldCount;
        }
        if (segment instanceof AsteriskFromTable && this.parent instanceof Select) {
            table = ((AsteriskFromTable)segment).getTable();
            this.requiredBySelect.add(table);
        }
        if (segment instanceof Column && (this.parent instanceof Select || this.parent instanceof SimpleFunction) && (table = ((Column)segment).getTable()) != null) {
            this.requiredBySelect.add(table);
        }
        if (segment instanceof Column && this.parent instanceof OrderByField && (table = ((Column)segment).getTable()) != null) {
            this.requiredByOrderBy.add(table);
        }
        if (segment instanceof Table && this.parent instanceof Join) {
            this.join.add((Table)segment);
        }
        super.enter(segment);
    }

    @Override
    public void leave(Visitable segment) {
        if (segment instanceof Select) {
            this.selects.remove(segment);
        }
        if (this.selects.size() > 1) {
            return;
        }
        super.leave(segment);
    }
}

