/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveZSetOperations<K, V> {
    public Mono<Boolean> add(K var1, V var2, double var3);

    public Mono<Long> addAll(K var1, Collection<? extends ZSetOperations.TypedTuple<V>> var2);

    public Mono<Long> remove(K var1, Object ... var2);

    public Mono<Double> incrementScore(K var1, V var2, double var3);

    public Mono<Long> rank(K var1, Object var2);

    public Mono<Long> reverseRank(K var1, Object var2);

    public Flux<V> range(K var1, Range<Long> var2);

    public Flux<ZSetOperations.TypedTuple<V>> rangeWithScores(K var1, Range<Long> var2);

    public Flux<V> rangeByScore(K var1, Range<Double> var2);

    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K var1, Range<Double> var2);

    public Flux<V> rangeByScore(K var1, Range<Double> var2, RedisZSetCommands.Limit var3);

    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K var1, Range<Double> var2, RedisZSetCommands.Limit var3);

    public Flux<V> reverseRange(K var1, Range<Long> var2);

    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(K var1, Range<Long> var2);

    public Flux<V> reverseRangeByScore(K var1, Range<Double> var2);

    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K var1, Range<Double> var2);

    public Flux<V> reverseRangeByScore(K var1, Range<Double> var2, RedisZSetCommands.Limit var3);

    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K var1, Range<Double> var2, RedisZSetCommands.Limit var3);

    default public Flux<ZSetOperations.TypedTuple<V>> scan(K key) {
        return this.scan(key, ScanOptions.NONE);
    }

    public Flux<ZSetOperations.TypedTuple<V>> scan(K var1, ScanOptions var2);

    public Mono<Long> count(K var1, Range<Double> var2);

    public Mono<Long> lexCount(K var1, Range<String> var2);

    public Mono<Long> size(K var1);

    public Mono<Double> score(K var1, Object var2);

    public Mono<Long> removeRange(K var1, Range<Long> var2);

    public Mono<Long> removeRangeByLex(K var1, Range<String> var2);

    public Mono<Long> removeRangeByScore(K var1, Range<Double> var2);

    public Mono<Long> unionAndStore(K var1, K var2, K var3);

    public Mono<Long> unionAndStore(K var1, Collection<K> var2, K var3);

    default public Mono<Long> unionAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.unionAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Mono<Long> unionAndStore(K var1, Collection<K> var2, K var3, RedisZSetCommands.Aggregate var4, RedisZSetCommands.Weights var5);

    public Mono<Long> intersectAndStore(K var1, K var2, K var3);

    public Mono<Long> intersectAndStore(K var1, Collection<K> var2, K var3);

    default public Mono<Long> intersectAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.intersectAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Mono<Long> intersectAndStore(K var1, Collection<K> var2, K var3, RedisZSetCommands.Aggregate var4, RedisZSetCommands.Weights var5);

    public Flux<V> rangeByLex(K var1, Range<String> var2);

    public Flux<V> rangeByLex(K var1, Range<String> var2, RedisZSetCommands.Limit var3);

    public Flux<V> reverseRangeByLex(K var1, Range<String> var2);

    public Flux<V> reverseRangeByLex(K var1, Range<String> var2, RedisZSetCommands.Limit var3);

    public Mono<Boolean> delete(K var1);
}

