/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.jdbc.core.convert.Jsr310TimestampBasedConverters;
import org.springframework.data.jdbc.core.mapping.JdbcSimpleTypes;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class JdbcCustomConversions
extends CustomConversions {
    private static final List<Object> STORE_CONVERTERS = Arrays.asList(Jsr310TimestampBasedConverters.getConvertersToRegister().toArray());
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)JdbcSimpleTypes.HOLDER, STORE_CONVERTERS);

    public JdbcCustomConversions() {
        this(Collections.emptyList());
    }

    public JdbcCustomConversions(List<?> converters) {
        super(new CustomConversions.ConverterConfiguration(STORE_CONVERSIONS, converters, JdbcCustomConversions::isDateTimeApiConversion));
    }

    public JdbcCustomConversions(CustomConversions.ConverterConfiguration converterConfiguration) {
        super(converterConfiguration);
    }

    private static boolean isDateTimeApiConversion(GenericConverter.ConvertiblePair cp) {
        if (cp.getSourceType().equals(Date.class)) {
            return cp.getTargetType().getTypeName().startsWith("java.time.");
        }
        if (cp.getTargetType().equals(Date.class)) {
            return cp.getSourceType().getTypeName().startsWith("java.time.");
        }
        return true;
    }
}

