/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.lang.Nullable;

public interface IndexOperations {
    public boolean create();

    public boolean create(Map<String, Object> var1);

    public boolean create(Map<String, Object> var1, Document var2);

    public boolean createWithMapping();

    public boolean delete();

    public boolean exists();

    public void refresh();

    public Document createMapping();

    public Document createMapping(Class<?> var1);

    default public boolean putMapping() {
        return this.putMapping(this.createMapping());
    }

    public boolean putMapping(Document var1);

    default public boolean putMapping(Class<?> clazz) {
        return this.putMapping(this.createMapping(clazz));
    }

    public Map<String, Object> getMapping();

    public Settings createSettings();

    public Settings createSettings(Class<?> var1);

    public Settings getSettings();

    public Settings getSettings(boolean var1);

    public boolean alias(AliasActions var1);

    public Map<String, Set<AliasData>> getAliases(String ... var1);

    public Map<String, Set<AliasData>> getAliasesForIndex(String ... var1);

    public boolean putTemplate(PutTemplateRequest var1);

    @Nullable
    default public TemplateData getTemplate(String templateName) {
        return this.getTemplate(new GetTemplateRequest(templateName));
    }

    @Nullable
    public TemplateData getTemplate(GetTemplateRequest var1);

    default public boolean existsTemplate(String templateName) {
        return this.existsTemplate(new ExistsTemplateRequest(templateName));
    }

    public boolean existsTemplate(ExistsTemplateRequest var1);

    default public boolean deleteTemplate(String templateName) {
        return this.deleteTemplate(new DeleteTemplateRequest(templateName));
    }

    public boolean deleteTemplate(DeleteTemplateRequest var1);

    default public List<IndexInformation> getInformation() {
        return this.getInformation(this.getIndexCoordinates());
    }

    public List<IndexInformation> getInformation(IndexCoordinates var1);

    public IndexCoordinates getIndexCoordinates();
}

