/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsIterator;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.lang.Nullable;

public interface SearchOperations {
    default public long count(Query query, IndexCoordinates index) {
        return this.count(query, null, index);
    }

    public long count(Query var1, Class<?> var2);

    public long count(Query var1, @Nullable Class<?> var2, IndexCoordinates var3);

    public SearchResponse suggest(SuggestBuilder var1, Class<?> var2);

    public SearchResponse suggest(SuggestBuilder var1, IndexCoordinates var2);

    @Nullable
    default public <T> SearchHit<T> searchOne(Query query, Class<T> clazz) {
        List<SearchHit<T>> content = this.search(query, clazz).getSearchHits();
        return content.isEmpty() ? null : content.get(0);
    }

    @Nullable
    default public <T> SearchHit<T> searchOne(Query query, Class<T> clazz, IndexCoordinates index) {
        List<SearchHit<T>> content = this.search(query, clazz, index).getSearchHits();
        return content.isEmpty() ? null : content.get(0);
    }

    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> var1, Class<T> var2);

    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> var1, Class<T> var2, IndexCoordinates var3);

    public List<SearchHits<?>> multiSearch(List<? extends Query> var1, List<Class<?>> var2);

    public List<SearchHits<?>> multiSearch(List<? extends Query> var1, List<Class<?>> var2, IndexCoordinates var3);

    public <T> SearchHits<T> search(Query var1, Class<T> var2);

    public <T> SearchHits<T> search(Query var1, Class<T> var2, IndexCoordinates var3);

    public <T> SearchHits<T> search(MoreLikeThisQuery var1, Class<T> var2);

    public <T> SearchHits<T> search(MoreLikeThisQuery var1, Class<T> var2, IndexCoordinates var3);

    public <T> SearchHitsIterator<T> searchForStream(Query var1, Class<T> var2);

    public <T> SearchHitsIterator<T> searchForStream(Query var1, Class<T> var2, IndexCoordinates var3);
}

