/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.annotations.Parent;
import org.springframework.data.elasticsearch.annotations.Score;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchDateConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentPropertyConverter;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class SimpleElasticsearchPersistentProperty
extends AnnotationBasedPersistentProperty<ElasticsearchPersistentProperty>
implements ElasticsearchPersistentProperty {
    private static final List<String> SUPPORTED_ID_PROPERTY_NAMES = Arrays.asList("id", "document");
    private final boolean isScore;
    private final boolean isParent;
    private final boolean isId;
    private final boolean isSeqNoPrimaryTerm;
    @Nullable
    private final String annotatedFieldName = this.getAnnotatedFieldName();
    @Nullable
    private ElasticsearchPersistentPropertyConverter propertyConverter;

    public SimpleElasticsearchPersistentProperty(Property property, PersistentEntity<?, ElasticsearchPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        this.isId = super.isIdProperty() || SUPPORTED_ID_PROPERTY_NAMES.contains(this.getFieldName());
        this.isScore = this.isAnnotationPresent(Score.class);
        this.isParent = this.isAnnotationPresent(Parent.class);
        this.isSeqNoPrimaryTerm = SeqNoPrimaryTerm.class.isAssignableFrom(this.getRawType());
        if (this.isVersionProperty() && !this.getType().equals(Long.class)) {
            throw new MappingException(String.format("Version property %s must be of type Long!", property.getName()));
        }
        if (this.isScore && !this.getType().equals(Float.TYPE) && !this.getType().equals(Float.class)) {
            throw new MappingException(String.format("Score property %s must be either of type float or Float!", property.getName()));
        }
        if (this.isParent && !this.getType().equals(String.class)) {
            throw new MappingException(String.format("Parent property %s must be of type String!", property.getName()));
        }
        if (this.isAnnotationPresent(Field.class) && this.isAnnotationPresent(MultiField.class)) {
            throw new MappingException("@Field annotation must not be used on a @MultiField property.");
        }
        this.initDateConverter();
    }

    @Override
    public boolean hasPropertyConverter() {
        return this.propertyConverter != null;
    }

    @Override
    @Nullable
    public ElasticsearchPersistentPropertyConverter getPropertyConverter() {
        return this.propertyConverter;
    }

    public boolean isWritable() {
        return super.isWritable() && !this.isSeqNoPrimaryTermProperty();
    }

    @Override
    public boolean isReadable() {
        return !this.isTransient() && !this.isSeqNoPrimaryTermProperty();
    }

    private void initDateConverter() {
        Field field = (Field)this.findAnnotation(Field.class);
        final boolean isTemporalAccessor = TemporalAccessor.class.isAssignableFrom(this.getType());
        boolean isDate = Date.class.isAssignableFrom(this.getType());
        if (field != null && (field.type() == FieldType.Date || field.type() == FieldType.Date_Nanos) && (isTemporalAccessor || isDate)) {
            DateFormat dateFormat = field.format();
            if (dateFormat == DateFormat.none) {
                throw new MappingException(String.format("Property %s is annotated with FieldType.%s but has no DateFormat defined", this.getOwner().getType().getSimpleName() + "." + this.getName(), field.type().name()));
            }
            ElasticsearchDateConverter converter = null;
            if (dateFormat == DateFormat.custom) {
                String pattern = field.pattern();
                if (StringUtils.hasLength((String)pattern)) {
                    converter = ElasticsearchDateConverter.of(pattern);
                }
            } else if (dateFormat != DateFormat.none) {
                converter = ElasticsearchDateConverter.of(dateFormat);
            }
            if (converter != null) {
                final ElasticsearchDateConverter dateConverter = converter;
                this.propertyConverter = new ElasticsearchPersistentPropertyConverter(){

                    @Override
                    public String write(Object property) {
                        if (isTemporalAccessor) {
                            return dateConverter.format((TemporalAccessor)property);
                        }
                        return dateConverter.format((Date)property);
                    }

                    @Override
                    public Object read(String s) {
                        if (isTemporalAccessor) {
                            return dateConverter.parse(s, SimpleElasticsearchPersistentProperty.this.getType());
                        }
                        return dateConverter.parse(s);
                    }
                };
            }
        }
    }

    @Nullable
    private String getAnnotatedFieldName() {
        String name = null;
        if (this.isAnnotationPresent(Field.class)) {
            name = ((Field)this.findAnnotation(Field.class)).name();
        } else if (this.isAnnotationPresent(MultiField.class)) {
            name = ((MultiField)this.findAnnotation(MultiField.class)).mainField().name();
        }
        return StringUtils.hasText((String)name) ? name : null;
    }

    @Override
    public String getFieldName() {
        return this.annotatedFieldName == null ? this.getProperty().getName() : this.annotatedFieldName;
    }

    public boolean isIdProperty() {
        return this.isId;
    }

    protected Association<ElasticsearchPersistentProperty> createAssociation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isScoreProperty() {
        return this.isScore;
    }

    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isParentProperty() {
        return this.isParent;
    }

    @Override
    public boolean isSeqNoPrimaryTermProperty() {
        return this.isSeqNoPrimaryTerm;
    }
}

