/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.config.TypeFilterParser;
import org.springframework.data.repository.config.RepositoryConfigurationSourceSupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.util.ParsingUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class XmlRepositoryConfigurationSource
extends RepositoryConfigurationSourceSupport {
    private static final String QUERY_LOOKUP_STRATEGY = "query-lookup-strategy";
    private static final String BASE_PACKAGE = "base-package";
    private static final String NAMED_QUERIES_LOCATION = "named-queries-location";
    private static final String REPOSITORY_IMPL_POSTFIX = "repository-impl-postfix";
    private static final String REPOSITORY_FACTORY_BEAN_CLASS_NAME = "factory-class";
    private static final String REPOSITORY_BASE_CLASS_NAME = "base-class";
    private static final String CONSIDER_NESTED_REPOSITORIES = "consider-nested-repositories";
    private final Element element;
    private final ParserContext context;
    private final Collection<TypeFilter> includeFilters;
    private final Collection<TypeFilter> excludeFilters;

    public XmlRepositoryConfigurationSource(Element element, ParserContext context, Environment environment) {
        super(environment, context.getRegistry());
        Assert.notNull((Object)element, (String)"Element must not be null!");
        this.element = element;
        this.context = context;
        TypeFilterParser parser = new TypeFilterParser(context.getReaderContext());
        this.includeFilters = parser.parseTypeFilters(element, TypeFilterParser.Type.INCLUDE);
        this.excludeFilters = parser.parseTypeFilters(element, TypeFilterParser.Type.EXCLUDE);
    }

    @Override
    public Object getSource() {
        return this.context.extractSource((Object)this.element);
    }

    @Override
    public Iterable<String> getBasePackages() {
        String attribute = this.element.getAttribute(BASE_PACKAGE);
        return Arrays.asList(StringUtils.delimitedListToStringArray((String)attribute, (String)",", (String)" "));
    }

    @Override
    public Object getQueryLookupStrategyKey() {
        return QueryLookupStrategy.Key.create(this.getNullDefaultedAttribute(this.element, QUERY_LOOKUP_STRATEGY));
    }

    @Override
    public String getNamedQueryLocation() {
        return this.getNullDefaultedAttribute(this.element, NAMED_QUERIES_LOCATION);
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public Iterable<TypeFilter> getExcludeFilters() {
        return this.excludeFilters;
    }

    @Override
    protected Iterable<TypeFilter> getIncludeFilters() {
        return this.includeFilters;
    }

    @Override
    public String getRepositoryImplementationPostfix() {
        return this.getNullDefaultedAttribute(this.element, REPOSITORY_IMPL_POSTFIX);
    }

    @Override
    public String getRepositoryFactoryBeanName() {
        return this.getNullDefaultedAttribute(this.element, REPOSITORY_FACTORY_BEAN_CLASS_NAME);
    }

    @Override
    public String getRepositoryBaseClassName() {
        return this.getNullDefaultedAttribute(this.element, REPOSITORY_BASE_CLASS_NAME);
    }

    private String getNullDefaultedAttribute(Element element, String attributeName) {
        String attribute = element.getAttribute(attributeName);
        return StringUtils.hasText((String)attribute) ? attribute : null;
    }

    @Override
    public boolean shouldConsiderNestedRepositories() {
        String attribute = this.getNullDefaultedAttribute(this.element, CONSIDER_NESTED_REPOSITORIES);
        return attribute != null && Boolean.parseBoolean(attribute);
    }

    @Override
    public String getAttribute(String name) {
        String xmlAttributeName = ParsingUtils.reconcatenateCamelCase(name, "-");
        String attribute = this.element.getAttribute(xmlAttributeName);
        return StringUtils.hasText((String)attribute) ? attribute : null;
    }

    @Override
    public boolean usesExplicitFilters() {
        return !this.includeFilters.isEmpty() || !this.excludeFilters.isEmpty();
    }
}

