/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class ConsoleLogAdapter
implements LogAdapter {
    private static boolean debugEnabled = false;
    private static boolean infoEnabled = false;
    private static boolean warnEnabled = true;
    private static DateFormat dateAndTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public void debug(Serializable message) {
        if (debugEnabled) {
            ConsoleLogAdapter.log(System.out, LogLevel.DEBUG.toString(), message.toString());
        }
    }

    @Override
    public void error(Serializable message) {
        ConsoleLogAdapter.log(System.err, LogLevel.ERROR.toString(), message.toString());
    }

    @Override
    public void error(CharSequence message, Throwable throwable) {
        ConsoleLogAdapter.log(System.err, LogLevel.ERROR.toString(), message.toString());
    }

    @Override
    public void fatal(Object message) {
        ConsoleLogAdapter.log(System.err, LogLevel.FATAL.toString(), message.toString());
    }

    @Override
    public void fatal(CharSequence message, Throwable throwable) {
        ConsoleLogAdapter.log(System.err, LogLevel.FATAL.toString(), message.toString());
    }

    @Override
    public void info(CharSequence message) {
        if (infoEnabled || debugEnabled) {
            ConsoleLogAdapter.log(System.out, LogLevel.INFO.toString(), message.toString());
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return debugEnabled;
    }

    @Override
    public boolean isInfoEnabled() {
        return infoEnabled || debugEnabled;
    }

    @Override
    public boolean isWarnEnabled() {
        return warnEnabled || infoEnabled || debugEnabled;
    }

    @Override
    public void warn(Serializable message) {
        if (warnEnabled) {
            ConsoleLogAdapter.log(System.out, LogLevel.WARN.toString(), message.toString());
        }
    }

    public static void setDebugEnabled(boolean isDebugEnabled) {
        debugEnabled = isDebugEnabled;
    }

    public static void setWarnEnabled(boolean isWarnEnabled) {
        warnEnabled = isWarnEnabled;
    }

    public static void setInfoEnabled(boolean isInfoEnabled) {
        infoEnabled = isInfoEnabled;
    }

    @Override
    public void setLogLevel(LogLevel level) {
        debugEnabled = false;
        warnEnabled = false;
        infoEnabled = false;
        switch (level.getLevel()) {
            case 2: 
            case 3: 
            case 4: {
                debugEnabled = true;
                warnEnabled = true;
                infoEnabled = true;
                break;
            }
            case 5: {
                infoEnabled = true;
                warnEnabled = true;
                break;
            }
            case 6: {
                warnEnabled = true;
                break;
            }
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public LogLevel getLogLevel() {
        if (debugEnabled) {
            return LogLevel.DEBUG;
        }
        if (infoEnabled) {
            return LogLevel.INFO;
        }
        if (warnEnabled) {
            return LogLevel.WARN;
        }
        return LogLevel.OFF;
    }

    @Override
    public LogLevel getEffectiveLogLevel() {
        return this.getLogLevel();
    }

    @Override
    public Iterator<?> getLogHandler() {
        return Collections.EMPTY_LIST.iterator();
    }

    public static DateFormat getDateAndTimeFormat() {
        return dateAndTimeFormat;
    }

    public static void setDateAndTimeFormat(DateFormat dateAndTimeFormat) {
        ConsoleLogAdapter.dateAndTimeFormat = dateAndTimeFormat;
    }

    private static void log(PrintStream printStream, String level, String message) {
        if (dateAndTimeFormat != null) {
            String msg = dateAndTimeFormat.format(new Date()) + ' ' + Thread.currentThread().getName() + ' ' + level + ' ' + message;
            printStream.println(msg);
        } else {
            printStream.println(message);
        }
    }

    public String toString() {
        return this.getName();
    }
}

