/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import org.scalatest.Report;
import org.scalatest.Reporter;
import org.scalatest.Rerunnable;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

public class TestRerunner
implements Rerunnable,
ScalaObject {
    private String testName;
    private String suiteClassName;

    public TestRerunner(String suiteClassName, String testName) {
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        String string = suiteClassName;
        if (string == null || string.equals(null) || (string = testName) == null || string.equals(null)) {
            throw new NullPointerException();
        }
    }

    public void rerun(Reporter reporter, Stopper stopper, Set includes, Set excludes, Map properties, Option distributor, ClassLoader loader) {
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            reporter.runStarting(1);
            suite.execute((Option)new Some((Object)this.testName), reporter, stopper, includes, excludes, properties, distributor);
            reporter.runCompleted();
        }
        catch (Throwable throwable) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("bigProblems"), (Option)new Some((Object)throwable), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotLoadClass"), (Option)new Some((Object)noClassDefFoundError), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (SecurityException securityException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("securityWhenReruning"), (Option)new Some((Object)securityException), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotFindMethod"), (Option)new Some((Object)noSuchMethodException), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (IllegalAccessException illegalAccessException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotInstantiateSuite"), (Option)new Some((Object)illegalAccessException), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (InstantiationException instantiationException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotInstantiateSuite"), (Option)new Some((Object)instantiationException), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report report = new Report("org.scalatest.TestRerunner", Resources$.MODULE$.apply("cannotLoadSuite"), (Option)new Some((Object)classNotFoundException), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

