/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import org.scalatest.Report;
import org.scalatest.Reporter;
import org.scalatest.Rerunnable;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Suite$;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

public class SuiteRerunner
implements Rerunnable,
ScalaObject {
    private String suiteClassName;

    public SuiteRerunner(String suiteClassName) {
        this.suiteClassName = suiteClassName;
        String string = suiteClassName;
        if (string == null || string.equals(null)) {
            throw new NullPointerException();
        }
    }

    public void rerun(Reporter reporter, Stopper stopper, Set includes, Set excludes, Map properties, Option distributor, ClassLoader loader) {
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            int expectedTestCount = suite.expectedTestCount(includes, excludes);
            None$ rerunnable = Suite$.MODULE$.checkForPublicNoArgConstructor(suite.getClass()) ? new Some((Object)new SuiteRerunner(suite.getClass().getName())) : None$.MODULE$;
            reporter.runStarting(expectedTestCount);
            try {
                String rawString = Resources$.MODULE$.apply("suiteExecutionStarting");
                reporter.suiteStarting(new Report(suite.suiteName(), rawString, (Option)None$.MODULE$, (Option)rerunnable));
                suite.execute((Option)None$.MODULE$, reporter, stopper, includes, excludes, properties, distributor);
                String rawString2 = Resources$.MODULE$.apply("suiteCompletedNormally");
                reporter.suiteCompleted(new Report(suite.suiteName(), rawString2, (Option)None$.MODULE$, (Option)rerunnable));
            }
            catch (RuntimeException runtimeException) {
                String rawString = Resources$.MODULE$.apply("executeException");
                reporter.suiteAborted(new Report(suite.suiteName(), rawString, (Option)new Some((Object)runtimeException), (Option)rerunnable));
            }
            if (stopper.stopRequested()) {
                reporter.runStopped();
            } else {
                reporter.runCompleted();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report report = new Report("org.scalatest.Runner", Resources$.MODULE$.apply("cannotLoadSuite"), (Option)new Some((Object)classNotFoundException), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (InstantiationException instantiationException) {
            Report report = new Report("org.scalatest.Runner", Resources$.MODULE$.apply("cannotInstantiateSuite"), (Option)new Some((Object)instantiationException), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (IllegalAccessException illegalAccessException) {
            Report report = new Report("org.scalatest.Runner", Resources$.MODULE$.apply("cannotInstantiateSuite"), (Option)new Some((Object)illegalAccessException), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (SecurityException securityException) {
            Report report = new Report("org.scalatest.Runner", Resources$.MODULE$.apply("securityWhenReruning"), (Option)new Some((Object)securityException), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Report report = new Report("org.scalatest.Runner", Resources$.MODULE$.apply("cannotLoadClass"), (Option)new Some((Object)noClassDefFoundError), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
        catch (Throwable throwable) {
            Report report = new Report("org.scalatest.Runner", Resources$.MODULE$.apply("bigProblems"), (Option)new Some((Object)throwable), (Option)None$.MODULE$);
            reporter.runAborted(report);
        }
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

