/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import org.apache.fury.Fury;
import org.apache.fury.ThreadSafeFury;
import org.apache.fury.config.FuryBuilder;
import org.apache.fury.config.Language;
import org.apache.fury.io.FuryStreamReader;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FuryCodec
extends BaseCodec {
    static final Logger log = LoggerFactory.getLogger(FuryCodec.class);
    private final ThreadSafeFury fury;
    private final Set<String> allowedClasses;
    private final Language language;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            if (buf.nioBufferCount() == 1) {
                MemoryBuffer furyBuffer = MemoryUtils.wrap((ByteBuffer)buf.nioBuffer());
                try {
                    Object object = FuryCodec.this.fury.deserialize(furyBuffer);
                    return object;
                }
                finally {
                    buf.readerIndex(buf.readerIndex() + furyBuffer.readerIndex());
                }
            }
            return FuryCodec.this.fury.deserialize(FuryStreamReader.of((InputStream)new ByteBufInputStream(buf)));
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            MemoryBuffer furyBuffer = null;
            int remainingSize = out.capacity() - out.writerIndex();
            if (out.hasArray()) {
                furyBuffer = MemoryUtils.wrap((byte[])out.array(), (int)(out.arrayOffset() + out.writerIndex()), (int)remainingSize);
            } else if (out.hasMemoryAddress()) {
                furyBuffer = MemoryUtils.buffer((long)(out.memoryAddress() + (long)out.writerIndex()), (int)remainingSize);
            }
            if (furyBuffer != null) {
                int size = furyBuffer.size();
                FuryCodec.this.fury.serialize(furyBuffer, in);
                if (furyBuffer.size() > size) {
                    out.writeBytes(furyBuffer.getHeapMemory(), 0, furyBuffer.size());
                } else {
                    out.writerIndex(out.writerIndex() + furyBuffer.writerIndex());
                }
                return out;
            }
            try {
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                FuryCodec.this.fury.serialize((OutputStream)baos, in);
                return baos.buffer();
            }
            catch (Exception e) {
                out.release();
                throw e;
            }
        }
    };

    public FuryCodec() {
        this(null, Collections.emptySet(), Language.JAVA);
    }

    public FuryCodec(Set<String> allowedClasses) {
        this(null, allowedClasses, Language.JAVA);
    }

    public FuryCodec(Language language) {
        this(null, Collections.emptySet(), language);
    }

    public FuryCodec(Set<String> allowedClasses, Language language) {
        this(null, allowedClasses, language);
    }

    public FuryCodec(ClassLoader classLoader, FuryCodec codec) {
        this(classLoader, codec.allowedClasses, codec.language);
        log.warn("FuryCodec is deprecated and will be removed in future. Use ForyCodec instead.");
    }

    public FuryCodec(ClassLoader classLoader) {
        this(classLoader, Collections.emptySet(), Language.JAVA);
    }

    public FuryCodec(ClassLoader classLoader, Set<String> allowedClasses, Language language) {
        this.allowedClasses = allowedClasses;
        this.language = language;
        FuryBuilder builder = Fury.builder();
        if (classLoader != null) {
            builder.withClassLoader(classLoader);
        }
        builder.withLanguage(language);
        builder.requireClassRegistration(!allowedClasses.isEmpty());
        this.fury = builder.buildThreadSafeFuryPool(10, 512);
        for (String allowedClass : allowedClasses) {
            try {
                this.fury.register(Class.forName(allowedClass));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

