/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.junit.jupiter;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.ScopedMock;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.session.MockitoSessionLoggerAdapter;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.junit.jupiter.resolver.CaptorParameterResolver;
import org.mockito.junit.jupiter.resolver.CompositeParameterResolver;
import org.mockito.junit.jupiter.resolver.MockParameterResolver;
import org.mockito.quality.Strictness;
import org.mockito.session.MockitoSessionLogger;

public class MockitoExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace MOCKITO = ExtensionContext.Namespace.create((Object[])new Object[]{"org.mockito"});
    private static final String SESSION = "session";
    private static final String MOCKS = "mocks";
    private final Strictness strictness;
    private final ParameterResolver parameterResolver;

    public MockitoExtension() {
        this(Strictness.STRICT_STUBS);
    }

    private MockitoExtension(Strictness strictness) {
        this.strictness = strictness;
        this.parameterResolver = new CompositeParameterResolver(new MockParameterResolver(), new CaptorParameterResolver());
    }

    public void beforeEach(ExtensionContext context) {
        List testInstances = context.getRequiredTestInstances().getAllInstances();
        Strictness actualStrictness = this.retrieveAnnotationFromTestClasses(context).map(MockitoSettings::strictness).orElse(this.strictness);
        MockitoSession session = Mockito.mockitoSession().initMocks(testInstances.toArray()).strictness(actualStrictness).logger((MockitoSessionLogger)new MockitoSessionLoggerAdapter(Plugins.getMockitoLogger())).startMocking();
        context.getStore(MOCKITO).put((Object)MOCKS, new HashSet());
        context.getStore(MOCKITO).put((Object)SESSION, (Object)session);
    }

    private Optional<MockitoSettings> retrieveAnnotationFromTestClasses(ExtensionContext context) {
        Optional annotation;
        ExtensionContext currentContext = context;
        do {
            annotation = AnnotationSupport.findAnnotation((Optional)currentContext.getElement(), MockitoSettings.class);
            if (currentContext.getParent().isEmpty()) break;
            currentContext = (ExtensionContext)currentContext.getParent().get();
        } while (annotation.isEmpty() && currentContext != context.getRoot());
        return annotation;
    }

    public void afterEach(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(MOCKITO);
        Optional.ofNullable((Set)store.remove((Object)MOCKS, Set.class)).ifPresent(mocks -> mocks.forEach(mock -> ((ScopedMock)mock).closeOnDemand()));
        Optional.ofNullable((MockitoSession)store.remove((Object)SESSION, MockitoSession.class)).ifPresent(session -> session.finishMocking((Throwable)context.getExecutionException().orElse(null)));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return this.parameterResolver.supportsParameter(parameterContext, context);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        Object resolvedParameter = this.parameterResolver.resolveParameter(parameterContext, context);
        if (resolvedParameter instanceof ScopedMock) {
            ((Set)context.getStore(MOCKITO).get((Object)MOCKS, Set.class)).add(resolvedParameter);
        }
        return resolvedParameter;
    }
}

